/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.common.datacleaner.rest;

import com.google.gson.Gson;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerRuleModel;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerRuleService;
import de.actonic.confluence.gdpr.util.Maps;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/data-cleaner-template/rules")
@Produces(value={"application/json"})
public class DataCleanerRuleRest {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerRuleRest.class);
    private DataCleanerRuleService dataCleanerRuleService;

    @Autowired
    public DataCleanerRuleRest(DataCleanerRuleService dataCleanerRuleService) {
        this.dataCleanerRuleService = dataCleanerRuleService;
    }

    private Response toJsonOkResponse(Object obj) {
        return Response.ok((Object)new Gson().toJson(obj)).build();
    }

    @PUT
    @Path(value="/")
    @Consumes(value={"application/json"})
    public Response createRule(DataCleanerRuleModel ruleModel) {
        return this.toJsonOkResponse(this.dataCleanerRuleService.createRule(ruleModel));
    }

    @POST
    @Path(value="/{ruleId}")
    @Consumes(value={"application/json"})
    public Response updateRule(@PathParam(value="ruleId") int ruleId, DataCleanerRuleModel ruleModel) {
        return this.toJsonOkResponse(this.dataCleanerRuleService.updateRule(ruleId, ruleModel));
    }

    @POST
    @Path(value="/state")
    public Response changeState(@FormParam(value="id") int id, @FormParam(value="state") boolean state) {
        this.dataCleanerRuleService.changeRuleState(id, state);
        return Response.ok().build();
    }

    @GET
    @Path(value="/{ruleId}")
    @Consumes(value={"application/json"})
    public Response getRule(@PathParam(value="ruleId") int ruleId) {
        return this.toJsonOkResponse(this.dataCleanerRuleService.getRule(ruleId));
    }

    @GET
    @Path(value="/template/{templateId}")
    @Consumes(value={"application/json"})
    public Response getTemplateRules(@PathParam(value="templateId") int templateId) {
        return this.toJsonOkResponse(this.dataCleanerRuleService.getRules(templateId));
    }

    @GET
    @Path(value="/all")
    @Consumes(value={"application/json"})
    public Response getAllRules() {
        return this.toJsonOkResponse(this.dataCleanerRuleService.getAllRules());
    }

    @DELETE
    @Path(value="/{ruleId}")
    @Consumes(value={"application/json"})
    public Response deleteRule(@PathParam(value="ruleId") int ruleId) {
        this.dataCleanerRuleService.deleteRule(ruleId);
        return Response.ok().build();
    }

    @POST
    @Path(value="/regex")
    public Response changeState(@FormParam(value="regex") String regex) {
        try {
            Pattern pattern = Pattern.compile(regex);
            return Response.ok().build();
        }
        catch (PatternSyntaxException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Gson().toJson(Maps.getMapData("errorMsg", e.getMessage()))).build();
        }
    }
}

