define("actonic-gdpr/profile-visibility/overview", ["jquery", "actonic-gdpr/profile-visibility/intro", "actonic-gdpr/profile-visibility/rest", "actonic-gdpr/core/flags"], function ($, Intro, Rest, flags) {

    function Overview() {
        var state;
        var selectedGroups = [];
        this.init = function () {
            getState(function () {
                getAllRules(function () {
                    initializeTargetGroupPicker();
                    initializeVisibleGroupsPicker();

                    if (state == "enabledForAll") $("#enabled-for-all").click();
                    if (state == "disabledForAll") $("#disabled-for-all").click();
                    if (state == "allowConfigOwnProfile") $("#allow-config-own-profile").click();
                    if (state == "custom") $("#custom").click();
                });
            });

            $("#confirm-delete-rule-dialog-ok-btn").click(function () {
                var ruleId = $("#confirm-delete-rule-dialog").attr("data-rule-id");
                Rest.deleteRule(ruleId,
                    function () {
                        $("#result-table tbody tr[data-rule-id=" + ruleId + "]").remove();
                        flags.showFlag(AJS.I18n.getText("js-profile-visibility.overview.rest.delete-rule.flags.info.title"), AJS.I18n.getText("js-profile-visibility.overview.rest.delete-rule.flags.info.desc"), "info");
                    },
                    function (error) {
                        flags.showFlag(AJS.I18n.getText("js-profile-visibility.overview.rest.delete-rule.flags.error.title"), AJS.I18n.getText("js-profile-visibility.overview.rest.delete-rule.flags.error.desc") + " " + JSON.stringify(error), "error");
                    });
                AJS.dialog2("#confirm-delete-rule-dialog").hide();
            });
            $("#confirm-delete-rule-dialog-cancel-btn").click(function () {
                AJS.dialog2("#confirm-delete-rule-dialog").hide();
            });

            $("#help-btn").click(function () {
                AJS.dialog2("#help-dialog").show();
            });

            $("#show-intro").click(function() {
                AJS.dialog2("#help-dialog").hide();
                Intro.showIntro();
            });
            $('.aui-dialog2-header-close').click(function() {
                AJS.dialog2("#help-dialog").hide();
            });

            $("#add-rule").click(function () {
                addRule();
            });

            $("#enabled-for-all").click(function () {
                setState("enabledForAll");
                disabledCustomElements();
            });
            $("#disabled-for-all").click(function () {
                setState("disabledForAll");
                disabledCustomElements();
            });
            $("#allow-config-own-profile").click(function () {
                setState("allowConfigOwnProfile");
                disabledCustomElements();
            });
            $("#custom").click(function () {
                setState("custom");
                enabledCustomElements();
            });
        }

        function addRule() {
            var targetGroup = $("#target-group").val();
            var visibleGroups = $("#visible-groups").val();

            if (!targetGroup) {
                flags.show({body: AJS.I18n.getText("js-profile-visibility.overview.flags.warning.target-user.desc"), type: "warning"});
                return;
            }

            if (!visibleGroups) {
                flags.show({body: AJS.I18n.getText("js-profile-visibility.overview.flags.warning.visible-groups.desc"), type: "warning"});
                return;
            }

            var request = {
                targetGroup: targetGroup,
                visibleGroups: visibleGroups
            }

            Rest.addRule(request,
                function (data) { // success
                    //log.debug("Rest.getState data = " + JSON.stringify(data));
                    location.reload();
                },
                function (error) {
                    flags.showFlag(AJS.I18n.getText("js-profile-visibility.overview.rest.add-rule.flags.error.title"), AJS.I18n.getText("js-profile-visibility.overview.rest.add-rule.flags.error.title") + " " + JSON.stringify(error), "error");
                });
        }

        function initializeTargetGroupPicker() {
            AJS.$("#target-group").auiSelect2({
                placeholder: AJS.I18n.getText("js-profile-visibility.overview.placeholder.select-group"),
                allowClear: true,
                ajax: {
                    type: "GET",
                    cache: true,
                    dataType: "json",
                    url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/picker/groups",
                    data: function (term) {
                        return {
                            query: term,
                            maxResults: 100
                        };
                    },
                    results: function (data) {
                        var results = [];
                        $.each(data, function (index, item) {
                            if (selectedGroups.indexOf(item.text) == -1) results.push({id: item.text, text: item.text});
                        });
                        return {
                            results: results
                        };
                    }
                }
            });
        }

        function initializeVisibleGroupsPicker() {
            AJS.$("#visible-groups").auiSelect2({
                placeholder: AJS.I18n.getText("js-profile-visibility.overview.placeholder.select-group"),
                allowClear: true,
                multiple: true,
                ajax: {
                    type: "GET",
                    cache: true,
                    dataType: "json",
                    url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/picker/groups",
                    data: function (term) {
                        return {
                            query: term,
                            maxResults: 100
                        };
                    },
                    results: function (data) {
                        //log.debug("initializeVisibleGroupsPicker = " + JSON.stringify(data));
                        var results = [];
                        $.each(data, function (index, item) {
                            results.push({id: item.text, text: item.text});
                        });
                        return {
                            results: results
                        };
                    }
                },
                formatResult: function(item) {
                    return item.text.replace(/(.{60})/g, "$1<br>");
                },
                formatSelection: function(item) {
                    return item.text.replace(/(.{60})/g, "$1<br>");
                }
            });
        }

        function getState(successCallback) {
            Rest.getState(
                function (data) { // success
                    //log.debug("Rest.getState data = " + JSON.stringify(data));
                    if (data && data.state) state = data.state;

                    successCallback();
                },
                function (error) {
                    flags.showFlag(AJS.I18n.getText("js-profile-visibility.overview.rest.get-state.flags.error.title"), AJS.I18n.getText("js-profile-visibility.overview.rest.get-state.flags.error.desc") + " " + JSON.stringify(error), "error");
                });
        }

        function setState(state) {
            Rest.setState(state,
                function (data) { // success
                    //log.debug("Rest.setState data = " + JSON.stringify(data));
                },
                function (error) {
                    flags.showFlag(AJS.I18n.getText("js-profile-visibility.overview.rest.set-state.flags.error.title"), AJS.I18n.getText("js-profile-visibility.overview.rest.set-state.flags.error.desc") + " " + JSON.stringify(error), "error");
                });
        }

        function getAllRules(successCallback) {
            $("#visibility-table tbody tr").remove();
            $("#progress-indicator").show();

            Rest.getAllRules(
                function (data) { // success
                    //log.debug("Rest.getAllRules data = " + JSON.stringify(data));
                    if (data && data.rules && data.rules.length > 0) {
                        data.rules.forEach(function (item) {
                            var newRow = ACTONIC.GDPR.PROFILE.createTableRow({
                                targetGroup: item.targetGroup,
                                selectedGroups: item.visibleGroups
                            });

                            $("#visibility-table tbody").append(newRow);
                        });
                    }

                    if (data && data.selectedGroups) selectedGroups = data.selectedGroups;

                    $("#progress-indicator").hide();

                    setTableButtonHandlers();
                    successCallback();
                },
                function (error) {
                    flags.showFlag(AJS.I18n.getText("js-profile-visibility.overview.rest.get-rules.flags.error.title"), AJS.I18n.getText("js-profile-visibility.overview.rest.get-rules.flags.error.desc") + " " + JSON.stringify(error), "error");
                });
        }

        function setTableButtonHandlers() {
            $(".delete-rule-button").click(function () {
                deleteRule($(this).attr("data-target-group-name"));
            });
        }

        function deleteRule(targetGroupName) {
            Rest.deleteRule(targetGroupName,
                function (data) { // success
                    //log.debug("Rest.deleteRule data = " + JSON.stringify(data));
                    location.reload();
                },
                function (error) {
                    flags.showFlag(AJS.I18n.getText("js-profile-visibility.overview.rest.delete-rule.flags.info.title"), AJS.I18n.getText("js-profile-visibility.overview.rest.delete-rule.flags.info.desc") + " " + JSON.stringify(error), "error");
                });
        }

        function disabledCustomElements() {
            $("#add-rule").prop("disabled", "disabled");
            $("#target-group").prop("disabled", "disabled");
            $("#visible-groups").prop("disabled", "disabled");
            $(".delete-rule-button").prop("disabled", "disabled");
        }

        function enabledCustomElements() {
            $("#add-rule").prop("disabled", false);
            $("#target-group").prop("disabled", false);
            $("#visible-groups").prop("disabled", false);
            $(".delete-rule-button").prop("disabled", false);
        }
    }

    return new Overview();
});