define("actonic-gdpr/core/picker/group-picker", ["jquery", "actonic-gdpr/core/flags"], function ($, flags) {
    function ExecuteGroupPicker() {
        this.initializeGdprGroupPicker = function(groupPickerSelector) {
            var defaultGdprValue = groupPickerSelector.val();
            groupPickerSelector.auiSelect2({
                placeholder: AJS.I18n.getText("js-settings.group-picker.placeholder"),
                initSelection: function (element, callback) {
                    if (defaultGdprValue) {
                        callback({id: defaultGdprValue, text: defaultGdprValue});
                    }
                },
                dropdownAutoWidth: true,
                allowClear: true,
                ajax: {
                    url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/picker/groups",
                    dataType: "json",
                    data: function (term) {
                        return {
                            q: term
                        };
                    },
                    results: function (data) {
                        return {
                            results: $.map(data, function (el) {
                                return {
                                    id: el.id,
                                    text: el.id
                                }
                            })
                        };
                    }
                }
            });
        }
    }
    return new ExecuteGroupPicker();
});