define("actonic-gdpr/user-anonymizer/rest", ["jquery"], function ($) {

    function Rest() {
        this.checkUserForUpdateRights = function (userName, successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/user-anonymizer/check-user/" + userName,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.runGlobalChanges = function (config, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/user-anonymizer/global-changes",
                headers: {"X-Atlassian-Token": "no-check"},
                data: {config: JSON.stringify(config)},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.checkConfigForContentChanges = function (config, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/user-anonymizer/content-changes/check",
                headers: {"X-Atlassian-Token": "no-check"},
                data: {config: JSON.stringify(config)},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.runContentChanges = function (config, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/user-anonymizer/content-changes",
                headers: {"X-Atlassian-Token": "no-check"},
                data: {config: JSON.stringify(config)},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.getAffectedContent = function (config, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/user-anonymizer/content-changes/affected",
                headers: {"X-Atlassian-Token": "no-check"},
                data: {config: JSON.stringify(config)},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.getTaskStatus = function ( successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/user-anonymizer/content-changes/job",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.checkCql = function (cql, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-level-agreement/cql" ,
                data: {cql: cql},
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.getAdditionalAddonsConfig = function (successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/user-anonymizer/check-additional-addons",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        }
        this.cancelTask = function (successCallback, errorCallback) {
            $.ajax({
                type: "PUT",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/user-anonymizer/job",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        }
    }

    return new Rest();
});
