/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.datacleaner.service.changer;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.DraftsTransitionHelper;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.Lists;
import de.actonic.gdpr.datacleaner.service.changer.DCConfluenceFieldChanger;
import de.actonic.gdpr.shared.datacleaner.model.fieldchanger.DCFieldChangerValue;
import de.actonic.gdpr.shared.datacleaner.model.fieldchanger.DCIFieldChangerValue;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class DCBodyContentChanger
extends DCConfluenceFieldChanger {
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    @ComponentImport
    private final DraftsTransitionHelper draftsTransitionHelper;
    private final SaveContext SAVE_CONTEXT = ((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)DefaultSaveContext.builder().suppressAutowatch(true).suppressNotifications(true)).suppressEvents(true)).updateLastModifier(false).build();

    public DCBodyContentChanger(TransactionTemplate transactionTemplate, @ComponentImport PageManager pageManager, DraftsTransitionHelper draftsTransitionHelper) {
        super(pageManager);
        this.transactionTemplate = transactionTemplate;
        this.draftsTransitionHelper = draftsTransitionHelper;
    }

    public String getType() {
        return "text";
    }

    public List<DCIFieldChangerValue> extractValues(Long contentObjectId) {
        return (List)this.transactionTemplate.execute(() -> {
            ContentEntityObject contentEntityObject = this.getPageById(contentObjectId);
            return contentEntityObject == null ? Lists.newArrayList() : Lists.newArrayList((Object[])new DCIFieldChangerValue[]{new DCFieldChangerValue(contentEntityObject.getBodyAsString())});
        });
    }

    public void applyNewValues(Long contentObjectId, Map<DCIFieldChangerValue, String> oldNewValueMap) {
        this.transactionTemplate.execute(() -> {
            ContentEntityObject tCeo = this.getPageById(contentObjectId);
            for (Map.Entry entry : oldNewValueMap.entrySet()) {
                String bodyContent = tCeo.getBodyAsString();
                if (!bodyContent.contains(((DCIFieldChangerValue)entry.getKey()).getValue())) continue;
                tCeo.setBodyAsString(bodyContent.replace(((DCIFieldChangerValue)entry.getKey()).getValue(), (CharSequence)entry.getValue()));
            }
            this.saveContentEntity(tCeo, this.SAVE_CONTEXT);
            ContentEntityObject draft = this.draftsTransitionHelper.getDraftForPage((AbstractPage)tCeo);
            if (draft != null) {
                for (Map.Entry entry : oldNewValueMap.entrySet()) {
                    String bodyContent = draft.getBodyAsString();
                    if (!bodyContent.contains(((DCIFieldChangerValue)entry.getKey()).getValue())) continue;
                    draft.setBodyAsString(bodyContent.replace(((DCIFieldChangerValue)entry.getKey()).getValue(), (CharSequence)entry.getValue()));
                }
                this.saveContentEntity(draft, this.SAVE_CONTEXT);
            }
            return true;
        });
    }
}

