/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.collect.Lists;
import de.actonic.confluence.gdpr.ao.AccessStatisticsEntity;
import de.actonic.confluence.gdpr.ao.AnnouncingEntity;
import de.actonic.confluence.gdpr.ao.AnnouncingHistoryEntity;
import de.actonic.confluence.gdpr.ao.DataRuleEntity;
import de.actonic.confluence.gdpr.ao.DataRuleHistoryEntity;
import de.actonic.confluence.gdpr.ao.SensitiveDataMonitoringHistoryEntity;
import de.actonic.confluence.gdpr.ao.SensitiveDataMonitoringMetaEntity;
import de.actonic.confluence.gdpr.component.manager.AbstractEntityDao;
import de.actonic.confluence.gdpr.component.service.AnnouncingService;
import de.actonic.confluence.gdpr.component.service.DataRuleService;
import de.actonic.confluence.gdpr.model.AnnouncingModel;
import de.actonic.confluence.gdpr.model.TroubleshootingModel;
import de.actonic.confluence.gdpr.model.troobleshooting.AccessStatistics;
import de.actonic.confluence.gdpr.model.troobleshooting.Announcements;
import de.actonic.confluence.gdpr.model.troobleshooting.ConfigurationModel;
import de.actonic.confluence.gdpr.model.troobleshooting.DataRules;
import de.actonic.confluence.gdpr.model.troobleshooting.ExportModel;
import de.actonic.confluence.gdpr.model.troobleshooting.Global;
import de.actonic.confluence.gdpr.model.troobleshooting.SensitiveData;
import de.actonic.confluence.gdpr.model.troobleshooting.Troubleshooting;
import de.actonic.confluence.gdpr.model.troobleshooting.announcing.CustomAnnouncingEntity;
import de.actonic.confluence.gdpr.model.troobleshooting.datarules.Configuration;
import de.actonic.gdpr.general.manager.GDPRSettingsManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import net.java.ao.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TroubleshootingService
extends AbstractEntityDao {
    @ComponentImport
    private final UserAccessor userManager;
    private final GDPRSettingsManager GDPRSettingsManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final DataRuleService dataRuleService;
    private final AnnouncingService announcingService;

    @Autowired
    public TroubleshootingService(ActiveObjects ao, GDPRSettingsManager GDPRSettingsManager2, UserAccessor userAccessor, DataRuleService dataRuleService, AnnouncingService announcingService, UserAccessor userManager) {
        super(ao);
        this.GDPRSettingsManager = GDPRSettingsManager2;
        this.userAccessor = userAccessor;
        this.dataRuleService = dataRuleService;
        this.announcingService = announcingService;
        this.userManager = userManager;
    }

    public TroubleshootingModel getTroubleshootingData() {
        return TroubleshootingModel.builder().global(this.getGlobalData()).accessStatistics(this.getAccessStatistics()).announcements(this.getAnnouncementData()).dataRules(this.getDataRulesData()).sensitiveData(this.getSensitiveData()).build();
    }

    public ExportModel getExportData() {
        return ExportModel.builder().configuration(this.getConfiguratonData()).announcements(this.getAccouncements()).build();
    }

    public void uploadImportData(ExportModel exportModel) {
        this.setConfiguration(exportModel.getConfiguration());
        this.createAnnouncements(exportModel.getAnnouncements());
    }

    private void setConfiguration(ConfigurationModel configuration) {
        this.GDPRSettingsManager.setRowsPerPage(configuration.getRowsPerPage());
        this.GDPRSettingsManager.setTrackPageAccessStatistics(configuration.isTrackPageAccessStatistics());
        this.GDPRSettingsManager.setPurgeAccessStatisticsAfter(configuration.getPurgeAccessStatisticsAfter());
        ConfluenceUser user = this.userAccessor.getUserByName(configuration.getRunTasksFromUser());
        if (user != null) {
            this.GDPRSettingsManager.setRunTasksFromUser(user.getKey().getStringValue());
        }
        this.GDPRSettingsManager.setAllowedGroup(configuration.getRunGdprGroup());
    }

    private ConfigurationModel getConfiguratonData() {
        return ConfigurationModel.builder().rowsPerPage(this.GDPRSettingsManager.getRowsPerPage()).purgeAccessStatisticsAfter(this.GDPRSettingsManager.getPurgeAccessStatisticsAfter()).runTasksFromUser(this.GDPRSettingsManager.getRunTasksFromUser()).runGdprGroup(this.GDPRSettingsManager.getAllowedGroup()).trackPageAccessStatistics(this.GDPRSettingsManager.getTrackPageAccessStatistics()).build();
    }

    private void createAnnouncements(List<CustomAnnouncingEntity> customAnnouncingEntities) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        customAnnouncingEntities.forEach(entity -> this.announcingService.createAnnouncing(confluenceUser, entity.getIsActive(), entity.getStartDate(), entity.getEndDate(), entity.getName(), entity.getType(), entity.getStyle(), entity.getGroup(), entity.getQuestionnaire(), entity.getAnonymous(), entity.getWindowSize(), entity.getAccept(), entity.getDecline(), entity.getPinned(), entity.getTitle(), entity.getContent(), entity.getPageId(), entity.getBody()));
    }

    private List<CustomAnnouncingEntity> getAccouncements() {
        ArrayList entities = Lists.newArrayList((Object[])this.ao.find(AnnouncingEntity.class));
        ArrayList announcements = Lists.newArrayList();
        entities.forEach(entity -> {
            if (entity.getCreator() == null) {
                entity.setCreator("unknown");
            } else {
                ConfluenceUser creator = this.userManager.getUserByKey(new UserKey(entity.getCreator()));
                if (creator == null) {
                    entity.setCreator("unknown");
                } else {
                    entity.setCreator(creator.getName());
                }
            }
            if (entity.getLastModifier() == null) {
                entity.setLastModifier("unknown");
            } else {
                ConfluenceUser lastModifier = this.userManager.getUserByKey(new UserKey(entity.getLastModifier()));
                if (lastModifier == null) {
                    entity.setLastModifier("unknown");
                } else {
                    entity.setLastModifier(lastModifier.getName());
                }
            }
            announcements.add(new CustomAnnouncingEntity((AnnouncingEntity)entity));
        });
        return announcements;
    }

    public Global getGlobalData() {
        Global data = Global.builder().rowsPerPage(this.GDPRSettingsManager.getRowsPerPage()).purgeAccessStatisticsAfter(this.GDPRSettingsManager.getPurgeAccessStatisticsAfter()).isServiceUserDefined(StringUtils.isNotBlank((CharSequence)this.GDPRSettingsManager.getRunTasksFromUser()) ? Boolean.TRUE : Boolean.FALSE).isRestrictedGroupDefined(StringUtils.isNotBlank((CharSequence)this.GDPRSettingsManager.getAllowedGroup()) ? Boolean.TRUE : Boolean.FALSE).build();
        return data;
    }

    private Integer getUniqueUsersSize(Date timeStamp) {
        HashSet results = new HashSet();
        ArrayList data = Lists.newArrayList((Object[])this.ao.find(AccessStatisticsEntity.class, Query.select().where("TIME_STAMP > ?", new Object[]{timeStamp})));
        data.forEach(d -> results.add(d.getUserName()));
        return results.size();
    }

    public AccessStatistics getAccessStatistics() {
        Integer totalEntitiesCount = this.ao.count(AccessStatisticsEntity.class, Query.select());
        Date lastMinute = new Date(System.currentTimeMillis() - 60000L);
        Integer lastMinuteEntitiesCount = this.ao.count(AccessStatisticsEntity.class, Query.select().where("TIME_STAMP > ?", new Object[]{lastMinute}));
        Date lastHour = new Date(System.currentTimeMillis() - 3600000L);
        Integer lastHourEntitiesCount = this.ao.count(AccessStatisticsEntity.class, Query.select().where("TIME_STAMP > ?", new Object[]{lastHour}));
        Date lastDay = new Date(System.currentTimeMillis() - 86400000L);
        Integer lastDayEntitiesCount = this.ao.count(AccessStatisticsEntity.class, Query.select().where("TIME_STAMP > ?", new Object[]{lastDay}));
        Integer lastMinuteUniqueUserCount = this.getUniqueUsersSize(lastMinute);
        Integer lastHourUniqueUserCount = this.getUniqueUsersSize(lastHour);
        Integer lastDayUniqueUserCount = this.getUniqueUsersSize(lastDay);
        Date expireDate = new Date(System.currentTimeMillis() - (long)(86400000 * this.GDPRSettingsManager.getPurgeAccessStatisticsAfter()));
        Integer entitiesAfterExpireDate = this.ao.count(AccessStatisticsEntity.class, Query.select().where("TIME_STAMP > ?", new Object[]{expireDate}));
        AccessStatistics data = AccessStatistics.builder().totalEntitiesCount(totalEntitiesCount).lastMinuteEntitiesCount(lastMinuteEntitiesCount).lastHourEntitiesCount(lastHourEntitiesCount).lastDayEntitiesCount(lastDayEntitiesCount).lastMinuteUniqueUserCount(lastMinuteUniqueUserCount).lastHourUniqueUserCount(lastHourUniqueUserCount).lastDayUniqueUserCount(lastDayUniqueUserCount).configuration(de.actonic.confluence.gdpr.model.troobleshooting.access.Configuration.builder().enabled(this.GDPRSettingsManager.getTrackPageAccessStatistics()).build()).troubleshooting(Troubleshooting.builder().enitiesAfterExpireDate(entitiesAfterExpireDate).build()).build();
        return data;
    }

    public Announcements getAnnouncementData() {
        Integer totalAnnouncementsCount = this.ao.count(AnnouncingEntity.class, Query.select());
        Integer enabledAnnouncementsCount = this.ao.count(AnnouncingEntity.class, Query.select().where("IS_ACTIVE = ?", new Object[]{Boolean.TRUE}));
        Integer totalHistoryEntitiesCount = this.ao.count(AnnouncingHistoryEntity.class, Query.select());
        Date lastMinute = new Date(System.currentTimeMillis() - 60000L);
        Integer lastMinuteHistoryEntitiesCount = this.ao.count(AnnouncingHistoryEntity.class, Query.select().where("TIME_STAMP > ?", new Object[]{lastMinute}));
        Date lastHour = new Date(System.currentTimeMillis() - 3600000L);
        Integer lastHourHistoryEntitiesCount = this.ao.count(AnnouncingHistoryEntity.class, Query.select().where("TIME_STAMP > ?", new Object[]{lastHour}));
        Date lastDay = new Date(System.currentTimeMillis() - 86400000L);
        Integer lastDayHistoryEntitiesCount = this.ao.count(AnnouncingHistoryEntity.class, Query.select().where("TIME_STAMP > ?", new Object[]{lastDay}));
        ArrayList entities = Lists.newArrayList((Object[])this.ao.find(AnnouncingEntity.class));
        ArrayList announcements = Lists.newArrayList();
        entities.forEach(e -> announcements.add(new AnnouncingModel((AnnouncingEntity)e, null)));
        Announcements data = Announcements.builder().totalAnnouncementsCount(totalAnnouncementsCount).enabledAnnouncementsCount(enabledAnnouncementsCount).totalHistoryEntitiesCount(totalHistoryEntitiesCount).lastMinuteHistoryEntitiesCount(lastMinuteHistoryEntitiesCount).lastHourHistoryEntitiesCount(lastHourHistoryEntitiesCount).lastDayHistoryEntitiesCount(lastDayHistoryEntitiesCount).configuration(de.actonic.confluence.gdpr.model.troobleshooting.announcing.Configuration.builder().announcements(announcements).build()).build();
        return data;
    }

    public DataRules getDataRulesData() {
        Integer totalDataRulesCount = this.ao.count(DataRuleEntity.class, Query.select());
        Integer enabledDataRulesCount = this.ao.count(DataRuleEntity.class, Query.select().where("IS_ACTIVE = ?", new Object[]{Boolean.TRUE}));
        Integer totalHistoryEntitiesCount = this.ao.count(DataRuleHistoryEntity.class, Query.select());
        Date lastHour = new Date(System.currentTimeMillis() - 3600000L);
        Integer lastHourHistoryEntitiesCount = this.ao.count(DataRuleHistoryEntity.class, Query.select().where("TIME_STAMP > ?", new Object[]{lastHour}));
        Date lastDay = new Date(System.currentTimeMillis() - 86400000L);
        Integer lastDayHistoryEntitiesCount = this.ao.count(DataRuleHistoryEntity.class, Query.select().where("TIME_STAMP > ?", new Object[]{lastDay}));
        ArrayList entities = Lists.newArrayList((Object[])this.ao.find(DataRuleEntity.class));
        ArrayList rules = Lists.newArrayList();
        entities.forEach(e -> rules.add(this.dataRuleService.entityToModel((DataRuleEntity)e)));
        DataRules data = DataRules.builder().totalDataRulesCount(totalDataRulesCount).enabledDataRulesCount(enabledDataRulesCount).totalHistoryEntitiesCount(totalHistoryEntitiesCount).lastHourHistoryEntitiesCount(lastHourHistoryEntitiesCount).lastDayHistoryEntitiesCount(lastDayHistoryEntitiesCount).configuration(Configuration.builder().rules(rules).build()).build();
        return data;
    }

    public SensitiveData getSensitiveData() {
        Integer historyEntitiesCount = this.ao.count(SensitiveDataMonitoringHistoryEntity.class, Query.select());
        Integer metaEntitiesCount = this.ao.count(SensitiveDataMonitoringMetaEntity.class, Query.select());
        SensitiveData data = SensitiveData.builder().historyEntitiesCount(historyEntitiesCount).metaEntitiesCount(metaEntitiesCount).build();
        return data;
    }
}

