/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.manager;

import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.mail.Email;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class EmailManager {
    @ComponentImport
    private final MultiQueueTaskManager taskManager;

    @Autowired
    public EmailManager(@Qualifier(value="multiQueueTaskManager") MultiQueueTaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public String sendMessage(String subject, String body, String recipient) {
        try {
            Email email = new Email(recipient);
            email.setSubject(subject);
            email.setBody(body);
            email.setMimeType("text/html");
            SingleMailQueueItem emailItem = new SingleMailQueueItem(email);
            this.taskManager.addTask("mail", () -> ((SingleMailQueueItem)emailItem).send());
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
        return "";
    }
}

