/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.common.datacleaner.rest;

import com.google.gson.Gson;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerPostFunctionModel;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerPostFunctionService;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/data-cleaner-template/post-function")
@Produces(value={"application/json"})
public class DataCleanerPostFunctionRest {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerPostFunctionRest.class);
    private final DataCleanerPostFunctionService dataCleanerPostFunctionService;

    public DataCleanerPostFunctionRest(DataCleanerPostFunctionService dataCleanerPostFunctionService) {
        this.dataCleanerPostFunctionService = dataCleanerPostFunctionService;
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    public Response createPostFunction(DataCleanerPostFunctionModel dataCleanerPostFunctionModel) {
        this.dataCleanerPostFunctionService.createPostFunction(dataCleanerPostFunctionModel);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/")
    @Consumes(value={"application/json"})
    public Response updatePostFunction(DataCleanerPostFunctionModel dataCleanerPostFunctionModel) {
        this.dataCleanerPostFunctionService.updatePostFunction(dataCleanerPostFunctionModel);
        return Response.ok().build();
    }

    @GET
    @Path(value="/{templateId}")
    @Consumes(value={"application/json"})
    public Response getAllPostFunctions(@PathParam(value="templateId") int templateId) {
        return Response.ok((Object)new Gson().toJson(this.dataCleanerPostFunctionService.getAllPostFunctions(templateId))).build();
    }

    @DELETE
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    public Response deletePostFunction(@PathParam(value="id") int id) {
        this.dataCleanerPostFunctionService.deletePostFunction(id);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/{id}/{status}")
    @Consumes(value={"application/json"})
    public Response changeStatus(@PathParam(value="id") int id, @PathParam(value="status") boolean status) {
        this.dataCleanerPostFunctionService.changeStatus(id, status);
        return Response.ok().build();
    }
}

