define("gdpr/data-cleaner/tasks/rest", ["jquery"], function ($) {
    function Rest() {
        this.createTask = function (request, successCallback, errorCallback) {
            $.ajax({
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/task",
                type: "PUT",
                async: false,
                cache: false,
                data: JSON.stringify(request),
                headers: {
                    "Content-Type": "application/json"
                },
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        };

        this.getTaskList = function (successCallback, errorCallback) {
            $.ajax({
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/tasks",
                type: "GET",
                async: false,
                cache: false,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        };

        this.status = function (successCallback, errorCallback) {
            $.ajax({
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/status",
                type: "GET",
                async: false,
                cache: false,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        };

        this.cancelTask = function (taskId, successCallback, errorCallback) {
            $.ajax({
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/task/" + taskId,
                type: "DELETE",
                async: false,
                cache: false,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        };
    }

    return new Rest();
});