define("gdpr/data-cleaner/rules/rest", ["jquery", "gdpr/core/log"], function ($, log) {
    function Rest() {
        this.init = function () {
        };

        this.create = function (request, successCallback, errorCallback) {
            $.ajax({
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/rules",
                type: "PUT",
                data: JSON.stringify(request),
                headers: {"Content-Type": "application/json"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        };

        this.update = function (id, request, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/rules/" + id,
                data: JSON.stringify(request),
                contentType: "application/json",
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        };

        this.delete = function (id, successCallback, errorCallback) {
            $.ajax({
                type: "DELETE",
                url: AJS.contextPath() + '/rest/actonic-gdpr/1.0/data-cleaner-template/rules/' + id,
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        };

        this.changeState = function (id, state, successCallback, errorCallback) {
            log.debug("changeState id = " + id + " state = " + state);
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/rules/state",
                headers: {"X-Atlassian-Token": "no-check"},
                data: {
                    id: id,
                    state: state
                },
                success: function (data) {
                    log.debug("changeState success");
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        };

        this.getRule = function (id, successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/rules/" + id,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        };

        this.getRulesForTemplate = function (id, successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/rules/template/" + id,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        };

        this.getAllBuildIn = function (successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/build-in",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        };

        this.setSelectedBuildIn = function (templateId, selections, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/build-in",
                data: JSON.stringify({templateId: templateId, selections: selections}),
                dataType: "json",
                contentType: "application/json",
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        };

        this.getAllRules = function (successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/rules/all",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        };

        this.changePostFunctionStatus = function (postFunctionId, postFunctionStatus, successCallback, errorCallback) {
            $.ajax({
                type: "PUT",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/post-function/" + postFunctionId + "/" + postFunctionStatus,
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        };

        this.deletPostFunction = function (postFunctionId, successCallback, errorCallback) {
            $.ajax({
                type: "DELETE",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/post-function/" + postFunctionId,
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        };

        this.createPostFunction = function (request, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/post-function",
                data: JSON.stringify(request),
                dataType: "json",
                contentType: "application/json",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        };

        this.updatePostFunction = function (request, successCallback, errorCallback) {
            $.ajax({
                type: "PUT",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/post-function",
                data: JSON.stringify(request),
                dataType: "json",
                contentType: "application/json",
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (xhr, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(xhr);
                }
            })
        };

        this.getAllPostFunctions = function (templateId, successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/post-function/" + templateId,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (xhr, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(xhr);
                }
            })
        };

        this.validateRegex = function (regexString, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/rules/regex",
                data: {regex: regexString},
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (xhr, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(xhr.responseText);
                }
            })
        };
    }

    return new Rest();
});