require(["jquery", "gdpr/data-cleaner/rest", "gdpr/data-cleaner/task", "gdpr/core/log", "actonic-gdpr/core/flags",
        "actonic-gdpr/core/intro", "actonic-gdpr/domReady", "actonic-gdpr/core/tippy", "gdpr/data-cleaner/rules/rest",
        "gdpr/data-cleaner/pii-template", "gdpr/data-cleaner/user-anonymizer-template", "gdpr/core/utils", "actonic-gdpr/core/picker",
        "gdpr/core/element-highlighter", "gdpr/data-cleaner/cql-picker"],
    function ($, TemplatesRest, DataCleanerTasks, log, flags, CoreIntro, domReady, Tippy, RulesRest, PIITemplateDialog,
              UserAnonymizerTemplate, CoreUtils, CoreAuiSelect, coreHighlighter, CqlPicker) {

        domReady(function () {
            new DataCleanerPage().init();
        });

        function DataCleanerPage() {
            var TASK_STATUS = {
                UNDEFINED: -1,
                NOT_STARTED: 0,
                IN_PROGRESS: 1,
                ABORTED: 2,
                FINISHED: 3,
                FAILED: 5
            };

            var currentTemplateId = -1; // TODO refactor IT, there are no any reasons to use global value. Avoid it
            var isLicenseValid = false;
            var oldTemplateData = "null";
            var recentData;

            var checkboxAll;
            var checkboxContentChanges;
            var fields = [];
            var fieldIds = ["title", "body", "comment", "author", "comment-author", "attach-author"];
            var fieldNames = [];

            var quickAnonymizationType = "user";
            var quickAnonymizationOperationType = 0;
            var quickAnonymizationStep = 0;
            var quickAnonymizationDisableUsers = false;

            var selectedProjectType = "current";

            this.init = function () {
                start();
            };

            function switchMoreLess(moreBtn) {
                var parent = $(this).parent();
                if (parent.find(".more").attr("data-state") == 0) {
                    parent.find(".more").show();
                    $(this).html(" <<<");
                    parent.find(".more").attr("data-state", 1);
                } else {
                    parent.find(".more").hide();
                    $(this).html("View which content is affected >>>");
                    parent.find(".more").attr("data-state", 0);
                }
            }

            function start() {
                updateTemplateList();

                checkboxAll = $("#builtin-user-anonymizer-checkbox-all");
                checkboxContentChanges = $("#builtin-user-anonymizer-checkbox-content-changes");

                window.onbeforeunload = false;

                checkboxAll.change(function() {
                    checkboxContentChanges.prop("checked", this.checked);
                    $("#builtin-user-anonymizer-custom-anonymizers .checkbox-custom-anonymizer").prop("checked", this.checked);
                });

                $("#confirm-delete-dialog-ok-btn").click(function (event) {
                    confirmDeleteTemplateOkHandler(event);
                });

                $("#confirm-delete-dialog-cancel-btn").click(function (event) {
                    confirmDeleteTemplateCancelHandler(event);
                });

                $("#create-custom-rule-btn").on("click", function (event) {
                    createCustomRuleClickHandler(event);
                });

                $("#help-btn").click(function () {
                    AJS.dialog2("#help-dialog").show();
                });

                $("#show-intro-btn").click(function () {
                    AJS.dialog2("#help-dialog").hide();
                    CoreIntro.start();
                });

                $('#builtin-user-anonymizer-results').click("click", function () {
                    window.location.href = AJS.contextPath() + "/admin/actonic-gdpr/data-cleaner-results.action?templateId=-1";
                });

                $('[id^="task-container-"] table').live("click", function () {
                    var dcTemplateId = $(this).attr("dc-template-id");
                    var dcTaskId = $(this).attr("dc-task-id");
                    window.location.href = AJS.contextPath() + "/admin/actonic-gdpr/data-cleaner-results.action?templateId=" + dcTemplateId + "&taskId=" + dcTaskId;
                });

                $("#template-live-search").on("keyup", function () {
                    $("#custom-spin-field").show();
                    $("#custom-search-field").hide();

                    var inputValue = $(this).val().trim().toLowerCase();
                    var filteredData = [];
                    if (inputValue.length > 2) {
                        $("#custom-clear-field").show();
                        filteredData = recentData.filter(function (item) {
                            if (item.name.toLowerCase().search(inputValue) > -1) return item;
                        });
                        dataCleanerResults(filteredData);
                    } else {
                        dataCleanerResults(recentData);
                    }
                    if (inputValue.length < 1) {
                        $("#custom-clear-field").hide();
                    }

                    $("#custom-spin-field").hide();
                    $("#custom-search-field").show();
                });

                $("#custom-clear-field").on("click", function () {
                    $("#template-live-search").val("");
                    dataCleanerResults(recentData);
                    $(this).hide();
                });

                $("#anonymization-requests-btn").click(function () {
                    AJS.dialog2("#erasure-requests-dialog").show();
                });

                $("#builtin-user-anonymizer-scope").tooltip();

                $("#builtin-user-anonymizer-scope").click(function (e) {
                    e.preventDefault();
                    var scope = $("#builtin-user-anonymizer-scope").val();
                    var cqlType = $("#cql-type").val();
                    var cqlParams = cqlType === "cql" ? scope : (scope && scope !== "" ? JSON.parse(scope) : {});
                    var params = {cqlType: cqlType, cql: cqlParams};
                    CqlPicker.init("#builtin-user-anonymizer-scope", params);
                })

                CoreAuiSelect.initializeUserPicker("builtin-user-anonymizer-source-user", true);

                //var userNames = CoreUtils.getCurrentUrlParameterByName("userNames");
                //if (userNames) $("#builtin-user-anonymizer-source-user").val(userNames);
                AJS.$("#builtin-user-anonymizer-source-user-tooltip").tooltip();
                AJS.$("#builtin-user-anonymizer-target-user-tooltip").tooltip();


                $("#content").append(ACTONIC.GDPR.DATACLEANER.MODALS.confirmationAnonymization());

                setupIntro();
                PIITemplateDialog.init();
                //UserAnonymizerTemplate.init();

                checkForProperPluginConfiguration();
                initQuickAnonymizationForm();
                loadTemplateData();

                AJS.$(document).on("click", "#export-all", function () {
                    var spinnerEl = this;
                    if (!spinnerEl.isBusy()) {
                        spinnerEl.busy();

                        $.ajax({
                            type: "POST",
                            url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-result/export/all",
                            headers: {"X-Atlassian-Token": "no-check"},
                            success: function (response, status, xhr) {
                                var filename = xhr.getResponseHeader('content-disposition').split('filename=')[1].split(';')[0];

                                const blob = new Blob([response], {type: 'text/csv'});
                                if (window.navigator.msSaveOrOpenBlob) {
                                    window.navigator.msSaveBlob(blob, filename);
                                } else {
                                    const elem = window.document.createElement('a');
                                    elem.href = window.URL.createObjectURL(blob);
                                    elem.download = filename;
                                    document.body.appendChild(elem);
                                    elem.click();
                                    document.body.removeChild(elem);
                                }
                                spinnerEl.idle();
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                flags.simpleWarning("Something went wrong. Cannot export data.");
                                spinnerEl.idle();
                            }
                        });
                    }
                })
                // loadCustomAnonymizers();
            }

            function initQuickAnonymizationForm() {

                CoreAuiSelect.initializeUserPicker("builtin-user-anonymizer-target-user", false);

                // JQLAutocomplete.init("builtin-user-anonymizer-scope", "jql-error-message");
                $(".custom-predefined-jql").on("click", function () {
                    var jqlType = $(this).attr("data-jql-type");
                    var currentScope = "";

                    if (selectedProjectType === "current") {
                        currentScope = $("#builtin-user-anonymizer-scope").val();

                        if (jqlType === "all") {
                            currentScope = "type in (blogpost, page)";
                        } else if (jqlType === "lastDays") {
                            currentScope = "created >= now(-30d)";
                        }

                        $("#builtin-user-anonymizer-scope").val(currentScope);
                    } else if (selectedProjectType === "archived") {
                        currentScope = $("#builtin-archived-projects-scope").val()
                    }
                });

                //*********************************************************************

                $(".builtin-quick-anonymization-anonymize-users-btn").click(function(){
                    OpenQuickAnonymizationDialog("user");
                });
                $(".builtin-quick-anonymization-anonymize-tickets-btn").click(function(){
                    OpenQuickAnonymizationDialog("ticket");
                });
                $(".builtin-quick-anonymization-anonymize-history-btn").click(function(){
                    window.location = AJS.contextPath() + "/admin/actonic-gdpr/data-cleaner-results.action?templateId=-1";
                });
                $("#quick-anonymizer-dialog .aui-dialog2-header-close").click(function(){
                    AJS.dialog2("#quick-anonymizer-dialog").hide();
                });

                $("#help-dialog .aui-dialog2-header-close").click(function(){
                    AJS.dialog2("#help-dialog").hide();
                });
                $("#erasure-requests-dialog .aui-dialog2-header-close").click(function(){
                    AJS.dialog2("#erasure-requests-dialog").hide();
                });

                $("input[name='project-status-change']").on("change", function (event) {
                    //console.log(this);
                    //console.log(this.value)

                    selectedProjectType = this.value;
                    if (this.value === "current") {
                        $("#status-archived").hide();
                        $("#status-current").show();
                    } else if (this.value === "archived") {
                        $("#status-current").hide();
                        $("#status-archived").show();
                    }

                })

                //*********************************************************************

                /*
                $("#builtin-user-anonymizer-search").click(function (event) {
                    updateUserAnonymizerTemplate(0);
                });
                $("#builtin-user-anonymizer-anonymize").click(function (event) {
                    if (quickAnonymizationType == "ticket") {
                        AJS.dialog2("#anonymize-tickets-warning-dialog").show();
                        $("#anonymize-tickets-warning-dialog-ok-btn").attr("disabled", "disabled");
                        $("#anonymize-tickets-warning-dialog-ok-btn").click(function(){
                            updateUserAnonymizerTemplate(1);
                        });
                        $("#anonymize-tickets-warning-dialog-cancel-btn").click(function(){
                            AJS.dialog2("#anonymize-tickets-warning-dialog").hide();
                        });
                        $("#anonymize-tickets-warning-dialog input[type=checkbox]").removeAttr("checked");
                        $("#anonymize-tickets-warning-dialog input[type=checkbox]").change(function() {
                            if ($("#anonymize-tickets-warning-dialog-checkbox-1").attr("checked")
                                    && $("#anonymize-tickets-warning-dialog-checkbox-2").attr("checked")) {
                                $("#anonymize-tickets-warning-dialog-ok-btn").removeAttr("disabled");
                            } else {
                                $("#anonymize-tickets-warning-dialog-ok-btn").attr("disabled", "disabled");
                            }
                        });
                    } else {
                        updateUserAnonymizerTemplate(1);
                    }
                });
                $("#builtin-user-anonymizer-stop").click(function (event) {
                    stopUserAnonymizerTemplate();
                });
                $("#builtin-user-anonymizer-results").click(function (event) {
                    window.location = AJS.contextPath() + "/secure/admin/actonic-gdpr-data-cleaner-results.jspa?templateId=" + templateId;
                });
                */
            };

            function ResetQuickAnonymizationDialog(type) {
                $("input[name=checkbox-operation-type]").eq(0).prop("checked", true);
                $("#checkbox-search-for-data").trigger("change");

                $("#builtin-user-anonymizer-source-user").val("");
                $("#builtin-user-anonymizer-target-user").val("");

                $("#quick-anonymizer-dialog .select2-choices .select2-search-choice").remove();
                $("#quick-anonymizer-dialog .select2-chosen").html("");

                $("#builtin-user-anonymizer-scope").val("");
                $("#builtin-user-anonymizer-scope").text("No parameters defined.");
                $("#builtin-user-anonymizer-scope").attr("original-title", "No parameters defined.");
                $("#cql-scope").val("cql");

                $("#builtin-archived-projects-scope").val("");
                $("#project-status-change-current").prop("checked", true).trigger("change");
                $(".builtin-user-anonymizer-checkbox-content-changes").prop("checked", type == "ticket");

                $(".checkbox-custom-anonymizer").prop("checked", false);

                $("#quick-anonymizer-dialog .review-user1-value").html("-");
                $("#quick-anonymizer-dialog .review-user2-value").html("-");
                $("#quick-anonymizer-dialog .review-scope-value").html("-");
            }

            function OpenQuickAnonymizationDialog(type) {
                setQuickAnonymizationType(type);

                $("#quick-anonymizer-dialog #checkbox-anonymize-data").off("change");
                $("#quick-anonymizer-dialog #checkbox-anonymize-data").on("change", function() {
                    if ($(this).prop("checked"))
                        quickAnonymizationOperationType = 1;
                });

                $("#quick-anonymizer-dialog #checkbox-search-for-data").off("change");
                $("#quick-anonymizer-dialog #checkbox-search-for-data").on("change", function() {
                    if ($(this).prop("checked"))
                        quickAnonymizationOperationType = 0;
                });

                $("#quick-anonymizer-dialog .btn-continue").off("click");
                $("#quick-anonymizer-dialog .btn-continue").on("click", function() {
                    QuickAnonymizationDialogNext(1);
                });
                $("#quick-anonymizer-dialog .btn-go-back").off("click");
                $("#quick-anonymizer-dialog .btn-go-back").on("click", function() {
                    QuickAnonymizationDialogNext(-1);
                });

                $(".builtin-user-anonymizer-checkbox-content-changes").off("change");
                $(".builtin-user-anonymizer-checkbox-content-changes").on("change", function() {
                    $(".builtin-user-anonymizer-checkbox-content-changes").prop("checked", $(this).prop("checked"));
                });

                ResetQuickAnonymizationDialog(type);

                quickAnonymizationStep = 0;
                QuickAnonymizationDialogNext(0);

                AJS.dialog2("#quick-anonymizer-dialog").show();
            }

            function QuickAnonymizationDialogNext(value) {
                if (value > 0 && !validateQuickAnonymizationStep())
                    return;

                quickAnonymizationStep += value;

                if (quickAnonymizationType == "ticket" && quickAnonymizationOperationType == 1 && quickAnonymizationStep == 5) {
                    quickAnonymizationStep -= 3;
                }

                if (quickAnonymizationType == "ticket" && quickAnonymizationStep == 3) {
                    quickAnonymizationStep += value;
                }

                if (quickAnonymizationOperationType == 1 && quickAnonymizationStep == 4) {
                    quickAnonymizationStep += value;
                }

                if (quickAnonymizationType == "ticket" && quickAnonymizationOperationType == 1 && quickAnonymizationStep == 5) {
                    quickAnonymizationStep += value;
                }

                //console.log("=======");
                //console.log(quickAnonymizationType);
                //console.log(quickAnonymizationOperationType);
                //console.log(quickAnonymizationStep);

                $("#quick-anonymizer-dialog .step").hide();
                $("#quick-anonymizer-dialog .step-" + quickAnonymizationStep).show();

                var btnGoBack = $("#quick-anonymizer-dialog .btn-go-back");
                var btnContinue = $("#quick-anonymizer-dialog .btn-continue");
                var checkboxConfirm = $("#builtin-user-anonymizer-checkbox-confirm");
                var checkboxDisableUsersConfirm = $("#builtin-user-anonymizer-checkbox-disable-users-confirm");
                var stepNumber = $("#quick-anonymizer-dialog .quick-anonymizer-dialog-title .span-step-number");
                checkboxConfirm.prop("checked", false);

                btnContinue.html(AJS.I18n.getText("buttons.main.continue"));
                btnContinue.off("click");
                btnContinue.on("click", function() {
                    QuickAnonymizationDialogNext(1);
                });

                //console.log("quickAnonymizationStep="+quickAnonymizationStep);

                if (quickAnonymizationType == "ticket" && quickAnonymizationOperationType == 0)
                    maxCountSteps = 4;
                else if (quickAnonymizationType == "ticket" && quickAnonymizationOperationType == 1)
                    maxCountSteps = 4;
                else if (quickAnonymizationType == "user" && quickAnonymizationOperationType == 0)
                    maxCountSteps = 5;
                else
                    maxCountSteps = 6;

                currentStep = quickAnonymizationStep;

                if (quickAnonymizationType == "ticket" && quickAnonymizationStep > 5) {
                    currentStep -= 1;
                }

                if (quickAnonymizationOperationType == 1 && quickAnonymizationStep > 4) {
                    currentStep -= 1;
                }

                if (quickAnonymizationType == "ticket" && quickAnonymizationStep > 3) {
                    currentStep -= 1;
                }

                stepNumber.html("Step " + (currentStep + 1) + " of " + maxCountSteps);
                $("#quick-anonymizer-dialog .step-" + quickAnonymizationStep).find("span.step-number").html(currentStep + 1);

                if (quickAnonymizationType == "ticket") {
                    $(".builtin-user-anonymizer-post-anonymization-options").hide();
                } else {
                    $(".builtin-user-anonymizer-post-anonymization-options").show();
                }

                switch (quickAnonymizationStep) {
                    case 0:
                        stepNumber.html("");
                        btnGoBack.hide();
                        btnContinue.show();
                        break;
                    case 1:
                        btnGoBack.show();
                        btnContinue.show();

                        if (quickAnonymizationType == "ticket") {
                            $(".step-label-1").html(AJS.I18n.getText("buttons.main.choose-user"));
                        } else {
                            $(".step-label-1").html(AJS.I18n.getText("buttons.main.choose-which"));
                        }

                        $("#builtin-user-anonymizer-settings-form-users-target-user").show();
                        if (quickAnonymizationType == "user" && quickAnonymizationOperationType == 0) {
                            $("#builtin-user-anonymizer-settings-form-users-target-user").hide();
                        }
                        break;
                    case 2:
                        btnGoBack.show();
                        btnContinue.show();
                        if (quickAnonymizationType == "ticket" && quickAnonymizationOperationType == 0)
                            btnContinue.html(AJS.I18n.getText("buttons.main.review"));
                        break;
                    case 3:
                        btnGoBack.show();
                        btnContinue.show();
                        if (quickAnonymizationOperationType == 0)
                            btnContinue.html(AJS.I18n.getText("buttons.main.review"));
                        break;
                    case 4:
                        var sourceUser = $("#builtin-user-anonymizer-source-user").val();
                        var targetUser = $("#builtin-user-anonymizer-target-user").val();
                        var scope = "-";
                        if (selectedProjectType === "current") scope = $("#builtin-user-anonymizer-scope").val();
                        else if (selectedProjectType === "archived") scope = $("#builtin-archived-projects-scope").val();

                        if (quickAnonymizationType == "ticket") {
                            sourceUser = "any";
                        }

                        $("#quick-anonymizer-dialog .review-user1-value").html(sourceUser != "" ? sourceUser : "-");
                        $("#quick-anonymizer-dialog .review-user2-value").html(targetUser != "" ? targetUser : "-");
                        $("#quick-anonymizer-dialog .review-scope-value").html(scope != "" ? scope : "-");

                        btnGoBack.show();
                        btnContinue.show();
                        if (quickAnonymizationOperationType == 0) {
                            btnContinue.html(AJS.I18n.getText("buttons.main.search"));
                            btnContinue.off("click");
                            btnContinue.on("click", function() {
                                updateUserAnonymizerTemplate(0);
                            });
                        } else {
                            btnContinue.html(AJS.I18n.getText("buttons.main.anonymize"));
                        }
                        break;
                    case 5:
                        btnGoBack.show();
                        btnContinue.show();
                        btnContinue.html(AJS.I18n.getText("buttons.main.anonymize"));
                        break;
                    case 6:
                        var sourceUser = $("#builtin-user-anonymizer-source-user").val();
                        var targetUser = $("#builtin-user-anonymizer-target-user").val();
                        var scope = $("#builtin-user-anonymizer-scope").val();

                        if (quickAnonymizationType == "ticket") {
                            sourceUser = "any";
                        }

                        $("#quick-anonymizer-dialog .review-user1-value").html(sourceUser != "" ? sourceUser : "-");
                        $("#quick-anonymizer-dialog .review-user2-value").html(targetUser != "" ? targetUser : "-");
                        $("#quick-anonymizer-dialog .review-scope-value").html(scope != "" ? scope : "-");

                        btnGoBack.show();
                        btnContinue.show();
                        btnContinue.html(AJS.I18n.getText("buttons.main.anonymize"));
                        btnContinue.off("click");
                        btnContinue.on("click", function() {
                            if (!checkboxConfirm.prop("checked")) {
                                flags.simpleWarning(AJS.I18n.getText("js-data-clean.template.error.confirm-start-anonymize-process"));
                                return;
                            }
                            /*if (!checkboxDisableUsersConfirm.prop("checked")) {
                                flags.simpleWarning(AJS.I18n.getText("js-data-clean.template.error.confirm-disable-users"));
                                return;
                            }*/
                            quickAnonymizationDisableUsers = checkboxDisableUsersConfirm.prop("checked");
                            updateUserAnonymizerTemplate(1);
                        });
                        break;
                }
            }

            function validateQuickAnonymizationStep() {
                switch (quickAnonymizationStep) {
                    case 0:
                        return true;
                        break;
                    case 1:
                        var sourceUserNames = $("#builtin-user-anonymizer-source-user").val();
                        var targetUserName = $("#builtin-user-anonymizer-target-user").val();
                        var userNames;
                        var anonymizerIds = [];

                        if (quickAnonymizationType == "user"
                            && quickAnonymizationOperationType == 0
                            && !targetUserName) {
                            targetUserName = "not specified";
                        }

                        if (quickAnonymizationType == "user") {
                            if (!sourceUserNames && targetUserName) {
                                flags.simpleWarning(AJS.I18n.getText("js-data-clean.template.error.no-source-user-defined"));
                                return false;
                            }

                            if (!(sourceUserNames && targetUserName)) {
                                flags.simpleWarning(AJS.I18n.getText("js-data-clean.template.error.no-user-defined"));
                                return false;
                            }

                            var sourceUserNamesArray = sourceUserNames.split(",");

                            if (sourceUserNamesArray.indexOf(targetUserName) > -1) {
                                flags.simpleWarning(AJS.I18n.getText("js-data-clean.template.error.users-must-be-different"));
                                return false;
                            }
                        } else {
                            if (!targetUserName) {
                                flags.simpleWarning(AJS.I18n.getText("js-data-clean.template.error.no-target-user-defined"));
                                return false;
                            }
                        }
                        return true;
                        break;
                    case 2:
                        if (quickAnonymizationType == "ticket") {
                            if (!$("#builtin-user-anonymizer-scope").val().trim()) {
                                flags.simpleWarning(AJS.I18n.getText("js-data-clean.template.error.no-scope-jql"));
                                return false;
                            }
                        }
                        return true;
                        break;
                    case 3:
                        var anonymizerIds = [];
                        var customAnonymizers = $("#builtin-user-anonymizer-custom-anonymizers .checkbox-custom-anonymizer:checked");
                        customAnonymizers.each(function () {
                            anonymizerIds.push(parseInt($(this).attr("data-id")));
                        });
                        if (!checkboxContentChanges.prop("checked") && anonymizerIds.length == 0) {
                            flags.simpleWarning(AJS.I18n.getText("js-data-clean.template.error.no-option-select"));
                            return false;
                        }
                        return true;
                        break;
                    case 4:
                        return true;
                        break;
                    case 5:
                        return true;
                        break;
                    case 6:
                        return true;
                        break;
                }
            }

            function setQuickAnonymizationType(type) {
                if (type == "user") {
                    quickAnonymizationType = "user";

                    $("#quick-anonymizer-dialog .quick-anonymizer-dialog-title .span-title").html(AJS.I18n.getText("js-data-cleaner.dashboard.main-page.quick-anonymizer-user-title"));
                    $("#quick-anonymizer-dialog .quick-anonymizer-dialog-title .span-step-number").html("");

                    $("#builtin-user-anonymizer-settings-form-users-source-user").show();
                    $("#builtin-user-anonymizer-post-functions").show();
                    $(".builtin-user-anonymizer-checkbox-content-changes").removeAttr("checked");
                    $(".builtin-user-anonymizer-checkbox-content-changes").removeAttr("disabled");
                    $("#builtin-user-anonymizer-jql-settings span.icon-required").css("opacity", 0);
                } else if (type == "ticket") {
                    quickAnonymizationType = "ticket";

                    $("#quick-anonymizer-dialog .quick-anonymizer-dialog-title .span-title").html(AJS.I18n.getText("js-data-cleaner.dashboard.main-page.quick-anonymizer-content-title"));
                    $("#quick-anonymizer-dialog .quick-anonymizer-dialog-title .span-step-number").html("");

                    $("#builtin-user-anonymizer-settings-form-users-source-user").hide();
                    $("#builtin-user-anonymizer-post-functions").hide();
                    $(".builtin-user-anonymizer-checkbox-content-changes").attr("checked", "checked");
                    $(".builtin-user-anonymizer-checkbox-content-changes").attr("disabled", "disabled");
                    $("#builtin-user-anonymizer-jql-settings span.icon-required").css("opacity", 1);
                }
            }

            function loadTemplateData() {
                TemplatesRest.getById(currentTemplateId,
                    function (templateData) {
                        if (templateData!== null &&'task' in templateData ) {
                            if( templateData.task.status == TASK_STATUS.IN_PROGRESS || templateData.task.status == TASK_STATUS.NOT_STARTED){
                            $(".builtin-quick-anonymization-task-in-progress-btn").show();
                            $(".builtin-quick-anonymization-anonymize-users-btn").hide();
                            $(".builtin-quick-anonymization-anonymize-tickets-btn").hide();
                            }
                            /*$("#builtin-user-anonymizer-search").hide();
                            $("#builtin-user-anonymizer-anonymize").hide();
                            $("#builtin-user-anonymizer-stop").show();

                            $("#builtin-user-anonymizer-settings-form").hide();
                            $("#builtin-user-anonymizer-settings-process").show();

                            $("#builtin-user-anonymizer-settings-process #task-status").html("<span class='aui-lozenge aui-lozenge-subtle aui-lozenge-complete'>" +
                                AJS.I18n.getText('js-data-clean.rp.text.status.in-progress') +
                                "</span>");
                            $("#builtin-user-anonymizer-settings-process-created-by").html(templateData.task.creator);
                            $("#builtin-user-anonymizer-settings-process-started-at").html(templateData.task.startDate);
                            $("#builtin-user-anonymizer-settings-process-message").html(templateData.task.taskMessage);
                            $("#builtin-user-anonymizer-settings-process-items").html(templateData.task.taskCurrentNum + " of " + templateData.task.taskTotalNum);*/
                        } else {
                            $(".builtin-quick-anonymization-task-in-progress-btn").hide();
                            $(".builtin-quick-anonymization-anonymize-users-btn").show();
                            $(".builtin-quick-anonymization-anonymize-tickets-btn").show();

                            /*$("#builtin-user-anonymizer-search").show();
                            $("#builtin-user-anonymizer-anonymize").show();
                            $("#builtin-user-anonymizer-stop").hide();

                            $("#builtin-user-anonymizer-settings-form").show();
                            $("#builtin-user-anonymizer-settings-process").hide();*/
                        }
                        setTimeout(loadTemplateData, 1000);
                    });
            };

            /*function loadCustomAnonymizers() {
                TemplatesRest.getCustomAnonymizers(function (data) {
                    var table = $(".builtin-user-anonymizer-objects-wrapper");
                    table.html("");
                    data.forEach(function (item) {
                        var tr = ACTONIC.GDPR.DATACLEANER.MAIN.createCustomAnonymizerRow({
                            id: item.id,
                            name: item.name,
                            pluginName: item.pluginName
                        });
                        table.append(tr);
                    });
                    $(".checkbox-custom-anonymizer").off("change");
                    $(".checkbox-custom-anonymizer").on("change", function() {
                        $(".checkbox-custom-anonymizer-"+$(this).attr("data-id")).prop("checked", $(this).prop("checked"));
                    });
                }, null);
            };*/

            function updateUserAnonymizerTemplate(taskType) {
                var sourceUserNames = $("#builtin-user-anonymizer-source-user").val();
                var targetUserName = $("#builtin-user-anonymizer-target-user").val();
                var userNames;
                var anonymizerIds = [];

                if (taskType == 0 && !targetUserName) {
                    targetUserName = "not specified";
                }

                if (quickAnonymizationType == "user") {
                    if (!(sourceUserNames && targetUserName)) {
                        flags.simpleWarning(AJS.I18n.getText("js-data-clean.template.error.no-user-defined"));
                        return;
                    }

                    var sourceUserNamesArray = sourceUserNames.split(",");

                    if (sourceUserNamesArray.indexOf(targetUserName) > -1) {
                        flags.simpleWarning(AJS.I18n.getText("js-data-clean.template.error.users-must-be-different"));
                        return;
                    }

                    /*var customAnonymizers = $("#builtin-user-anonymizer-custom-anonymizers .checkbox-custom-anonymizer:checked");
                    customAnonymizers.each(function () {
                        anonymizerIds.push(parseInt($(this).attr("data-id")));
                    });*/

                    if (!checkboxContentChanges.prop("checked") && anonymizerIds.length == 0) {
                        flags.simpleWarning(AJS.I18n.getText("js-data-clean.template.error.no-option-select"));
                        return;
                    }

                    userNames = [...sourceUserNamesArray];
                } else {
                    if (!targetUserName) {
                        flags.simpleWarning(AJS.I18n.getText("js-data-clean.template.error.no-target-user-defined"));
                        return;
                    }

                    if (!$("#builtin-user-anonymizer-scope").val().trim()) {
                        flags.simpleWarning(AJS.I18n.getText("js-data-clean.template.error.no-scope-jql"));
                        return;
                    }

                    sourceUserNames = "any user";
                    userNames = [];
                }

                if (targetUserName != "not specified")
                    userNames.push(targetUserName);

                var jql = "";
                if (selectedProjectType === "current")
                    jql = $("#builtin-user-anonymizer-scope").val();
                else if (selectedProjectType === "archived")
                    jql = $("#builtin-archived-projects-scope").val();
                var cqlType = $("#cql-type").val();


                var templateId = -1;
                var subName = ' (' + sourceUserNames + '->' + targetUserName + ')';
                var request = {
                    id: templateId,
                    name: AJS.I18n.getText("js-data-clean.template.uat.text.name") + subName,
                    cql: jql,
                    cqlType: cqlType,
                    objects: fieldIds,
                    notificationType: "none",
                    templateType: quickAnonymizationType + "," + selectedProjectType,
                    taskType: taskType,
                    disableUsers: quickAnonymizationDisableUsers,
                    sourceUsers: sourceUserNames,
                    targetUser: targetUserName,
                    anonymizerIds: anonymizerIds.join(",")
                };

                if (!checkboxContentChanges.prop("checked")) {
                    request.objects = [];
                }

                validateTemplateCQL(request.cql, request.cqlType, function() {
                    TemplatesRest.quickUserAnonymize(templateId, request, function () {
                        goAfterUpdate(templateId);
                    }, function (error) {
                        log.error("TemplatesRest.update error = " + JSON.stringify(error));
                    });
                });
            }

            function goAfterUpdate(templateId) {
                window.location = AJS.contextPath() + "/admin/actonic-gdpr/data-cleaner-results.action?templateId=" + templateId;
            }

            function validateTemplateCQL(cql, cqlType, successCallback) {
                if (cql && cql !== "") {
                    if (cqlType === "cql") {
                        TemplatesRest.checkCql(cql,
                            function (data) {
                                log.debug("Rest.checkCql data = " + JSON.stringify(data));
                                log.debug(data);
                                if (data && data.value) {
                                    coreHighlighter.redBorder($("#scope"));
                                    flags.showFlag(AJS.I18n.getText("warning.main.validation-error"), "Scope (CQL) defined by CQL is not valid. " + data.value, "warning");
                                } else {
                                    successCallback();
                                }
                            },
                            function (xhr) {
                                log.error(xhr);
                            }
                        );
                    }
                    if (cqlType === "params") {
                        try {
                            var json = JSON.parse(cql);
                            successCallback();
                        } catch (e) {
                            coreHighlighter.redBorder($("#scope"));
                            flags.showFlag(AJS.I18n.getText("warning.main.validation-error"), "Scope (CQL) defined by parameters is not valid.", "warning");
                        }
                    }
                } else {
                    coreHighlighter.redBorder($("#scope"));
                    flags.showFlag(AJS.I18n.getText("warning.main.validation-error"), "Scope (CQL) is empty or some parameters is not valid.", "warning");
                }
            }

            function stopUserAnonymizerTemplate() {
                TaskRest.cancelTask(currentTemplateId,
                    function (data) {
                    },
                    function (xhr) {
                        log.error(xhr);
                    }
                )
            };

            function checkForProperPluginConfiguration() {
                TemplatesRest.getDataRulesConfigurationStatus(
                    function (data) {
                        if (!data || data.status == "error") {
                            flags.show({
                                type: "error",
                                close: "manual",
                                body: "<p>" + AJS.I18n.getText("js-data-rules.drp.text.error.dc-conf") + "</p>" +
                                    "<p><b>" + data.message + "</b></p>" +
                                    "<p>" + AJS.I18n.getText("js-sensitive-data.execute.rest.get-config-status.flags.error.desc") + "</p>"
                            });
                        }
                    },
                    function (error) {
                        log.error("Rest.getDataRulesConfigurationStatus error = " + JSON.stringify(error));
                    });
            }

            function createCustomRuleClickHandler(event) {
                event.preventDefault();

                var request = {
                    type: "custom",
                    action: "create"
                };
                TemplatesRest.draft(request, function (data) {
                    window.open("edit-data-cleaner-template.action?type=" + request.type + "&id=" + data, "_blank");
                }, function (xhr) {
                    log.error(xhr);
                });
            }

            function confirmDeleteTemplateCancelHandler(event) {
                event.preventDefault();

                currentTemplateId = -1;
                AJS.dialog2("#confirm-delete-template-dialog").hide();
            }

            function confirmDeleteTemplateOkHandler(event) {
                event.preventDefault();
                TemplatesRest.delete(currentTemplateId, function (data) {
                    $($("#name-" + currentTemplateId).parent()).addClass("delete-in-progress");
                    flags.simpleSuccess("Template successfully deleted");
                }, function (xhr) {
                    flags.simpleWarning(xhr)
                    log.error(xhr);
                });
                AJS.dialog2("#confirm-delete-template-dialog").hide();
            }


            function setupIntro() {
                CoreIntro.init({
                    name: "data-cleaner",
                    stepsArr: [
                        {
                            intro: AJS.I18n.getText("js-data-clean.mp.intro.text.one")
                        },
                        {
                            element: document.querySelector('#anonymize-user'),
                            intro: AJS.I18n.getText("js-data-clean.mp.intro.text.two")
                        },
                        {
                            element: document.querySelector('#anonymize-pii'),
                            intro: AJS.I18n.getText("js-data-clean.mp.intro.text.three")
                        },
                        {
                            element: document.querySelector('#create-custom-rule-btn'),
                            intro: AJS.I18n.getText("js-data-clean.mp.intro.text.four")
                        }
                    ]
                });
            }

            function updateTemplateList() {
                TemplatesRest.getAll(function (data) {
                    //log.debug(data);
                    if ($("#progress-bar").is(":visible")) $("#progress-bar").hide();

                    if (data && data.length) {
                        $("#custom-search-template").show();
                        $("#data-cleaner-templates").show();
                        $("#data-cleaner-templates-not-found").hide();

                        var tempData = createTemplateData(data);

                        if (tempData !== oldTemplateData) {
                            recentData = data;

                            if(data.length > 0) {
                                $("#custom-search-template").show();
                            }
                            else $("#custom-search-template").hide();

                            dataCleanerResults(data);
                            oldTemplateData = tempData;
                        } else {
                            data.forEach(function (el) {
                                $("#task-container-" + el.id).html(ACTONIC.GDPR.DATACLEANER.MAIN.taskData({temp: el}));
                                if (!el.task || el.task.status >= 2) {
                                    DataCleanerTasks.showStartButtons(el.id);
                                    $(".edit[data-id='" + el.id + "']").show();
                                    $(".delete[data-id='" + el.id + "']").show();
                                } else {
                                    DataCleanerTasks.showStopButtons(el.id)
                                    $(".edit[data-id='" + el.id + "']").hide();
                                    $(".delete[data-id='" + el.id + "']").hide();
                                }
                            });
                        }
                    } else {
                        $("#custom-search-template").hide();
                        $("#data-cleaner-templates").hide();
                        $("#data-cleaner-templates-not-found").show();
                    }

                    setTimeout(updateTemplateList, 3000);
                });
            }

            function createTemplateData(data) {
                var temp = "";
                data.forEach(function (el) {
                    temp += el.lastModificationDate + ":::" + el.dataRulesCount;
                });

                return temp;
            }

            function dataCleanerResults(data) {
                $("#data-cleaner-templates").html(ACTONIC.GDPR.DATACLEANER.MAIN.results({
                    data: data
                }));

                $(".clone").off("click");
                $(".clone").on("click", function (event) {
                    event.preventDefault();
                    currentTemplateId = $(this).attr("data-id");
                    TemplatesRest.clone(currentTemplateId, function (clonedData) {
                        window.open("edit-data-cleaner-template.action?action=edit&id=" + clonedData.id, "_self");
                    }, function (xhr) {
                        log.error(xhr);
                    });
                });
                $(".delete").off("click");
                $(".delete").on("click", function (event) {
                    event.preventDefault();

                    currentTemplateId = $(this).attr("data-id");
                    $("#current-name").html($("#name-" + currentTemplateId).html());
                    AJS.dialog2("#confirm-delete-template-dialog").show();
                });
                DataCleanerTasks.initEvents();
            }
        }
    });
