/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.newDC.manager;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import de.actonic.gdpr.newDC.ao.TaskDCEntity;
import de.actonic.gdpr.newDC.dao.TaskDCDao;
import de.actonic.gdpr.newDC.manager.TemplateDCManager;
import de.actonic.gdpr.shared.general.exception.GDPRBadRequestException;
import de.actonic.gdpr.shared.general.util.GDPRJsonUtils;
import de.actonic.gdpr.shared.newDC.manager.AbstractTaskDCManager;
import de.actonic.gdpr.shared.newDC.manager.ITaskDCManager;
import de.actonic.gdpr.shared.newDC.model.task.TaskDCModel;
import de.actonic.gdpr.shared.newDC.model.task.TaskDCStatus;
import de.actonic.gdpr.shared.newDC.model.task.TaskDCType;
import de.actonic.gdpr.shared.newDC.service.ExecuteDCService;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class TaskDCManager
extends AbstractTaskDCManager {
    private final TaskDCDao taskDao;
    private final TemplateDCManager templateManager;
    private final ExecuteDCService executeService;
    @ComponentImport
    private final SchedulerService schedulerService;

    @PostConstruct
    public void init() {
        this.executeService.setTaskManager((ITaskDCManager)this);
    }

    public TaskDCManager(TaskDCDao taskDao, TemplateDCManager templateManager, ExecuteDCService executeService, SchedulerService schedulerService) {
        this.taskDao = taskDao;
        this.templateManager = templateManager;
        this.executeService = executeService;
        this.schedulerService = schedulerService;
    }

    private TaskDCModel entityToModel(TaskDCEntity entity) {
        if (entity == null) {
            return null;
        }
        return TaskDCModel.builder().id(Integer.valueOf(entity.getID())).template(this.templateManager.entityToModel(entity.getTemplate())).templateVersion(entity.getTemplateVersion()).creator(entity.getCreator()).createDate(entity.getCreateDate()).startDate(entity.getStartDate()).endDate(entity.getEndDate()).duration(entity.getDuration()).status(entity.getStatus()).taskType(entity.getTaskType()).meta((Map)GDPRJsonUtils.fromJson((String)entity.getMeta(), (Type)GDPRJsonUtils.HASHMAP_STRING_OBJECT_TYPE)).taskCurrentNum(entity.getTaskCurrentNum()).taskTotalNum(entity.getTaskTotalNum()).taskAffectedNum(entity.getTaskAffectedNum()).foundObjectsCount(entity.getFoundObjectsCount()).skippedIssueCount(entity.getSkippedIssueCount()).taskMessage(entity.getTaskMessage()).lastUpdateTime(entity.getLastUpdateTime()).parentContentId(entity.getParentContentId()).build();
    }

    public void findAll() {
        this.taskDao.findAllStream();
    }

    private List<TaskDCModel> entitiesToModels(List<TaskDCEntity> entities) {
        return entities.stream().map(this::entityToModel).collect(Collectors.toList());
    }

    public TaskDCModel getCurrentInProgressTask(TaskDCType type) {
        return this.entityToModel(this.taskDao.getFirstFilteredTask(TaskDCStatus.IN_PROGRESS.getCode(), type.getCode()));
    }

    public void setLastUpdateTime(Integer taskId) {
        this.taskDao.setLastUpdateTime(taskId);
    }

    public void cancelTask(Integer taskId, String message) {
        this.taskDao.cancelTask(taskId, message);
    }

    public TaskDCModel getNextTaskForStart(TaskDCType type) {
        return this.entityToModel(this.taskDao.getFirstFilteredTask(TaskDCStatus.NOT_STARTED.getCode(), type.getCode()));
    }

    public void runTask(final TaskDCModel task) {
        JobRunnerKey runnerKey = JobRunnerKey.of((String)"actonic-gdpr-dc-tasks-job-runner");
        this.schedulerService.registerJobRunner(runnerKey, new JobRunner(){

            @Nullable
            public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
                TaskDCManager.this.executeService.execute(task);
                return JobRunnerResponse.success();
            }
        });
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)runnerKey).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.runOnce(null));
        try {
            this.schedulerService.scheduleJobWithGeneratedId(jobConfig);
        }
        catch (SchedulerServiceException sse) {
            this.taskDao.cancelTaskByTemplated(task.getTemplate().getId(), sse.getMessage());
            throw new GDPRBadRequestException(sse.getMessage());
        }
    }

    public TaskDCModel cancelTaskByTemplated(Integer templateId, String message) {
        return this.entityToModel(this.taskDao.cancelTaskByTemplated(templateId, message));
    }

    public List<TaskDCModel> getHistoricalTasksForTemplate(Integer templateId) {
        return this.entitiesToModels(this.taskDao.getHistoricalTasksForTemplate(templateId));
    }

    public boolean hasTaskForTemplate(Integer templateId) {
        return this.taskDao.hasTaskForTemplate(templateId);
    }

    public TaskDCModel createTask(Integer templateId, String username, Integer type) {
        return this.entityToModel(this.taskDao.createTask(templateId, username, type));
    }

    public List<TaskDCModel> getTaskListForStart() {
        return this.entitiesToModels(this.taskDao.getTaskListByStatus(TaskDCStatus.NOT_STARTED.getCode()));
    }

    public TaskDCModel start(Integer taskId) {
        return this.entityToModel(this.taskDao.start(taskId));
    }

    public TaskDCModel failed(Integer taskId, String errorMessage) {
        return this.entityToModel(this.taskDao.failed(taskId, errorMessage));
    }

    public TaskDCModel finish(Integer taskId, int affectedNum, int skipNum, String finishMessage) {
        return this.entityToModel(this.taskDao.finish(taskId, affectedNum, skipNum, finishMessage));
    }

    public void setFoundObjectsCount(Integer taskId, Integer historyEntitiesCountByJobId) {
        this.taskDao.setFoundObjectsCount(taskId, historyEntitiesCountByJobId);
    }

    public Integer getTasksCountForTemplate(int templateId) {
        return this.taskDao.getTaskCountForTemplate(templateId);
    }

    public List<TaskDCModel> getAllTasksForRemoving(int templateId) {
        return this.entitiesToModels(this.taskDao.getAllTasksForRemovingByTemplateId(templateId));
    }

    public void delete(Integer taskId) {
        this.taskDao.delete(taskId);
    }
}

