/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.manager;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import de.actonic.confluence.gdpr.ao.RequestDataHistoryEntity;
import de.actonic.confluence.gdpr.component.manager.AbstractEntityDao;
import de.actonic.confluence.gdpr.model.RequestDataHistoryModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestDataHistoryDao
extends AbstractEntityDao {
    @Autowired
    public RequestDataHistoryDao(@ComponentImport ActiveObjects ao) {
        super(ao);
    }

    public void add(RequestDataHistoryModel model) {
        this.add(model.getTaskId(), model.getRelationType(), model.getCurrentObject(), model.getCurrentTitle(), model.getParentObject(), model.getParentTitle(), model.getSpaceKey(), new Gson().toJson(model.getExtra()));
    }

    public void add(Integer taskId, Integer type, String currentObject, String currentTitle, String parentObject, String parentTitle, String spaceKey, String extra) {
        this.ao.executeInTransaction(() -> {
            RequestDataHistoryEntity entity = (RequestDataHistoryEntity)this.ao.create(RequestDataHistoryEntity.class, new DBParam[0]);
            entity.setTaskId(taskId);
            entity.setRelationType(type);
            entity.setCurrentObject(currentObject);
            entity.setCurrentTitle(currentTitle);
            entity.setParentObject(parentObject);
            entity.setParentTitle(parentTitle);
            entity.setSpaceKey(spaceKey);
            entity.setExtra(extra);
            entity.save();
            return true;
        });
    }

    public Integer getHistoryCount(Integer taskId, Integer relationType) {
        Query query = Query.select();
        query = relationType != null && relationType >= 0 ? query.where("TASK_ID = ? AND RELATION_TYPE = ?", new Object[]{taskId, relationType}) : query.where("TASK_ID = ?", new Object[]{taskId});
        return this.ao.count(RequestDataHistoryEntity.class, query);
    }

    public List<RequestDataHistoryEntity> getHistory(Integer taskId) {
        List<RequestDataHistoryEntity> result = Arrays.asList((RequestDataHistoryEntity[])this.ao.executeInTransaction(() -> (RequestDataHistoryEntity[])this.ao.find(RequestDataHistoryEntity.class, Query.select().where("TASK_ID = ?", new Object[]{taskId}))));
        return result;
    }

    public List<RequestDataHistoryEntity> getFilteredHistory(Integer taskId, Integer rowsPerPage, Integer relationType, String orderBy, Integer page) {
        ArrayList results = Lists.newArrayList();
        Query query = Query.select();
        query = relationType != null && relationType >= 0 ? query.where("TASK_ID = ? AND RELATION_TYPE = ?", new Object[]{taskId, relationType}) : query.where("TASK_ID = ?", new Object[]{taskId});
        if (StringUtils.equalsIgnoreCase((CharSequence)orderBy, (CharSequence)"relation-type")) {
            query = query.order("RELATION_TYPE");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)orderBy, (CharSequence)"object-create-date")) {
            query = query.order("CURRENT_OBJECT");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)orderBy, (CharSequence)"parent-object-create-date")) {
            query = query.order("PARENT_OBJECT");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)orderBy, (CharSequence)"space-key")) {
            query = query.order("SPACE_KEY");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)orderBy, (CharSequence)"object-name")) {
            query = query.order("CURRENT_TITLE");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)orderBy, (CharSequence)"parent-object-name")) {
            query = query.order("PARENT_TITLE");
        }
        List<RequestDataHistoryEntity> allData = Arrays.asList((RequestDataHistoryEntity[])this.ao.find(RequestDataHistoryEntity.class, query));
        if (page == null || page < 0) {
            return allData;
        }
        Integer previousPage = page - 1 >= 0 ? page - 1 : 0;
        Integer startInd = previousPage * rowsPerPage;
        Integer endInd = page * rowsPerPage;
        if (endInd > allData.size()) {
            endInd = allData.size();
        }
        results.addAll(allData.subList(startInd, endInd));
        return results;
    }
}

