/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.manager;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.search.SearchContext;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.query.ContributorQuery;
import com.atlassian.confluence.search.v2.query.DateRangeQuery;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import com.atlassian.confluence.search.v2.query.LabelQuery;
import com.atlassian.confluence.search.v2.sort.ModifiedSort;
import com.atlassian.confluence.setup.BuildInformation;
import com.atlassian.confluence.user.persistence.dao.ConfluenceUserDao;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class CqlManager {
    private static final Logger log = LoggerFactory.getLogger(CqlManager.class);
    private CQLSearchService cqlSearchService;
    private ContentEntityManager contentEntityManager;
    private SearchManager searchManager;
    private ConfluenceUserDao confluenceUserDao;

    @Autowired
    public CqlManager(@ComponentImport CQLSearchService cqlSearchService, @ComponentImport @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, @ComponentImport SearchManager searchManager, @ComponentImport ConfluenceUserDao confluenceUserDao) {
        this.cqlSearchService = cqlSearchService;
        this.contentEntityManager = contentEntityManager;
        this.searchManager = searchManager;
        this.confluenceUserDao = confluenceUserDao;
    }

    public Optional<String> isCqlValid(String cql) {
        cql = this.convert(cql);
        SimplePageRequest pageRequest = new SimplePageRequest(0, 1);
        try {
            PageResponse contents = this.cqlSearchService.searchContent(cql, SearchContext.EMPTY, (PageRequest)pageRequest, new Expansion[0]);
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.of(e.getMessage());
        }
    }

    public List<AbstractPage> getContentFromCql(String cql, Boolean withVersion) {
        int limit = 100;
        ArrayList results = Lists.newArrayList();
        try {
            int currentCount = 0;
            List<AbstractPage> temp = this.getContentFromCql(cql, currentCount, limit, withVersion);
            while (temp != null && temp.size() > 0) {
                results.addAll(temp);
                temp = this.getContentFromCql(cql, currentCount += temp.size(), limit, withVersion);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public List<AbstractPage> getContentFromCql(String cql, int start, int size, Boolean withVersion) {
        cql = this.convert(cql);
        try {
            SimplePageRequest pageRequest = new SimplePageRequest(start, size);
            PageResponse contents = this.cqlSearchService.searchContent(cql, SearchContext.EMPTY, (PageRequest)pageRequest, new Expansion[0]);
            List results = contents.getResults();
            if (results != null && results.size() > 0) {
                return this.asContentEntityObjects(results, withVersion);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private List<AbstractPage> asContentEntityObjects(List<Content> results, boolean withVersions) {
        ArrayList contentEntityObjects = Lists.newArrayList();
        for (Content result : results) {
            ContentEntityObject ceo = this.contentEntityManager.getById(result.getId().asLong());
            if (!(ceo instanceof Page) && !(ceo instanceof BlogPost)) continue;
            contentEntityObjects.add((AbstractPage)ceo);
            if (!withVersions) continue;
            contentEntityObjects.addAll(this.getVersionList(ceo));
        }
        return contentEntityObjects;
    }

    private List<AbstractPage> asContentEntityObjectsV2(List<Searchable> results, boolean withVersions) {
        ArrayList contentEntityObjects = Lists.newArrayList();
        for (Searchable result : results) {
            ContentEntityObject ceo = this.contentEntityManager.getById(result.getId());
            if (!(ceo instanceof Page) && !(ceo instanceof BlogPost)) continue;
            contentEntityObjects.add((AbstractPage)ceo);
            if (!withVersions) continue;
            contentEntityObjects.addAll(this.getVersionList(ceo));
        }
        return contentEntityObjects;
    }

    public int getIssuesCount(String cql) {
        if (!this.isCqlValid(cql = this.convert(cql)).isPresent()) {
            return this.cqlSearchService.countContent(cql);
        }
        return 0;
    }

    private String convert(String cql) {
        cql = Strings.isNullOrEmpty((String)cql) ? "type IN (blogpost, page)" : cql + " AND type IN (blogpost, page)";
        return cql;
    }

    protected List<AbstractPage> getVersionList(ContentEntityObject versionPage) {
        ArrayList versions = Lists.newArrayList();
        while ((versionPage = this.contentEntityManager.getPreviousVersion(versionPage)) != null) {
            versions.add((AbstractPage)versionPage);
        }
        return versions;
    }

    private ContentSearch getContentSearch(String cql, int start, int size) {
        HashMap params = (HashMap)new Gson().fromJson(cql, new TypeToken<HashMap<String, String>>(){}.getType());
        SearchQuery query = this.convertCqlParamsToQuery(params);
        ModifiedSort sort = new ModifiedSort(SearchSort.Order.DESCENDING);
        return this.getContentSearchCompatible(query, (SearchSort)sort, start, size);
    }

    public List<AbstractPage> getContentFromCqlV2(String cql, int start, int size, Boolean withVersion) {
        try {
            List searchables = this.searchManager.searchEntities((ISearch)this.getContentSearch(cql, start, size), SearchManager.EntityVersionPolicy.LATEST_VERSION);
            return this.asContentEntityObjectsV2(searchables, withVersion);
        }
        catch (InvalidSearchException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Date convertToDate(String dateString) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            return simpleDateFormat.parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private SearchQuery convertCqlParamsToQuery(HashMap<String, String> params) {
        HashSet<Object> convertedQueries = new HashSet<Object>();
        convertedQueries.add(new ContentTypeQuery((Collection)Lists.newArrayList((Object[])new ContentTypeEnum[]{ContentTypeEnum.PAGE, ContentTypeEnum.BLOG})));
        Splitter splitter = Splitter.on((String)",").trimResults().omitEmptyStrings();
        for (String key : params.keySet()) {
            HashSet<Object> tempQueries;
            List splittedValue = splitter.splitToList((CharSequence)params.get(key));
            if (StringUtils.equalsIgnoreCase((String)key, (String)"space")) {
                tempQueries = new HashSet<Object>();
                for (String value : splittedValue) {
                    tempQueries.add(new InSpaceQuery(value));
                }
                convertedQueries.add(BooleanQuery.composeOrQuery(tempQueries));
            }
            if (StringUtils.equalsIgnoreCase((String)key, (String)"contributor")) {
                tempQueries = new HashSet();
                for (String value : splittedValue) {
                    tempQueries.add(new ContributorQuery(value, this.confluenceUserDao));
                }
                convertedQueries.add(BooleanQuery.composeOrQuery(tempQueries));
            }
            if (StringUtils.equalsIgnoreCase((String)key, (String)"label")) {
                tempQueries = new HashSet();
                for (String value : splittedValue) {
                    tempQueries.add(new LabelQuery(value));
                }
                convertedQueries.add(BooleanQuery.composeOrQuery(tempQueries));
            }
            if (!StringUtils.equalsIgnoreCase((String)key, (String)"startDate") && !StringUtils.equalsIgnoreCase((String)key, (String)"endDate")) continue;
            Date from = null;
            Date to = null;
            if (StringUtils.equalsIgnoreCase((String)key, (String)"startDate")) {
                from = this.convertToDate(params.get(key) + " 00:00:00");
            }
            if (StringUtils.equalsIgnoreCase((String)key, (String)"endDate")) {
                to = this.convertToDate(params.get(key) + " 23:59:59");
            }
            if (from == null && to == null) continue;
            convertedQueries.add(new DateRangeQuery(from, to, true, true, StringUtils.equalsIgnoreCase((String)params.get("rangeType"), (String)"created") ? DateRangeQuery.DateRangeQueryType.CREATED : DateRangeQuery.DateRangeQueryType.MODIFIED));
        }
        SearchQuery query = BooleanQuery.composeAndQuery(convertedQueries);
        return query;
    }

    public int getIssueCountV2(String cql) {
        try {
            return this.searchManager.search((ISearch)this.getContentSearch(cql, 0, 1)).getUnfilteredResultsCount();
        }
        catch (InvalidSearchException e) {
            e.printStackTrace();
            return -1;
        }
    }

    private ContentSearch getContentSearchCompatible(SearchQuery query, SearchSort sort, Integer start, Integer size) {
        try {
            String version = BuildInformation.INSTANCE.getVersionNumber();
            Integer majorVersion = this.getMajorVersion(version);
            if (majorVersion == 8) {
                Constructor constructorContentSearch = ContentSearch.class.getConstructor(SearchQuery.class, SearchSort.class, Integer.TYPE, Integer.TYPE);
                return (ContentSearch)constructorContentSearch.newInstance(query, sort, start, size);
            }
            Class<?> searchFilter = Class.forName("com.atlassian.confluence.search.v2.SearchFilter");
            Constructor constructorContentSearch = ContentSearch.class.getConstructor(SearchQuery.class, SearchSort.class, searchFilter, Integer.TYPE, Integer.TYPE);
            return (ContentSearch)constructorContentSearch.newInstance(query, sort, null, start, size);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            e.printStackTrace();
            return null;
        }
    }

    private Integer getMajorVersion(String version) {
        try {
            String[] parts = version.split("\\.");
            return Integer.parseInt(parts[0]);
        }
        catch (Exception e) {
            return -1;
        }
    }
}

