define("actonic-gdpr/user-anonymizer/intro", ["jquery", "actonic-gdpr/core/intro-rest"], function ($, CoreIntroRest) {

    var Intro = {
        init: function () {
            var username = AJS.Meta.get("remote-user");
            if (username) {
                CoreIntroRest.isIntroShowed("anonymizer", username,
                    function (data) { // success
                        //log.debug(data);
                        if (!data) {
                            if (introJs) {
                                Intro.setIntroSteps();

                                var tour = introJs();
                                tour.setOption('tooltipPosition', 'auto');
                                tour.setOption('positionPrecedence', ['left', 'right', 'bottom', 'top']);
                                tour.start();
                            } else {
                                log.error("intro.cannot.load.introjs.not.found");
                            }
                        }
                    },
                    function (data) { // error
                        log.error("intro.cannot.load.connection.error " + data.responseText);
                    });
            } else {
                log.error("intro.cannot.load.user.not.found");
            }
        },
        showIntro: function() {
            if (introJs) {
                Intro.setIntroSteps();

                var tour = introJs();
                tour.setOption('tooltipPosition', 'auto');
                tour.setOption('positionPrecedence', ['left', 'right', 'bottom', 'top']);
                tour.start();
            } else {
                log.error("intro.cannot.load.introjs.not.found");
            }
        },
        setIntroSteps: function () {
            $("#s2id_source-user-picker").attr("data-step", "1").attr("data-intro", AJS.I18n.getText("js-anonymizer.intro.step-1"));
            $("#s2id_target-user-picker").attr("data-step", "2").attr("data-intro", AJS.I18n.getText("js-anonymizer.intro.step-2"));
            $("#aui-uid-0").parent().attr("data-step", "3").attr("data-intro", AJS.I18n.getText("js-anonymizer.intro.step-3"));
            $("#aui-uid-1").attr("data-step", "4").attr("data-intro", AJS.I18n.getText("js-anonymizer.intro.step-4"));
            $("#content-tab").attr("data-step", "5").attr("data-intro", AJS.I18n.getText("js-anonymizer.intro.step-5"));
            $("#get-affected-content-btn").attr("data-step", "6").attr("data-intro", AJS.I18n.getText("js-anonymizer.intro.step-6"));
            $("#execute-btn").attr("data-step", "7").attr("data-intro", AJS.I18n.getText("js-anonymizer.intro.step-7"));
        }
    }

    return Intro;
});
