/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.general.manager;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.base.Strings;
import de.actonic.gdpr.shared.general.manager.GDPRAbstractSettingsManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GDPRSettingsManager
extends GDPRAbstractSettingsManager {
    private final PluginSettings pluginSettings;

    @Autowired
    public GDPRSettingsManager(@ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey("de.actonic.confluence.gdpr");
    }

    public Object getFieldByName(String name) {
        return null;
    }

    public void setFieldByName(String name, Object value) {
    }

    public Integer getRowsPerPage() {
        String rowsPerPage = (String)this.pluginSettings.get("ROWS_PER_PAGE");
        if (Strings.isNullOrEmpty((String)rowsPerPage) || Integer.valueOf(rowsPerPage) <= 0) {
            return ROWS_PER_PAGE_DEFAULT_VALUE;
        }
        return Integer.valueOf(rowsPerPage);
    }

    public void setRowsPerPage(int rowsPerPage) {
        String propertyValue = String.valueOf(rowsPerPage);
        try {
            if (rowsPerPage <= 0 || rowsPerPage > 1000) {
                propertyValue = String.valueOf(ROWS_PER_PAGE_DEFAULT_VALUE);
            }
        }
        catch (NumberFormatException nfe) {
            propertyValue = String.valueOf(ROWS_PER_PAGE_DEFAULT_VALUE);
        }
        this.pluginSettings.put("ROWS_PER_PAGE", (Object)propertyValue);
    }

    public void setRowsPerPageAsString(String rowsPerPage) {
    }

    public boolean getTrackIssueAccessStatistics() {
        String trackAmplitudeStatistics = (String)this.pluginSettings.get("TRACK_ISSUE_ACCESS_STATISTICS");
        if (Strings.isNullOrEmpty((String)trackAmplitudeStatistics) || Boolean.valueOf(trackAmplitudeStatistics) == null) {
            return true;
        }
        return Boolean.valueOf(trackAmplitudeStatistics);
    }

    public void setTrackIssueAccessStatistics(boolean trackIssueAccessStatistics) {
        this.pluginSettings.put("TRACK_ISSUE_ACCESS_STATISTICS", (Object)String.valueOf(trackIssueAccessStatistics));
    }

    public boolean getTrackAmplitudeStatistics() {
        String trackAmplitudeStatistics = (String)this.pluginSettings.get("TRACK_AMPLITUDE_STATISTICS");
        if (Strings.isNullOrEmpty((String)trackAmplitudeStatistics) || Boolean.valueOf(trackAmplitudeStatistics) == null) {
            return false;
        }
        return Boolean.valueOf(trackAmplitudeStatistics);
    }

    public void setTrackAmplitudeStatistics(boolean trackAmplitudeStatistics) {
        this.pluginSettings.put("TRACK_AMPLITUDE_STATISTICS", (Object)String.valueOf(trackAmplitudeStatistics));
    }

    public boolean getShowAnnouncementInRealTime() {
        String showAnnouncementInRealTime = (String)this.pluginSettings.get("SHOW_ANNOUNCEMENT_IN_REAL_TIME");
        if (Strings.isNullOrEmpty((String)showAnnouncementInRealTime) || Boolean.valueOf(showAnnouncementInRealTime) == null) {
            return true;
        }
        return Boolean.valueOf(showAnnouncementInRealTime);
    }

    public void setShowAnnouncementInRealTime(boolean showAnnouncementInRealTime) {
        this.pluginSettings.put("SHOW_ANNOUNCEMENT_IN_REAL_TIME", (Object)String.valueOf(showAnnouncementInRealTime));
    }

    public boolean getTrackPageAccessStatistics() {
        String trackPageAccessStatistics = (String)this.pluginSettings.get("TRACK_PAGE_ACCESS_STATISTICS");
        if (Strings.isNullOrEmpty((String)trackPageAccessStatistics) || Boolean.valueOf(trackPageAccessStatistics) == null) {
            return true;
        }
        return Boolean.valueOf(trackPageAccessStatistics);
    }

    public void setTrackPageAccessStatistics(boolean trackIssueAccessStatistics) {
        this.pluginSettings.put("TRACK_PAGE_ACCESS_STATISTICS", (Object)String.valueOf(trackIssueAccessStatistics));
    }

    public Integer getPurgeAccessStatisticsAfter() {
        String purgeAccessStatisticsAfter = (String)this.pluginSettings.get("PURGE_ACCESS_STATISTICS_AFTER");
        if (Strings.isNullOrEmpty((String)purgeAccessStatisticsAfter) || Integer.valueOf(purgeAccessStatisticsAfter) <= 30 || Integer.valueOf(purgeAccessStatisticsAfter) > 9999) {
            return PURGE_ACCESS_STATISTICS_AFTER_DEFAULT_VALUE;
        }
        return Integer.valueOf(purgeAccessStatisticsAfter);
    }

    public void setPurgeAccessStatisticsAfter(int purgeAccessStatisticsAfter) {
        String propertyValue = String.valueOf(purgeAccessStatisticsAfter);
        try {
            if (purgeAccessStatisticsAfter <= 30 || purgeAccessStatisticsAfter > 9999) {
                propertyValue = String.valueOf(PURGE_ACCESS_STATISTICS_AFTER_DEFAULT_VALUE);
            }
        }
        catch (NumberFormatException nfe) {
            propertyValue = String.valueOf(PURGE_ACCESS_STATISTICS_AFTER_DEFAULT_VALUE);
        }
        this.pluginSettings.put("PURGE_ACCESS_STATISTICS_AFTER", (Object)propertyValue);
    }

    public void setPurgeAccessStatisticsAfterAsString(String purgeAccessStatisticsAfter) {
    }

    public void setRunTasksFromUser(String runTasksFromUser) {
        this.pluginSettings.put("RUN_TASKS_FROM_USER", (Object)runTasksFromUser);
    }

    public String getRunTasksFromUser() {
        String runTasksFromUser = (String)this.pluginSettings.get("RUN_TASKS_FROM_USER");
        return runTasksFromUser == null ? "" : runTasksFromUser;
    }

    public String getAllowedGroup() {
        String runGdprGroup = (String)this.pluginSettings.get("ALLOWED_GROUP_PROPERTY_NAME");
        return runGdprGroup == null ? "" : runGdprGroup;
    }

    public void setAllowedGroup(String allowedGroup) {
        this.pluginSettings.put("ALLOWED_GROUP_PROPERTY_NAME", (Object)allowedGroup);
    }

    public boolean isServiceManagementInstalled() {
        return false;
    }

    public Integer getExecutionHistoryCount() {
        String rowsPerPage = (String)this.pluginSettings.get("HISTORY_COUNT");
        if (Strings.isNullOrEmpty((String)rowsPerPage) || Integer.valueOf(rowsPerPage) <= 0) {
            return EXECUTION_HISTORY_COUNT_VALUE;
        }
        return Integer.valueOf(rowsPerPage);
    }

    public void setExecutionHistoryCount(Integer executionHistoryCount) {
        this.pluginSettings.put("HISTORY_COUNT", (Object)String.valueOf(executionHistoryCount));
    }

    public Integer getExecutionEntriesCount() {
        String rowsPerPage = (String)this.pluginSettings.get("ENTRIES_NAME");
        if (Strings.isNullOrEmpty((String)rowsPerPage) || Integer.valueOf(rowsPerPage) <= 0) {
            return EXECUTION_ENTRIES_VALUE;
        }
        return Integer.valueOf(rowsPerPage);
    }

    public void setExecutionEntriesCount(Integer executionEntriesCount) {
        this.pluginSettings.put("ENTRIES_NAME", (Object)String.valueOf(executionEntriesCount));
    }

    public Integer getTaskTimeout() {
        String taskTimeout = (String)this.pluginSettings.get("TASK_TIMEOUT");
        if (Strings.isNullOrEmpty((String)taskTimeout) || Integer.valueOf(taskTimeout) <= 0) {
            return TASK_TIMEOUT_DEFAULT_VALUE;
        }
        return Integer.valueOf(taskTimeout);
    }

    public void setTaskTimeout(Integer timeout) {
        this.pluginSettings.put("TASK_TIMEOUT", (Object)String.valueOf(timeout));
    }

    public Double getAttachmentMaxSize() {
        String taskTimeout = (String)this.pluginSettings.get("ATTACHMENT_MAX_SIZE");
        if (Strings.isNullOrEmpty((String)taskTimeout) || Double.parseDouble(taskTimeout) < 0.0) {
            return ATTACHMENT_MAX_SIZE_DEFAULT_VALUE;
        }
        return Double.valueOf(taskTimeout);
    }

    public void setAttachmentMaxSize(Double maxSize) {
    }

    public String getNodeId() {
        return null;
    }

    public void setNodeId(String s) {
    }

    public Integer getThreadsNumber() {
        return null;
    }

    public void setThreadsNumber(Integer integer) {
    }
}

