/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.manager;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.google.common.collect.Lists;
import de.actonic.confluence.gdpr.component.manager.AbstractEntityDao;
import de.actonic.confluence.gdpr.current.datacleaner.ao.DataCleanerScheduleEntity;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCleanerSchedulerDao
extends AbstractEntityDao {
    @Autowired
    public DataCleanerSchedulerDao(ActiveObjects ao) {
        super(ao);
    }

    public DataCleanerScheduleEntity getById(Integer id) {
        return this.getFirstByField(DataCleanerScheduleEntity.class, "ID", id);
    }

    public List<DataCleanerScheduleEntity> getScheduledTasksForTemplate(Integer templateId) {
        return (List)this.ao.executeInTransaction(() -> Lists.newArrayList((Object[])((DataCleanerScheduleEntity[])this.ao.find(DataCleanerScheduleEntity.class, "TEMPLATE_ID = ?", new Object[]{templateId}))));
    }

    public List<DataCleanerScheduleEntity> getActiveScheduledTasksForTemplate(Integer templateId) {
        return (List)this.ao.executeInTransaction(() -> Lists.newArrayList((Object[])((DataCleanerScheduleEntity[])this.ao.find(DataCleanerScheduleEntity.class, "TEMPLATE_ID = ? AND ENABLED = ?", new Object[]{templateId, Boolean.TRUE}))));
    }

    public List<DataCleanerScheduleEntity> getAllActiveScheduledTasks() {
        return this.getScheduledTasksByEnabledState(Boolean.TRUE);
    }

    public List<DataCleanerScheduleEntity> getAllInActiveScheduledTasks() {
        return this.getScheduledTasksByEnabledState(Boolean.FALSE);
    }

    private List<DataCleanerScheduleEntity> getScheduledTasksByEnabledState(Boolean enabledState) {
        return (List)this.ao.executeInTransaction(() -> Lists.newArrayList((Object[])((DataCleanerScheduleEntity[])this.ao.find(DataCleanerScheduleEntity.class, "ENABLED = ?", new Object[]{enabledState}))));
    }

    public DataCleanerScheduleEntity create(Integer templateId, String cron, Boolean enabled, Integer taskType) {
        return (DataCleanerScheduleEntity)this.ao.executeInTransaction(() -> {
            DataCleanerScheduleEntity entity = (DataCleanerScheduleEntity)this.ao.create(DataCleanerScheduleEntity.class, new DBParam[0]);
            entity.setTemplateId(templateId);
            entity.setCron(cron);
            entity.setEnabled(enabled);
            entity.setTaskType(taskType);
            entity.save();
            return entity;
        });
    }

    public DataCleanerScheduleEntity update(Integer id, Integer templateId, String cron, Boolean enabled, Integer taskType) {
        return (DataCleanerScheduleEntity)this.ao.executeInTransaction(() -> {
            DataCleanerScheduleEntity entity = this.getById(id);
            entity.setTemplateId(templateId);
            entity.setCron(cron);
            entity.setEnabled(enabled);
            entity.setTaskType(taskType);
            entity.save();
            return entity;
        });
    }

    public void delete(Integer id) {
        this.ao.executeInTransaction(() -> {
            DataCleanerScheduleEntity entity = this.getById(id);
            this.ao.delete(new RawEntity[]{entity});
            return true;
        });
    }
}

