/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerRuntimeException;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import de.actonic.confluence.gdpr.component.service.UserAnonymizerService;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.stereotype.Component;

@Component
public class UserAnonymizerTaskExecutiveService {
    @ComponentImport
    private final SchedulerService schedulerService;
    private final UserAnonymizerService userAnonymizerService;

    public UserAnonymizerTaskExecutiveService(SchedulerService schedulerService, UserAnonymizerService userAnonymizerService) {
        this.schedulerService = schedulerService;
        this.userAnonymizerService = userAnonymizerService;
    }

    public void executeIfExists(final Map<String, String> configurationMap) {
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"actonic-gdpr-user-anonymizer-job-runner");
        final ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        this.schedulerService.registerJobRunner(jobRunnerKey, new JobRunner(){

            @Nullable
            public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
                UserAnonymizerTaskExecutiveService.this.userAnonymizerService.execute(configurationMap, user);
                return JobRunnerResponse.success();
            }
        });
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.runOnce(null));
        try {
            this.schedulerService.scheduleJobWithGeneratedId(jobConfig).toString();
        }
        catch (SchedulerServiceException sse) {
            throw new SchedulerRuntimeException(sse.getMessage(), (Throwable)sse);
        }
    }
}

