/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.manager;

import de.actonic.confluence.gdpr.component.manager.IChangerManager;
import de.actonic.confluence.gdpr.component.service.anonymizer.content.BasicContentChanger;
import de.actonic.confluence.gdpr.component.service.anonymizer.global.GlobalContentChanger;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserAnonymizerChangerManager
implements IChangerManager {
    private final Map<String, BasicContentChanger> pageChangers;
    private final Map<String, BasicContentChanger> spaceChangers;
    private final Map<String, BasicContentChanger> commonChanger;
    private final Map<String, GlobalContentChanger> globalContentChangers;

    @Autowired
    public UserAnonymizerChangerManager(Set<BasicContentChanger> changers, Set<GlobalContentChanger> globalContentChangers) {
        this.pageChangers = changers.stream().filter(changer -> changer.getChangerGroup().equals("page")).collect(Collectors.toMap(BasicContentChanger::getChangerName, Function.identity()));
        this.spaceChangers = changers.stream().filter(changer -> changer.getChangerGroup().equals("space")).collect(Collectors.toMap(BasicContentChanger::getChangerName, Function.identity()));
        this.commonChanger = changers.stream().filter(changer -> changer.getChangerGroup().contains("common")).collect(Collectors.toMap(BasicContentChanger::getChangerName, Function.identity()));
        this.globalContentChangers = globalContentChangers.stream().collect(Collectors.toMap(GlobalContentChanger::getChangerName, Function.identity()));
    }

    @Override
    public boolean hasPageChanger(String value) {
        return this.pageChangers.containsKey(value);
    }

    @Override
    public BasicContentChanger getPageChanger(String value) {
        return this.pageChangers.get(value);
    }

    @Override
    public boolean hasSpaceChanger(String value) {
        return this.spaceChangers.containsKey(value);
    }

    @Override
    public BasicContentChanger getSpaceChanger(String value) {
        return this.spaceChangers.get(value);
    }

    @Override
    public boolean hasCommonChanger(String value) {
        return this.commonChanger.containsKey(value);
    }

    @Override
    public BasicContentChanger getCommonChanger(String value) {
        return this.commonChanger.get(value);
    }

    @Override
    public boolean hasGlobalChanger(String value) {
        return this.globalContentChangers.containsKey(value);
    }

    @Override
    public GlobalContentChanger getGlobalChanger(String value) {
        return this.globalContentChangers.get(value);
    }
}

