/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.manager;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import de.actonic.confluence.gdpr.ao.AnnouncingEntity;
import de.actonic.confluence.gdpr.ao.AnnouncingHistoryEntity;
import de.actonic.confluence.gdpr.component.manager.AbstractEntityDao;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnnouncingHistoryDao
extends AbstractEntityDao {
    private static final Logger log = LoggerFactory.getLogger(AnnouncingHistoryDao.class);

    @Autowired
    public AnnouncingHistoryDao(@ComponentImport ActiveObjects ao) {
        super(ao);
    }

    public boolean updateEntity(int announcingId, String answer, String user, AnnouncingEntity announcingEntity, String questionnaire, String ip) {
        AnnouncingHistoryEntity[] entities = (AnnouncingHistoryEntity[])this.ao.find(AnnouncingHistoryEntity.class, Query.select().where("ANNOUNCING_ID = ? AND USER = ?", new Object[]{announcingId, user}));
        if (entities.length > 0) {
            AnnouncingHistoryEntity current = entities[0];
            current.setAnswer(answer);
            current.setQuestionnaire(questionnaire);
            current.setIp(ip);
            current.save();
            return true;
        }
        this.createEntity(announcingId, announcingEntity.getName(), user, answer, "", ip);
        return false;
    }

    public List<AnnouncingHistoryEntity> getAllEntities() {
        Object[] entities = (AnnouncingHistoryEntity[])this.ao.find(AnnouncingHistoryEntity.class);
        return Lists.newArrayList((Object[])entities);
    }

    public List<AnnouncingHistoryEntity> getAllEntitiesByUser(String userName) {
        Object[] entities = (AnnouncingHistoryEntity[])this.ao.find(AnnouncingHistoryEntity.class, Query.select().where("USER = ?", new Object[]{userName}));
        return Lists.newArrayList((Object[])entities);
    }

    public List<AnnouncingHistoryEntity> getAllEntitiesByAnnouncingId(int announcingId) {
        Object[] entities = (AnnouncingHistoryEntity[])this.ao.find(AnnouncingHistoryEntity.class, Query.select().where("ANNOUNCING_ID = ?", new Object[]{announcingId}));
        return Lists.newArrayList((Object[])entities);
    }

    public List<AnnouncingHistoryEntity> getAllEntitiesByUserAndAnnouncingId(String userKey, int announcingId) {
        Object[] entities = (AnnouncingHistoryEntity[])this.ao.find(AnnouncingHistoryEntity.class, Query.select().where("USER = ? AND ANNOUNCING_ID = ?", new Object[]{userKey, announcingId}));
        return Lists.newArrayList((Object[])entities);
    }

    public boolean isUserAcceptedAnnouncing(String user, int announcingId) {
        log.debug("Trying to find accepted/declined announcements for id = '" + announcingId + "' and userKey = '" + user + "'");
        Query query = Query.select().where("ANNOUNCING_ID = ? AND USER = ?", new Object[]{announcingId, user});
        Object[] entities = (AnnouncingHistoryEntity[])this.ao.find(AnnouncingHistoryEntity.class, query);
        log.debug("Found " + entities.length + " results");
        return Lists.newArrayList((Object[])entities).size() > 0;
    }

    public int getAcceptedCount(int announcingId) {
        AnnouncingHistoryEntity[] entities = (AnnouncingHistoryEntity[])this.ao.find(AnnouncingHistoryEntity.class, Query.select().where("ANNOUNCING_ID = ? AND ANSWER = ?", new Object[]{announcingId, "accepted"}));
        return entities.length;
    }

    public int getDeclinedCount(int announcingId) {
        AnnouncingHistoryEntity[] entities = (AnnouncingHistoryEntity[])this.ao.find(AnnouncingHistoryEntity.class, Query.select().where("ANNOUNCING_ID = ? AND ANSWER = ?", new Object[]{announcingId, "declined"}));
        return entities.length;
    }

    public String getQueResponse(int announcingId, String userKey) {
        AnnouncingHistoryEntity[] entities = (AnnouncingHistoryEntity[])this.ao.find(AnnouncingHistoryEntity.class, Query.select().where("ANNOUNCING_ID = ? AND USER = ?", new Object[]{announcingId, userKey}));
        return entities.length > 0 ? entities[0].getQuestionnaire() : "";
    }

    public AnnouncingHistoryEntity createEntity(int announcingId, String name, String user, String answer, String questionnaire, String ip) {
        return (AnnouncingHistoryEntity)this.ao.executeInTransaction(() -> {
            AnnouncingHistoryEntity entity = (AnnouncingHistoryEntity)this.ao.create(AnnouncingHistoryEntity.class, new DBParam[0]);
            entity.setAnnouncingId(announcingId);
            entity.setName(name);
            entity.setUser(user);
            entity.setTimeStamp(new Date());
            entity.setAnswer(answer);
            entity.setQuestionnaire(questionnaire);
            entity.setIp(ip);
            entity.save();
            return entity;
        });
    }

    public void clearAnnouncing(int announcingId) {
        AnnouncingHistoryEntity[] entities = (AnnouncingHistoryEntity[])this.ao.find(AnnouncingHistoryEntity.class, Query.select().where("ANNOUNCING_ID = ?", new Object[]{announcingId}));
        this.ao.delete((RawEntity[])entities);
    }

    public boolean updateAnnouncingAnswerByIdAndUser(int announcingId, String answer, String user, String questionnaire) {
        AnnouncingHistoryEntity[] entities = (AnnouncingHistoryEntity[])this.ao.find(AnnouncingHistoryEntity.class, Query.select().where("ANNOUNCING_ID = ? AND USER = ?", new Object[]{announcingId, user}));
        if (entities.length > 0) {
            AnnouncingHistoryEntity current = entities[0];
            current.setTimeStamp(new Date());
            current.setAnswer(answer);
            current.setQuestionnaire(questionnaire);
            current.save();
            return true;
        }
        return false;
    }

    public boolean hasAnswerByIdAndUser(int announcingId, String userKey) {
        AnnouncingHistoryEntity[] announcingHistoryEntities = (AnnouncingHistoryEntity[])this.ao.find(AnnouncingHistoryEntity.class, Query.select().where("ANNOUNCING_ID = ? AND USER = ?", new Object[]{announcingId, userKey}));
        return announcingHistoryEntities.length > 0;
    }

    public String getAnswerByIdAndUser(int announcingId, String user) {
        AnnouncingHistoryEntity[] announcingHistoryEntities = (AnnouncingHistoryEntity[])this.ao.find(AnnouncingHistoryEntity.class, Query.select().where("ANNOUNCING_ID = ? AND USER = ?", new Object[]{announcingId, user}));
        return announcingHistoryEntities.length > 0 ? announcingHistoryEntities[0].getAnswer() : "unknown";
    }
}

