define("actonic-gdpr/core/intro", ["jquery", "actonic-gdpr/core/intro-rest", "gdpr/core/log"], function ($, CoreIntroRest, log) {
    function CoreIntro() {
        var _this = this;
        var initialized = false;
        var stepsArr;

        this.init = function (config) {
            if (config && config.name && (config.steps || config.stepsArr)) {
                if (config.steps && typeof config.steps === "function") config.steps();
                if (config.stepsArr) stepsArr = config.stepsArr;

                var username = AJS.params.remoteUser;
                if (username) {
                    CoreIntroRest.isIntroShowed(config.name, username,
                        function (data) { // success
                            //log.debug("CoreIntroRest.isIntroShowed data = " + JSON.stringify(data));
                            if (!data) {
                                _this.start();
                            }
                        },
                        function (data) { // error
                            log.error("intro.cannot.load.connection.error " + data.responseText);
                        });
                } else {
                    log.error("intro.cannot.load.user.not.found");
                }

                initialized = true;
            }
        };

        this.start = function () {
            if (initialized && introJs) {
                //setIntroSteps();
                var tour = introJs();
                if (stepsArr) {
                    //log.debug("stepsArr");
                    tour.setOption('steps', stepsArr);
                }
                tour.setOption('tooltipPosition', 'auto');
                tour.setOption('positionPrecedence', ['left', 'right', 'bottom', 'top']);

                tour.start();
                //log.debug("tour.start()");
            } else {
                log.error("initialized && introJs = false");
            }
        }
    }

    return new CoreIntro();
});
