/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.newDC.rest;

import de.actonic.gdpr.shared.general.exception.GDPRException;
import de.actonic.gdpr.shared.general.exception.GDPRExceptionHandler;
import de.actonic.gdpr.shared.general.util.GDPRJsonUtils;
import de.actonic.gdpr.shared.general.util.GDPRLogHelper;
import de.actonic.gdpr.shared.newDC.model.task.RequestTaskDCModel;
import de.actonic.gdpr.shared.newDC.model.task.TaskDCModel;
import de.actonic.gdpr.shared.newDC.model.task.TaskDCType;
import de.actonic.gdpr.shared.newDC.service.task.TaskDCService;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/tasks")
@Produces(value={"application/json"})
public class TaskRest {
    private static final Logger log = LoggerFactory.getLogger(TaskRest.class);
    private final TaskDCService taskService;

    public TaskRest(TaskDCService taskService) {
        this.taskService = taskService;
    }

    @POST
    @Path(value="/")
    public Response addTask(RequestTaskDCModel requestTaskModel) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            TaskDCModel task = this.taskService.createTask(requestTaskModel.getTemplateId(), TaskDCType.MANUAL);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)task)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/")
    public Response executionTask() {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            this.taskService.executeIfExists(TaskDCType.MANUAL);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)"task")).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }
}

