/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.announcement.manager;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.google.common.collect.Lists;
import de.actonic.gdpr.announcement.ao.AnnouncementEntity;
import de.actonic.gdpr.announcement.dao.AnnouncementDao;
import de.actonic.gdpr.shared.announcement.manager.IAnnouncementCacheManager;
import de.actonic.gdpr.shared.announcement.manager.IAnnouncementManager;
import de.actonic.gdpr.shared.announcement.model.AnnouncementCheckPermissionModel;
import de.actonic.gdpr.shared.announcement.model.AnnouncementModel;
import de.actonic.gdpr.shared.general.manager.IGDPRUserManager;
import de.actonic.gdpr.shared.general.model.GDPRUserModel;
import de.actonic.gdpr.shared.general.model.GDPRVersionType;
import de.actonic.gdpr.shared.general.util.GDPRJsonUtils;
import de.actonic.gdpr.shared.general.util.GDPRNamingUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Sets;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfluenceIAnnouncementManager
implements IAnnouncementManager {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceIAnnouncementManager.class);
    private static final String ANNOUNCING_EDITOR = "announcing-editor";
    private final AnnouncementDao announcementDao;
    private final IAnnouncementCacheManager announcementCacheManager;
    private final GroupManager groupManager;
    private final SpaceManager spaceManager;
    private final IGDPRUserManager userManager;

    @Autowired
    public ConfluenceIAnnouncementManager(AnnouncementDao announcementDao, IAnnouncementCacheManager announcementCacheManager, GroupManager groupManager, SpaceManager spaceManager, IGDPRUserManager userManager) {
        this.announcementDao = announcementDao;
        this.announcementCacheManager = announcementCacheManager;
        this.groupManager = groupManager;
        this.spaceManager = spaceManager;
        this.userManager = userManager;
        announcementCacheManager.removeAll();
    }

    public AnnouncementModel entityToModel(AnnouncementEntity announcementEntity) {
        Set contributorsKeys = (Set)GDPRJsonUtils.fromJson((String)announcementEntity.getContributors(), (Type)GDPRJsonUtils.HASH_SET_STRING_TYPE);
        Set contributors = contributorsKeys.stream().map(arg_0 -> ((IGDPRUserManager)this.userManager).getUserByKeyOrReturnAnonymousUser(arg_0)).collect(Collectors.toSet());
        return AnnouncementModel.builder().id(announcementEntity.getID()).enabled(Boolean.valueOf(announcementEntity.getIsActive())).startDate(announcementEntity.getStartDate()).endDate(announcementEntity.getEndDate()).name(announcementEntity.getName()).type(announcementEntity.getType()).style(announcementEntity.getStyle()).group(announcementEntity.getGroup()).questionnaire(Boolean.valueOf(announcementEntity.getIsQuestionnaire())).anonymous(Boolean.valueOf(announcementEntity.getIsAnonymous())).windowSize(announcementEntity.getWindowSize()).accept(announcementEntity.getAccept()).decline(announcementEntity.getDecline()).pinned(Boolean.valueOf(announcementEntity.getIsPinned())).creator(announcementEntity.getCreator()).lastModifier(announcementEntity.getLastModifier()).title(announcementEntity.getTitle()).body(announcementEntity.getBody()).creationDate(announcementEntity.getCreationDate()).modificationDate(announcementEntity.getModificationDate()).parentContent(announcementEntity.getSpaces()).showInPeriod(Boolean.valueOf(announcementEntity.getIsShowInPeriod())).version(announcementEntity.getVersion()).announcementType(announcementEntity.getAnnouncementType()).parentId(announcementEntity.getParentId()).comment(announcementEntity.getComment()).contributors(contributors).build();
    }

    private List<AnnouncementModel> entitiesToModels(AnnouncementEntity[] entities) {
        return Arrays.stream(entities).map(this::entityToModel).collect(Collectors.toList());
    }

    public List<AnnouncementModel> getLoginFormEntities() {
        AnnouncementEntity[] entities = this.announcementDao.getLoginFormEntities();
        return Arrays.stream(entities).map(this::entityToModel).collect(Collectors.toList());
    }

    public List<AnnouncementModel> getAllEntities() {
        List<AnnouncementEntity> entities = this.announcementDao.getAllEntities();
        return entities.stream().map(this::entityToModel).collect(Collectors.toList());
    }

    public List<AnnouncementModel> getActiveEntities() {
        List<AnnouncementEntity> entities = this.announcementDao.getActiveEntities();
        return entities.stream().map(this::entityToModel).collect(Collectors.toList());
    }

    public AnnouncementModel createTemplateAnnouncing(int id, String result, String creator) {
        int version = 1;
        String announcementType = GDPRVersionType.CURRENT.getType();
        HashSet contributors = Sets.newHashSet((Object[])new String[]{creator});
        if (id == 2) {
            String name = "Privacy policy";
            List entityNames = Arrays.stream(this.announcementDao.getCurrentAnnouncements()).map(AnnouncementEntity::getName).collect(Collectors.toList());
            String uniqueName = GDPRNamingUtils.generateUniqueName((String)name, entityNames);
            this.announcementCacheManager.removeBulk(new String[]{"window"});
            return this.entityToModel(this.announcementDao.createEntity(Boolean.FALSE, null, null, uniqueName, "optional", "center", creator, new Date(), new Date(), null, "", Boolean.FALSE, Boolean.FALSE, "aui-dialog2-medium", "Accept", "Decline", Boolean.TRUE, "Privacy policy", ANNOUNCING_EDITOR, null, result, "", false, version, announcementType, contributors));
        }
        if (id == 1) {
            String name = "Cookie policy";
            List entityNames = Arrays.stream(this.announcementDao.getCurrentAnnouncements()).map(AnnouncementEntity::getName).collect(Collectors.toList());
            String uniqueName = GDPRNamingUtils.generateUniqueName((String)name, entityNames);
            this.announcementCacheManager.removeBulk(new String[]{"window"});
            return this.entityToModel(this.announcementDao.createEntity(Boolean.FALSE, null, null, uniqueName, "optional", "bottom", creator, new Date(), new Date(), null, "", Boolean.FALSE, Boolean.FALSE, "aui-dialog2-medium", "Accept", "Decline", Boolean.TRUE, "Cookie policy", ANNOUNCING_EDITOR, null, result, "", false, version, announcementType, contributors));
        }
        return null;
    }

    public AnnouncementModel[] getEntitiesByGroup(String groupName) {
        AnnouncementEntity[] announcingEntities = this.announcementDao.getEntitiesByGroup(groupName);
        return (AnnouncementModel[])Arrays.stream(announcingEntities).map(this::entityToModel).toArray(AnnouncementModel[]::new);
    }

    public List<AnnouncementModel> getCurrentNotAnonymousEntitiesByGroups(List<String> groupNames) {
        AnnouncementEntity[] announcingEntities = this.announcementDao.getCurrentNotAnonymousEntitiesByGroups(groupNames);
        return Arrays.stream(announcingEntities).map(this::entityToModel).collect(Collectors.toList());
    }

    public AnnouncementModel[] getEntitiesWithoutGroup() {
        AnnouncementEntity[] announcingEntities = this.announcementDao.getEntitiesWithoutGroup();
        return (AnnouncementModel[])Arrays.stream(announcingEntities).map(this::entityToModel).toArray(AnnouncementModel[]::new);
    }

    public List<AnnouncementModel> getCurrentNotAnonymousEntitiesWithoutGroup() {
        AnnouncementEntity[] announcingEntities = this.announcementDao.getCurrentNotAnonymousEntitiesWithoutGroup();
        return Arrays.stream(announcingEntities).map(this::entityToModel).collect(Collectors.toList());
    }

    public void checkPermission(List<String> spaceKeys, AnnouncementCheckPermissionModel result) {
        if (spaceKeys.isEmpty()) {
            result.getOk().add("User will see announcements in all spaces and other places.");
            return;
        }
        List<Space> spaces = this.getSpacesByKeys(spaceKeys);
        if (spaces.isEmpty()) {
            result.getError().add("User will not see announcement because specified space(s) is not found.");
        } else {
            List spaceName = spaces.stream().map(space -> space.getName() + " (" + space.getKey() + ")").collect(Collectors.toList());
            result.getWarning().add(String.format("User will see announcements only in the next spaces: %s.", StringUtils.join(spaceName, (String)", ")));
        }
    }

    public AnnouncementModel createSimpleEntity(AnnouncementModel announcementModel) {
        AnnouncementEntity entity = this.announcementDao.createSimpleEntity(announcementModel.getAnnouncementType(), announcementModel.getCreator(), announcementModel.getContributors().stream().map(GDPRUserModel::getUserKey).collect(Collectors.toSet()), announcementModel.getVersion(), announcementModel.getEnabled(), announcementModel.getType(), announcementModel.getStyle(), announcementModel.getWindowSize(), announcementModel.getQuestionnaire(), announcementModel.getAnonymous(), announcementModel.getShowInPeriod(), announcementModel.getGroup(), announcementModel.getParentContent());
        return this.entityToModel(entity);
    }

    public AnnouncementModel createDraftAnnouncement(AnnouncementModel announcementModel) {
        AnnouncementEntity entity = this.announcementDao.createAnnouncementDraft(announcementModel.getEnabled(), announcementModel.getStartDate(), announcementModel.getEndDate(), announcementModel.getName(), announcementModel.getType(), announcementModel.getStyle(), announcementModel.getGroup(), announcementModel.getQuestionnaire(), announcementModel.getAnonymous(), announcementModel.getWindowSize(), announcementModel.getAccept(), announcementModel.getDecline(), announcementModel.getPinned(), announcementModel.getCreator(), announcementModel.getTitle(), announcementModel.getBody(), announcementModel.getParentContent(), announcementModel.getShowInPeriod(), announcementModel.getVersion(), announcementModel.getAnnouncementType(), announcementModel.getParentId(), announcementModel.getContributors().stream().map(GDPRUserModel::getUserKey).collect(Collectors.toSet()));
        return this.entityToModel(entity);
    }

    public AnnouncementModel getDraftAnnouncement(int id) {
        AnnouncementEntity[] entities = this.announcementDao.getDraftAnnouncement(id);
        if (entities == null || entities.length == 0) {
            return null;
        }
        return this.entityToModel(entities[0]);
    }

    public List<AnnouncementModel> getChildrenAnnouncement(int id) {
        return this.entitiesToModels(this.announcementDao.getChildrenAnnouncement(id));
    }

    public List<AnnouncementModel> getAnnouncementsByTypes(String ... types) {
        return this.entitiesToModels(this.announcementDao.getAnnouncementsByTypes(Lists.newArrayList((Object[])types)));
    }

    public AnnouncementModel getById(int id) {
        AnnouncementEntity announcingEntity = this.announcementDao.getById(id);
        if (announcingEntity == null) {
            return null;
        }
        return this.entityToModel(announcingEntity);
    }

    public void deleteAllByParentId(int parentId) {
        this.announcementDao.deleteAllByParentId(parentId);
    }

    public AnnouncementModel updateEntity(AnnouncementModel announcementModel, boolean isFullUpdate) {
        AnnouncementEntity entity = this.announcementDao.updateEntity(isFullUpdate, announcementModel.getId(), announcementModel.getEnabled(), announcementModel.getStartDate(), announcementModel.getEndDate(), announcementModel.getName(), announcementModel.getType(), announcementModel.getStyle(), announcementModel.getGroup(), announcementModel.getQuestionnaire(), announcementModel.getAnonymous(), announcementModel.getWindowSize(), announcementModel.getAccept(), announcementModel.getDecline(), announcementModel.getPinned(), announcementModel.getCreator(), announcementModel.getCreationDate(), announcementModel.getLastModifier(), announcementModel.getTitle(), announcementModel.getBody(), announcementModel.getParentContent(), announcementModel.getShowInPeriod(), announcementModel.getVersion(), announcementModel.getAnnouncementType(), announcementModel.getParentId(), announcementModel.getContributors() != null ? announcementModel.getContributors().stream().map(GDPRUserModel::getUserKey).collect(Collectors.toSet()) : null, announcementModel.getComment());
        return this.entityToModel(entity);
    }

    public AnnouncementModel updateContributors(int id, Set<String> contributors) {
        return this.entityToModel(this.announcementDao.updateContributors(id, contributors));
    }

    public List<AnnouncementModel> getPinnedEntities() {
        List<AnnouncementEntity> announcingEntities = this.announcementDao.getPinnedEntities();
        return announcingEntities.stream().map(this::entityToModel).collect(Collectors.toList());
    }

    public void deleteEntity(int id) {
        this.announcementDao.deleteEntity(id);
    }

    public List<AnnouncementModel> getNotAnonymousCurrentPinnedEntities() {
        return this.entitiesToModels(this.announcementDao.getNotAnonymousCurrentPinnedEntities());
    }

    public List<AnnouncementModel> getAnonymousCurrentPinnedEntities() {
        AnnouncementEntity[] anonymousCurrentPinnedEntities = this.announcementDao.getAnonymousCurrentPinnedEntities();
        return this.entitiesToModels(anonymousCurrentPinnedEntities);
    }

    public List<AnnouncementModel> getCurrentLoginFormEntities() {
        return this.entitiesToModels(this.announcementDao.getCurrentLoginFormEntities());
    }

    public AnnouncementModel updateStatus(int id, boolean isActive) {
        AnnouncementEntity entity = this.announcementDao.updateStatus(id, isActive);
        return this.entityToModel(entity);
    }

    public AnnouncementModel restoreAnnouncement(AnnouncementModel announcement) {
        return this.entityToModel(this.announcementDao.updateEntity(announcement.getId(), announcement.getAnnouncementType(), announcement.getLastModifier(), announcement.getName()));
    }

    public List<AnnouncementModel> getFilteredAnnouncements(String name, boolean isFullMatchByName, List<String> types, Boolean isEnable, List<String> spaceKeys, List<String> groupNames, String style, String lastModifier, Date fromDate, Date toDate, String orderBy, String ... announcementTypes) {
        List<AnnouncementModel> announcements = this.entitiesToModels(this.announcementDao.getFilteredAnnouncements(name, isFullMatchByName, types, isEnable, style, lastModifier, Lists.newArrayList((Object[])announcementTypes), fromDate, toDate));
        announcements = this.filteredBySpaces(spaceKeys, announcements);
        announcements = this.filteredByGroups(groupNames, announcements);
        return announcements.stream().distinct().collect(Collectors.toList());
    }

    private List<AnnouncementModel> filteredBySpaces(List<String> projectKeys, List<AnnouncementModel> announcements) {
        List<Space> spaces = this.getSpacesByKeys(projectKeys);
        ArrayList result = new ArrayList();
        for (Space space : spaces) {
            result.addAll(announcements.stream().filter(announcement -> {
                ArrayList c = StringUtils.isNotBlank((CharSequence)announcement.getParentContent()) ? Lists.newArrayList((Object[])announcement.getParentContent().split(",")) : Lists.newArrayList();
                return c.isEmpty() || c.stream().anyMatch(name -> StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)space.getKey()));
            }).collect(Collectors.toList()));
        }
        return projectKeys.isEmpty() ? announcements : result.stream().sorted(Comparator.comparing(AnnouncementModel::getParentContent, Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.toList());
    }

    private List<AnnouncementModel> filteredByGroups(List<String> groupNames, List<AnnouncementModel> announcements) {
        ArrayList<AnnouncementModel> result = new ArrayList<AnnouncementModel>();
        for (String groupName : groupNames) {
            for (AnnouncementModel announcement : announcements) {
                ArrayList groups;
                boolean isAnonymous = false;
                boolean isLogged = false;
                if (announcement.getAnonymous() & !groupNames.contains("#anyAnonymous")) continue;
                if (groupNames.contains("#anyAnonymous")) {
                    isAnonymous = announcement.getAnonymous();
                }
                if (groupNames.contains("#anyLogged")) {
                    boolean bl = isLogged = announcement.getAnonymous() == false;
                }
                if (isLogged || isAnonymous) {
                    result.add(announcement);
                    continue;
                }
                Group group = null;
                try {
                    group = this.groupManager.getGroup(groupName);
                }
                catch (EntityException e) {
                    log.info("Group " + groupName + " not found");
                }
                if (group == null) continue;
                ArrayList arrayList = groups = StringUtils.isNotBlank((CharSequence)announcement.getGroup()) ? Lists.newArrayList((Object[])announcement.getGroup().split(",")) : Lists.newArrayList();
                if (groups.isEmpty()) {
                    result.add(announcement);
                    continue;
                }
                if (!groups.contains(group.getName())) continue;
                result.add(announcement);
            }
        }
        return groupNames.isEmpty() ? announcements : result.stream().sorted(Comparator.comparing(AnnouncementModel::getGroup, Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.toList());
    }

    private List<Space> getSpacesByKeys(List<String> spaceKeys) {
        return spaceKeys.stream().map(arg_0 -> ((SpaceManager)this.spaceManager).getSpace(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<AnnouncementModel> entitiesToModels(List<AnnouncementEntity> entities) {
        return entities.stream().map(this::entityToModel).collect(Collectors.toList());
    }

    public List<AnnouncementModel> getByIds(List<Integer> ids) {
        return this.entitiesToModels(this.announcementDao.getByIds(ids));
    }

    public List<AnnouncementModel> getAnnouncementsByName(String name) {
        return this.entitiesToModels(this.announcementDao.getAnnouncementsByName(name));
    }

    public List<AnnouncementModel> getNotAnonymousCurrentWindowAnnouncements() {
        return this.entitiesToModels(this.announcementDao.getNotAnonymousCurrentWindowAnnouncements());
    }

    public List<AnnouncementModel> getAnonymousCurrentWindowAnnouncements() {
        return this.entitiesToModels(this.announcementDao.getAnonymousCurrentWindowAnnouncements());
    }

    public List<AnnouncementModel> getCurrentAnnouncements() {
        return this.entitiesToModels(this.announcementDao.getCurrentAnnouncements());
    }

    public AnnouncementModel getCurrentAnnouncementById(int id) {
        Optional<AnnouncementEntity> announcingEntity = Arrays.stream(this.announcementDao.getCurrentAnnouncements()).filter(ann -> id == ann.getID()).findFirst();
        return announcingEntity.map(this::entityToModel).orElse(null);
    }

    public List<AnnouncementModel> getTrashAnnouncements() {
        return this.entitiesToModels(this.announcementDao.getTrashAnnouncements());
    }

    public Integer getActiveLoginFormAnnouncementsSize() {
        return this.announcementDao.getCurrentLoginFormAnnouncements().length;
    }

    public AnnouncementModel createEntity(AnnouncementModel announcementModel, Set<String> contributors) {
        return this.entityToModel(this.announcementDao.createEntity(announcementModel.getEnabled() == null ? Boolean.FALSE : announcementModel.getEnabled(), announcementModel.getStartDate(), announcementModel.getEndDate(), announcementModel.getName(), announcementModel.getType() == null ? "optional" : announcementModel.getType(), announcementModel.getStyle() == null ? "bottom" : announcementModel.getStyle(), announcementModel.getCreator(), new Date(), new Date(), announcementModel.getCreator(), announcementModel.getGroup() == null ? "" : announcementModel.getGroup(), announcementModel.getQuestionnaire() == null ? Boolean.FALSE : announcementModel.getQuestionnaire(), announcementModel.getAnonymous() == null ? Boolean.FALSE : announcementModel.getAnonymous(), announcementModel.getWindowSize() == null ? "medium" : announcementModel.getWindowSize(), announcementModel.getAccept() == null ? "Accept" : announcementModel.getAccept(), announcementModel.getDecline() == null ? "Decline" : announcementModel.getDecline(), announcementModel.getPinned() == null ? Boolean.TRUE : announcementModel.getPinned(), announcementModel.getTitle() == null ? "Title" : announcementModel.getTitle(), ANNOUNCING_EDITOR, null, announcementModel.getBody() == null ? "Body" : announcementModel.getBody(), announcementModel.getParentContent() == null ? "" : announcementModel.getParentContent(), announcementModel.getShowInPeriod() == null ? false : announcementModel.getShowInPeriod(), 1, GDPRVersionType.CURRENT.getType(), contributors));
    }
}

