/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.rest;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import de.actonic.confluence.gdpr.component.manager.UserNameConvertManager;
import de.actonic.confluence.gdpr.component.service.AccessStatisticsService;
import de.actonic.confluence.gdpr.model.ListPaginationModel;
import de.actonic.gdpr.general.manager.GDPRSettingsManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/access-statistics")
@Produces(value={"application/json"})
public class AccessStatisticsRest {
    private final AccessStatisticsService accessStatisticsService;
    private final GDPRSettingsManager GDPRSettingsManager;
    private final UserNameConvertManager userNameConvertManager;

    @Autowired
    public AccessStatisticsRest(AccessStatisticsService accessStatisticsService, GDPRSettingsManager GDPRSettingsManager2, UserNameConvertManager userNameConvertManager) {
        this.accessStatisticsService = accessStatisticsService;
        this.GDPRSettingsManager = GDPRSettingsManager2;
        this.userNameConvertManager = userNameConvertManager;
    }

    @PUT
    @Path(value="/")
    public Response addViewEvent(@Context HttpServletRequest httpServletRequest, @FormParam(value="pageId") Long pageId) {
        ConfluenceUser applicationUser;
        String remoteIpAddress = httpServletRequest.getHeader("X-FORWARDED-FOR");
        if (Strings.isNullOrEmpty((String)remoteIpAddress)) {
            remoteIpAddress = httpServletRequest.getHeader("x-forwarded-for");
        }
        if (Strings.isNullOrEmpty((String)remoteIpAddress)) {
            remoteIpAddress = httpServletRequest.getRemoteAddr();
        }
        String userName = (applicationUser = AuthenticatedUserThreadLocal.get()) == null ? "[anonymous]" : applicationUser.getName();
        String userKey = this.userNameConvertManager.convertUserNameToUserKey(userName);
        this.accessStatisticsService.addAccessStatisticsEntity(userKey, remoteIpAddress, pageId, "browser");
        return Response.ok().build();
    }

    @POST
    @Path(value="/")
    public Response filterEvents(@FormParam(value="page") Integer page, @FormParam(value="userName") String userName, @FormParam(value="pageId") String pageId, @FormParam(value="spaceKey") String spaceKey, @FormParam(value="fromDate") Long fromDate, @FormParam(value="toDate") Long toDate, @FormParam(value="orderBy") String orderBy) {
        String userKey = this.userNameConvertManager.convertUserNameToUserKey(userName);
        ListPaginationModel listPaginationModel = this.accessStatisticsService.filter(userKey, spaceKey, pageId, fromDate, toDate, orderBy, page, this.GDPRSettingsManager.getRowsPerPage());
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("items", listPaginationModel.getObjList());
        resultMap.put("totalPages", listPaginationModel.getTotalPages());
        resultMap.put("page", listPaginationModel.getCurrentPageNum());
        return Response.ok().entity((Object)new Gson().toJson(resultMap)).build();
    }

    @GET
    @Path(value="/get-all")
    @Produces(value={"text/plain"})
    public Response getAll(@QueryParam(value="page") Integer page, @QueryParam(value="userName") String userName, @QueryParam(value="pageId") String pageId, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="fromDate") Long fromDate, @QueryParam(value="toDate") Long toDate, @QueryParam(value="orderBy") String orderBy) {
        String userKey = this.userNameConvertManager.convertUserNameToUserKey(userName);
        ListPaginationModel listPaginationModel = this.accessStatisticsService.filter(userKey, spaceKey, pageId, fromDate, toDate, orderBy, null, this.GDPRSettingsManager.getRowsPerPage());
        int currentPage = listPaginationModel.getCurrentPageNum();
        int totalPages = listPaginationModel.getTotalPages();
        String fileName = "access-statistics";
        try {
            File file = File.createTempFile(fileName, "csv");
            CSVFormat csvFileFormat = CSVFormat.EXCEL.withHeader(new String[]{"Date", "Space", "Page", "User", "IP Address", "Type"});
            FileWriter fileWriter = new FileWriter(file);
            CSVPrinter csvFilePrinter = new CSVPrinter((Appendable)fileWriter, csvFileFormat);
            Pattern p = Pattern.compile("(<([^>]+)>)");
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
            while (currentPage <= totalPages) {
                List accessStatisticsModelList = listPaginationModel.getObjList();
                accessStatisticsModelList.forEach(accessModel -> {
                    try {
                        csvFilePrinter.printRecord(new Object[]{formatter.format(accessModel.getTimeStamp()), p.matcher(accessModel.getSpace()).replaceAll(""), p.matcher(accessModel.getPage()).replaceAll(""), p.matcher(accessModel.getUserName()).replaceAll(""), accessModel.getIpAddress(), accessModel.getType()});
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
                listPaginationModel = this.accessStatisticsService.filter(userKey, spaceKey, pageId, fromDate, toDate, orderBy, ++currentPage, this.GDPRSettingsManager.getRowsPerPage());
            }
            fileWriter.flush();
            fileWriter.close();
            csvFilePrinter.close();
            Response.ResponseBuilder response = Response.ok((Object)file);
            response.header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + ".csv\""));
            return response.build();
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.ok().entity((Object)new Gson().toJson((Object)e.getMessage())).build();
        }
    }
}

