/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.manager;

import com.google.common.collect.Lists;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerBuiltInRuleModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class DataCleanerBuiltInRuleManager {
    public List<DataCleanerBuiltInRuleModel> getAllBuiltInRulesAsText() {
        ArrayList builtInRuleModels = Lists.newArrayList();
        builtInRuleModels.addAll(this.getPhoneNumbers());
        builtInRuleModels.addAll(this.getSSN());
        builtInRuleModels.addAll(this.getOther());
        return builtInRuleModels;
    }

    public Optional<DataCleanerBuiltInRuleModel> getBuiltInRuleById(String id) {
        List<DataCleanerBuiltInRuleModel> builtInRuleModels = this.getAllBuiltInRulesAsText();
        return builtInRuleModels.stream().filter(rule -> Objects.equals(id, rule.getId())).findFirst();
    }

    private List<DataCleanerBuiltInRuleModel> getPhoneNumbers() {
        return Lists.newArrayList((Object[])new DataCleanerBuiltInRuleModel[]{new DataCleanerBuiltInRuleModel("phone-1", "Standard international phone numbers", "Examples: +491739341284, +44 8984 1234 (UK), +61-234-567-89-01", "\\+(9[976]\\d|8[987530]\\d|6[987]\\d|5[90]\\d|42\\d|3[875]\\d|2[98654321]\\d|9[8543210]|8[6421]|6[6543210]|5[87654321]|4[987654310]|3[9643210]|2[70]|7|1)\\d{1,14}", "##########", Lists.newArrayList((Object[])new String[]{"phone"})), new DataCleanerBuiltInRuleModel("phone-2", "German phone numbers", "Examples: +491739341284, +49 1739341284, (+49) 1739341284, +49 17 39 34 12 84, +49 (1739) 34 12 84, +(49) (1739) 34 12 84, +49 (1739) 34-12-84", "\\(?\\+\\(?49\\)?[ ()]?([- ()]?\\d[- ()]?){10}", "###-###-####", Lists.newArrayList((Object[])new String[]{"phone", "de", "Germany"})), new DataCleanerBuiltInRuleModel("phone-3", "Austrian phone numbers", "Examples: 0664-1234567, 06641234567, 0699-12345678", "\\b([+43][ -])?0(6[045679][0469]){1}(\\-)?(1)?[^0\\D]{1}\\d{6}\\b", "###-###-####", Lists.newArrayList((Object[])new String[]{"phone", "at", "Austria"})), new DataCleanerBuiltInRuleModel("phone-4", "Belgian phone numbers", "Examples: +32 460 43 43 43, +32 43 43 43 081 43", "(\\+32[.\\- ]{0,1})?([0-9]{2}[.\\- ]{0,1}){3}[0-9]{3}[.\\- ]{0,1}[0-9]{2}|((\\+|00)32\\s?|0)4(60|[789]\\d)(\\s?\\d{2}){3}", "###-###-####", Lists.newArrayList((Object[])new String[]{"phone", "be", "Belgium"})), new DataCleanerBuiltInRuleModel("phone-5", "Bulgarian phone numbers", "Examples: +359 87891234567, 0 878 91234567", "(\\+359|0)\\s?8(\\d{2}\\s\\d{3}\\d{3}|[789]\\d{7})", "###-###-####", Lists.newArrayList((Object[])new String[]{"phone", "bg", "Bulgaria"})), new DataCleanerBuiltInRuleModel("phone-6", "Croatian phone numbers", "Examples: 01/4444-555, 01/44-55-66, 042/333-999, 0800/556677, 1234567", "((\\d{2,4})\\/)?((\\d{6,8})|(\\d{2})-(\\d{2})-(\\d{2,4})|(\\d{3,4})-(\\d{3,4}))", "+43-####-#######", Lists.newArrayList((Object[])new String[]{"phone", "hr", "Croatia"})), new DataCleanerBuiltInRuleModel("phone-7", "Czech phone numbers", "Examples:+420 0500 000 000, 0500 000 000, 05/10 000 000, +420 602 123 123", "(\\+420)?\\s?((05(\\/)?|5)[\\d]{2}|602)\\s[\\d]{3}\\s[\\d]{3}", "+420 ### ### ###", Lists.newArrayList((Object[])new String[]{"phone", "cz", "Czech"})), new DataCleanerBuiltInRuleModel("phone-8", "Finnish phone numbers", "Examples: 003589999999, 00 358 999 999, 00 358 9999 999, 00 358 999 9999, 091212, 09 99 99 99", "((([\\+][\\s]{0,1})|([0]{2}[\\s-]{0,1}))([358]{3})([\\s-]{0,1})|([0]{1}))(([1-9]{1}[0-9]{0,1})([\\s-]{0,1})([0-9]{2,4})([\\s-]{0,1})([0-9]{2,4})([\\s-]{0,1}))([0-9]{0,3}){1}", "################", Lists.newArrayList((Object[])new String[]{"phone", "fi", "Finland"})), new DataCleanerBuiltInRuleModel("phone-9", "French phone numbers", "Examples: 01 46 70 89 12, 01-46-70-89-12, 0146708912", "0[1-6]{1}(([0-9]{2}){4})|((\\s[0-9]{2}){4})|((-[0-9]{2}){4})", "+## ## ## ## ## ##", Lists.newArrayList((Object[])new String[]{"phone", "fr", "France"})), new DataCleanerBuiltInRuleModel("phone-10", "Irish phone numbers", "Examples: +353(0) 5 444 3333", "\\+353\\(0\\)\\s\\d\\s\\d{3}\\s\\d{4}", "+###(#) # ### ####", Lists.newArrayList((Object[])new String[]{"phone", "ie", "Ireland"})), new DataCleanerBuiltInRuleModel("phone-11", "Italian phone numbers", "Examples: 3491234567, 393491234567, 00393491234567, (+39)3491234567, (0039)3491234567", "(\\((00|\\+)39\\)|(00|\\+)39)?(38[890]|34[7-90]|36[680]|33[3-90]|32[89])\\d{7}", "#############", Lists.newArrayList((Object[])new String[]{"phone", "it", "Italy"})), new DataCleanerBuiltInRuleModel("phone-12", "Dutch phone numbers", "Examples: 0101234567, 010-1234567, 010 - 123 45 67, +31101234567, 0031101234567", "((\\+|00(\\s|\\s?\\-\\s?)?)31(\\s|\\s?\\-\\s?)?(\\(0\\)[\\-\\s]?)?|0)[1-9]((\\s|\\s?\\-\\s?)?[0-9])((\\s|\\s?-\\s?)?[0-9])((\\s|\\s?-\\s?)?[0-9])\\s?[0-9]\\s?[0-9]\\s?[0-9]\\s?[0-9]\\s?[0-9]", "##########", Lists.newArrayList((Object[])new String[]{"phone", "nl", "Netherlands"})), new DataCleanerBuiltInRuleModel("phone-13", "Polish phone numbers", "Examples: +48 500-080-100, 500080100, 500 080 100", "(\\+48\\s+)?\\d{3}(\\s*|\\-)\\d{3}(\\s*|\\-)\\d{3}", "### ### ### ###", Lists.newArrayList((Object[])new String[]{"phone", "pl", "Poland"})), new DataCleanerBuiltInRuleModel("phone-14", "Portugese phone numbers", "Examples: 217896545, +351214563214, 917894125, 00351917896352", "((\\+351|00351|351)?)(2\\d{1}|(9(3|6|2|1)))\\d{7}", "#########", Lists.newArrayList((Object[])new String[]{"phone", "pt", "Portugal"})), new DataCleanerBuiltInRuleModel("phone-15", "Slovakian phone numbers", "Examples: +421 0955 12 34 56, 0955 12 34 56, 0955 123 456, 0955 123456", "(\\+421\\s)?(([0]{0,1})([1-9]{1})([0-9]{2})){1}([\\ ]{0,1})((([0-9]{3})([\\ ]{0,1})([0-9]{3}))|(([0-9]{2})([\\ ]{0,1})([0-9]{2})([\\ ]{0,1})([0-9]{2})))", "### ### ### ###", Lists.newArrayList((Object[])new String[]{"phone", "sk", "Slovakia"})), new DataCleanerBuiltInRuleModel("phone-16", "Slovenian phone numbers", "Examples: 031-123-456, 031/123/456, +386 31 123 456, +38631 123 456", "(([0-9]{3})[ \\-\\/]?([0-9]{3})[ \\-\\/]?([0-9]{3}))|([0-9]{9})|([\\+]?([0-9]{3})[ \\-\\/]?([0-9]{2})[ \\-\\/]?([0-9]{3})[ \\-\\/]?([0-9]{3}))", "###########", Lists.newArrayList((Object[])new String[]{"phone", "si", "Slovenia"})), new DataCleanerBuiltInRuleModel("phone-17", "Spanish phone numbers", "Examples: 952 566 009, +34 615 977 911, 967 90 23 44", "(([+]?34) ?)?(6(([0-9]{8})|([0-9]{2} [0-9]{6})|([0-9]{2} [0-9]{3} [0-9]{3}))|9(([0-9]{8})|([0-9]{2} [0-9]{6})|([1-9] [0-9]{7})|([0-9]{2} [0-9]{3} [0-9]{3})|([0-9]{2} [0-9]{2} [0-9]{2} [0-9]{2})))", "###########", Lists.newArrayList((Object[])new String[]{"phone", "es", "Spain"})), new DataCleanerBuiltInRuleModel("phone-18", "Swedish phone numbers", "Examples: +46 8 123 456 78, 08-123 456 78, 0123-456 78", "(([+]\\d{2}[ ][1-9]\\d{0,2}[ ])|([0]\\d{1,3}[-]))((\\d{2}([ ]\\d{2}){2})|(\\d{3}([ ]\\d{3})*([ ]\\d{2})+))", "###########", Lists.newArrayList((Object[])new String[]{"phone", "se", "Sweden"})), new DataCleanerBuiltInRuleModel("phone-19", "British phone numbers", "Examples: +44 (0) 7513 438167, +44 (0) 7513438167, 07513 438167, 07513438167", "((\\+44(\\s\\(0\\)\\s|\\s0\\s|\\s)?)|0)7\\d{3}(\\s)?\\d{6}", "## # #### ######", Lists.newArrayList((Object[])new String[]{"phone", "uk", "United Kingdom"}))});
    }

    private List<DataCleanerBuiltInRuleModel> getSSN() {
        return Lists.newArrayList((Object[])new DataCleanerBuiltInRuleModel[]{new DataCleanerBuiltInRuleModel("ssn-1", "German Personenkennziffer (Bundeswehr)", "Example: 261083-C-20917", "[0-9]{2}[0,1][0-9][0-9]{2}-[A-Z]-[0-9]{5}", "######-#-#####", Lists.newArrayList((Object[])new String[]{"ssn", "de", "Germany"})), new DataCleanerBuiltInRuleModel("ssn-2", "German Steuer-Identifikationsnummer", "Example: 316/5756/0463", "[0-9]{3}/?[0-9]{4}/?[0-9]{4}", "######-#-#####", Lists.newArrayList((Object[])new String[]{"ssn", "de", "Germany"})), new DataCleanerBuiltInRuleModel("ssn-3", "German Versicherungsnummer, Rentenversicherungsnummer", "Example: 65170839J003", "[0-9]{2}[0-9]{2}[0,1][0-9][0-9]{2}[A-Z][0-9]{2}[0-9]", "######-#-#####", Lists.newArrayList((Object[])new String[]{"ssn", "de", "Germany"})), new DataCleanerBuiltInRuleModel("ssn-4", "Austrian National Identification Number (ZMR-Zahl)", "Zentrales Melderegister (Central Register of Residents - CRR). Example: 000247681888", "[0-9]{12}", "############", Lists.newArrayList((Object[])new String[]{"ssn", "at", "Austria"})), new DataCleanerBuiltInRuleModel("ssn-5", "Austrian Social Insurance Number", "ASVG. Example: 1234030869", "[0-9]{10}", "############", Lists.newArrayList((Object[])new String[]{"ssn", "at", "Austria"})), new DataCleanerBuiltInRuleModel("ssn-6", "Austrian new National Identification Number", "Example: MDEyMzQ1Njc4OWFiY2RlZg==", "[A-Za-z0-9+/]{22}[A-Za-z0-9+/=][A-Za-z0-9+/=]", "############", Lists.newArrayList((Object[])new String[]{"ssn", "at", "Austria"})), new DataCleanerBuiltInRuleModel("ssn-7", "Belgium Identification Number of the National Register", "Example: 70.01.16-287.31", "[0-9]{2}\\.?[0-9]{2}\\.?[0-9]{2}-[0-9]{3}\\.?[0-9]{2}", "##.##.##.##.##", Lists.newArrayList((Object[])new String[]{"ssn", "be", "Belgium"})), new DataCleanerBuiltInRuleModel("ssn-8", "Bulgarian Uniform Civil Number (Bulgarian identity card)", "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd (abbreviated: \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd, EGN). Example: 7608010133", "[0-9]{2}[0,1,2,4][0-9][0-9]{2}[0-9]{4}", "############", Lists.newArrayList((Object[])new String[]{"ssn", "bg", "Bulgaria"})), new DataCleanerBuiltInRuleModel("ssn-9", "Czech Birth Number", "Rodn\ufffd\ufffd \ufffd\ufffd\ufffd\ufffdslo. Example: 685229/4449", "[0-9]{2}[0,1,5][0-9][0-9]{2}\\/?[0-9]{4}", "#######/####", Lists.newArrayList((Object[])new String[]{"ssn", "cz", "Czech"})), new DataCleanerBuiltInRuleModel("ssn-10", "Czech Citizen's Identification Card Number", "Czech: 'Ob\ufffd\ufffdansk\ufffd\ufffd pr\ufffd\ufffdkaz', citizen card, literally civic certificate. Example: AA123456", "[A-Z]{2}[0-9]{6}", "############", Lists.newArrayList((Object[])new String[]{"ssn", "cz", "Czech"})), new DataCleanerBuiltInRuleModel("ssn-11", "Danish Personal Identification Number", "Et CPR-nummer eller personnummer (eng. civil registration number). Example: 020955-2017", "[0-9]{2}[0,1][0-9][0-9]{2}-[0-9]{4}", "######-####", Lists.newArrayList((Object[])new String[]{"ssn", "dk", "Denmark"})), new DataCleanerBuiltInRuleModel("ssn-12", "Estonian Personal code", "Isikukood. Example: 47111119876", "[1-6][0-9]{2}[1,2][0-9][0-9]{2}[0-9]{4}", "############", Lists.newArrayList((Object[])new String[]{"ssn", "ee", "Estonia"})), new DataCleanerBuiltInRuleModel("ssn-14", "Finnish National Identification Number", "Henkil\ufffd\ufffdtunnus. Example: 101052-719Ez", "[0-9]{2}\\.?[0,1][0-9]\\.?[0-9]{2}[-+A][0-9]{3}[A-Z]", "############", Lists.newArrayList((Object[])new String[]{"ssn", "fi", "Finland"})), new DataCleanerBuiltInRuleModel("ssn-15", "French INSEE code. Social Security Number", "INSEE. Example: 1 51 02 46102 043 25", "[1,2][ ]?[0-9]{2}[ ]?[0,1,2,3,5][0-9][ ]?[0-9A-Z]{5}[ ]?[0-9]{3}[ ]?[0-9]{2}", "############", Lists.newArrayList((Object[])new String[]{"ssn", "fr", "France"})), new DataCleanerBuiltInRuleModel("ssn-16", "Greek Tautotita", "Example: P 000007", "[A-Z][ -]?[0-9]{6}", "############", Lists.newArrayList((Object[])new String[]{"ssn", "gr", "Greece"})), new DataCleanerBuiltInRuleModel("ssn-17", "Hungarian Social Insurance Number ", "TAJ sz\ufffd\ufffdm. Example: 123 456 789", "[0-9]{3}[ ]?[0-9]{3}[ ]?[0-9]{3}", "############", Lists.newArrayList((Object[])new String[]{"ssn", "hu", "Hungary"})), new DataCleanerBuiltInRuleModel("ssn-18", "Hungarian Personal Identfication Number", "Szem\ufffd\ufffdlyi sz\ufffd\ufffdm. Example: 1 651105 6666", "[1-8][ ]?[0-9]{2}[0,1][0-9][0-9]{2}[ ]?[0-9]{4}", "############", Lists.newArrayList((Object[])new String[]{"ssn", "hu", "Hungary"})), new DataCleanerBuiltInRuleModel("ssn-19", "Irish Personal Public Service Number", "PPS. Examples: 1234567A, 1234567FW", "[0-9]{7}[A-Z]W?", "############", Lists.newArrayList((Object[])new String[]{"ssn", "ie", "Ireland"})), new DataCleanerBuiltInRuleModel("ssn-20", "Italian Codice Fiscale", "CF. Example: PLDTLL47S04L424T", "[A-Z]{6}[0-9]{2}[A-E,H,L,M,P,R-T][0-9]{2}[A-Z0-9]{5}", "############", Lists.newArrayList((Object[])new String[]{"ssn", "it", "Italy"})), new DataCleanerBuiltInRuleModel("ssn-21", "Latvian Personal code", "Personas kodas. Example: 161171-22345", "[0-9]{2}[0,1][0-9][0-9]-[0-9]{5}", "############", Lists.newArrayList((Object[])new String[]{"ssn", "lv", "Latvia"})), new DataCleanerBuiltInRuleModel("ssn-22", "Lithuanian Personal code", "Asmens kodas. Example: 45911231023", "[3-6][0-9]{2}[0,1][0-9][0-9]{2}[0-9]{4}", "############", Lists.newArrayList((Object[])new String[]{"ssn", "lt", "Lithuania"})), new DataCleanerBuiltInRuleModel("ssn-23", "Dutch Citizen's Service Number", "Burgerservicenummer, sofinummer. Example: 987654321", "[0-9]{9}", "############", Lists.newArrayList((Object[])new String[]{"ssn", "nl", "Netherlands"})), new DataCleanerBuiltInRuleModel("ssn-24", "Norwegian F\ufffd\ufffddselsnummer", "FN. Example: 010168 46647", "[0-9]{2}[0,1][0-9][0-9]{2}[ ]?[0-9]{5}", "############", Lists.newArrayList((Object[])new String[]{"ssn", "no", "Norway"})), new DataCleanerBuiltInRuleModel("ssn-25", "Polish National Identification Number (PESEL)", "Example: 44051401458", "[0-9]{4}[0-3]{1}[0-9]{1}[0-9]{5}", "############", Lists.newArrayList((Object[])new String[]{"ssn", "pl", "Poland"})), new DataCleanerBuiltInRuleModel("ssn-26", "Romanian Nr personal", "CNF. Example: 2121212121218", "[1-8][0-9]{2}[0,1][0-9][0-9]{2}[0-9]{6}", "############", Lists.newArrayList((Object[])new String[]{"ssn", "ro", "Romania"})), new DataCleanerBuiltInRuleModel("ssn-27", "Spain Documento Nacional de Identidad", "DNI. Example: 99999999-R", "[0-9,X,M,L,K,Y][0-9]{7}[-][A-Z]", "############", Lists.newArrayList((Object[])new String[]{"ssn", "es", "Spain"})), new DataCleanerBuiltInRuleModel("ssn-28", "Sweden Personal id number", "Personnr. Example: 610321-3499", "[0-9]{2}[0-1][0-9][0-9]{2}[-+][0-9]{4}", "############", Lists.newArrayList((Object[])new String[]{"ssn", "se", "Sweden"})), new DataCleanerBuiltInRuleModel("ssn-29", "Swiss Old AVS format with personal data encoded", "AVS. Example: 324.65.242.000", "[0-9]{3}\\.?[0-9]{2}\\.?[0-9]{3}\\.?[0-9]{3}", "############", Lists.newArrayList((Object[])new String[]{"ssn", "ch", "Switzerland"})), new DataCleanerBuiltInRuleModel("ssn-30", "Swiss New AVS format", "16 digits with constant prefix 756, which is ISO 3166-1 country code. Example: 756.5152.7017.84", "756\\.?[0-9]{4}\\.?[0-9]{4}\\.?[0-9]{2}", "############", Lists.newArrayList((Object[])new String[]{"ssn", "ch", "Switzerland"})), new DataCleanerBuiltInRuleModel("ssn-31", "British National identification number", "Example: JG103759A", "[A-CEGHJ-PR-TW-Z][A-CEGHJ-NPR-TW-Z]{1}[0-9]{6}[A-DFM]?", "############", Lists.newArrayList((Object[])new String[]{"ssn", "uk", "United Kingdom"})), new DataCleanerBuiltInRuleModel("ssn-32", "British National Insurance number (NINO)", "Example: AB 12 34 56 D", "(?!BG|GB|NK|KN|TN|NT|ZZ)[A-CEGHJ-PR-TW-Z][A-CEGHJ-NPR-TW-Z](?:\\s*\\d{2}){3}\\s*[A-D]", "############", Lists.newArrayList((Object[])new String[]{"ssn", "uk", "United Kingdom"})), new DataCleanerBuiltInRuleModel("ssn-33", "British NHS Number", "Example: 401 023 2137", "[0-9]{3}[ -]?[0-9]{3}[ -]?[0-9]{4}", "############", Lists.newArrayList((Object[])new String[]{"ssn", "uk", "United Kingdom"})), new DataCleanerBuiltInRuleModel("ssn-35", "USA social security number", "Example: 100-22-3333", "(?:\\s)?(?!666|000|9\\d{2})\\d{3}-(?!00)\\d{2}-(?!0{4})\\d{4}(?:\\s)?", "############", Lists.newArrayList((Object[])new String[]{"ssn", "usa", "United States"}))});
    }

    private List<DataCleanerBuiltInRuleModel> getOther() {
        return Lists.newArrayList((Object[])new DataCleanerBuiltInRuleModel[]{new DataCleanerBuiltInRuleModel("other-1", "Email addresses", "Examples: test@test.com", "[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}", "#@#.#", Lists.newArrayList((Object[])new String[]{"other", "email", "General"})), new DataCleanerBuiltInRuleModel("other-2", "Standard credit card numbers", "Matches Visa, MasterCard, American Express, Diners Club, Discover, and JCB cards. Examples: MasterCard - 5258704108753590", "\\b(?:4[ -]*(?:\\d[ -]*){11}(?:(?:\\d[ -]*){3})?\\d|(?:5[ -]*[1-5](?:[ -]*\\d){2}|(?:2[ -]*){3}[1-9]|(?:2[ -]*){2}[3-9][ -]*\\d|2[ -]*[3-6](?:[ -]*\\d){2}|2[ -]*7[ -]*[01][ -]*\\d|2[ -]*7[ -]*2[ -]*0)(?:[ -]*\\d){12}|3[ -]*[47](?:[ -]*\\d){13}|3[ -]*(?:0[ -]*[0-5]|[68][ -]*\\d)(?:[ -]*\\d){11}|6[ -]*(?:0[ -]*1[ -]*1|5[ -]*\\d[ -]*\\d)(?:[ -]*\\d){12}|(?:2[ -]*1[ -]*3[ -]*1|1[ -]*8[ -]*0[ -]*0|3[ -]*5(?:[ -]*\\d){3})(?:[ -]*\\d){11})\\b", "#### #### #### ####", Lists.newArrayList((Object[])new String[]{"other", "card", "General"})), new DataCleanerBuiltInRuleModel("other-3", "International Bank Account Number (IBAN)", "Matches all IBANs. Example - France FR7630006000011234567890189, Germany DE91100000000123456789", "[a-zA-Z]{2}[0-9]{2}[a-zA-Z0-9]{4}[0-9]{7}([a-zA-Z0-9]?){0,16}", "IBAN #########", Lists.newArrayList((Object[])new String[]{"other", "iban", "General"})), new DataCleanerBuiltInRuleModel("other-4", "Internet Protocol version 4 (IPv4)", "Examples: 192.168.1.1", "(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])", "###.###.###.###", Lists.newArrayList((Object[])new String[]{"other", "ip", "General"}))});
    }
}

