/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service.anonymizer.global;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserDetailsManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.user.User;
import de.actonic.confluence.gdpr.component.service.anonymizer.global.GlobalContentChanger;
import de.actonic.confluence.gdpr.model.ContentChangerResult;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserDataChanger
extends GlobalContentChanger {
    private static final String NAME = "clearProfile";
    private static final String GROUP = "global";
    @ComponentImport
    private UserDetailsManager userDetailsManager;

    @Autowired
    protected UserDataChanger(@ComponentImport PluginSettingsFactory pluginSettingsFactory, UserDetailsManager userDetailsManager) {
        super(pluginSettingsFactory);
        this.userDetailsManager = userDetailsManager;
    }

    @Override
    public ContentChangerResult changeIssues(String currentJobId, ConfluenceUser sourceUser) {
        this.setJobMessage(currentJobId, "Clear user data...");
        StringBuilder changesTotal = new StringBuilder();
        StringBuilder changesSuccess = new StringBuilder();
        String changesFail = "";
        try {
            for (String group : this.userDetailsManager.getProfileGroups()) {
                List keys = this.userDetailsManager.getProfileKeys(group);
                for (String key : keys) {
                    String property = this.userDetailsManager.getStringProperty((User)sourceUser, key);
                    this.userDetailsManager.setStringProperty((User)sourceUser, key, "");
                    changesSuccess.append(key).append(", ");
                    changesTotal.append(key).append(", ");
                }
            }
        }
        catch (Exception e) {
            changesFail = e.getMessage();
            e.printStackTrace();
        }
        return new ContentChangerResult(currentJobId, changesTotal.toString(), changesSuccess.length() > 0 ? this.buildMessage(Arrays.asList("Successfully cleared user data ", changesSuccess.toString(), "\n")) : changesSuccess.toString(), !changesFail.isEmpty() ? this.buildMessage(Arrays.asList("Failed to clear user data ", changesFail, "\n")) : changesFail);
    }

    @Override
    public String getChangerName() {
        return NAME;
    }

    @Override
    public String getChangerGroup() {
        return GROUP;
    }
}

