/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.manager;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import de.actonic.gdpr.general.manager.GDPRSettingsManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SecurityCheckManager {
    private final GDPRSettingsManager GDPRSettingsManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final UserManager userManager;

    @Autowired
    public SecurityCheckManager(GDPRSettingsManager GDPRSettingsManager2, UserAccessor userAccessor, UserManager userManager) {
        this.GDPRSettingsManager = GDPRSettingsManager2;
        this.userAccessor = userAccessor;
        this.userManager = userManager;
    }

    public Boolean isUserHasPermissions() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        String gdprGroupString = this.GDPRSettingsManager.getAllowedGroup();
        return !(!this.userManager.isAdmin(user.getKey()) && !this.userManager.isSystemAdmin(user.getKey()) || !StringUtils.isBlank((CharSequence)gdprGroupString) && !this.userAccessor.hasMembership(gdprGroupString, user.getName()));
    }

    public Boolean isUserConfluenceAdmin(ConfluenceUser confluenceUser) {
        return true;
    }
}

