require(["jquery",  "actonic-gdpr/domReady", "actonic-gdpr/core/flags", "actonic-gdpr/plugin-setting/rest"], function ($, domReady, flags, Rest) {
    domReady(function () {
        new Settings().init();
    });

    function Settings() {
        this.init = function () {
            loadSettings();

            $("#help-btn").click(function () {
                AJS.dialog2("#help-dialog").show();
            });

            $("#plugin-settings-form-submit-btn").on("click", function (e) {
                e.preventDefault();
                saveSettings();
            });

            $("#clean-group-picker-btn").click(function () {
                $("#allowed-group").val("").trigger("change");
            });

            $("#custom-export-model").on("click", function(){
                Rest.getExports(
                    function(data, requestLink) {
                        window.location = requestLink;
                    },
                    function(){
                        if (error.status == 400) {
                            flags.showFlag("Error code 400", error.responseText, "warning");
                        }
                        if (error.status == 403) {
                            flags.showFlag("Error code 403", error.responseText, "warning");
                        }
                    }
                );
            });

          $("#custom-import-model").on("click", function () {
          $("#custom-import-field").html(ACTONIC.GDPR.PLUGINSETTINGS.showModal());
          $("#import-data-dialog").attr("aria-hidden", "false");

          AJS.dialog2("#import-data-dialog").show();

          $("#upload-import").on("click", function () {

              var fileInput = document.getElementById('file-import');
              if (fileInput.files.length === 0) {
                  console.error("No file selected.");
                  return;
              }

              var currentData;
              var reader = new FileReader();
              reader.addEventListener('load', function() {
                  currentData = this.result;

                  $.ajax({
                      type: "PUT",
                      url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/troubleshooting/import",
                      data: currentData,
                      processData: false,
                      headers: {"Content-Type": "application/json"},
                      success: function () {
                          AJS.dialog2("#import-data-dialog").hide();
                          $("#custom-import-field").html("");
                          location.replace(location.href);
                      },
                      error: function (jqXHR, textStatus, errorThrown) {
                          flags.showFlag(
                              AJS.I18n.getText("warning.main.error"),
                              AJS.I18n.getText("An error occurred while importing the configuration."),
                              "error"
                          );
                      }
                  });
              });
              reader.readAsText(fileInput.files[0]);
          });

          $("#cancel-import").on("click", function () {
              AJS.dialog2("#import-data-dialog").hide();
              $("#custom-import-field").html("");
          });
      });

            window.onbeforeunload = null; // prevent 'Changes you made may not be saved' message
        }

        function loadSettings() {
            Rest.loadSettings(
                function (data) {

                    $("#progress-indicator-main-settings").hide();
                    if (data) {

                        $("#rowsPerPage").val(data.rowsPerPage);
                        $("#track-issue-access-statistics").prop("checked", data.trackIssueAccessStatistics);
                        $("#track-amplitude-statistics").prop("checked", data.trackAmplitudeStatistics);
                        $("#purge-access-statistics-after").val(data.purgeAccessStatisticsAfter);
                        $("#runTasksFromUser").val(data.runTasksFromUser);

                        $("#history-count").val(data.executionCount);
                        $("#execution-entries").val(data.executionEntries);
                        $("#task-timeout").val(data.timeout);

                        AJS.$("#runTasksFromUser").auiSelect2({
                            placeholder: "Select user",
                            initSelection: function (element, callback) {
                                callback({id: data.runTasksFromUser, text: data.runTasksFromUser});
                            },
                            dropdownAutoWidth: true,
                            allowClear: true,
                            ajax: {
                                dataType: "json",
                                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/picker/user",
                                data: function (term) {
                                    return {
                                        query: term
                                    };
                                },
                                results: function (data) {
                                    var results = [];
                                    $.each(data, function (index, item) {
                                        results.push({id: item.id, text: item.id + " (" + item.text + ")" });
                                    });
                                    return {
                                        results: results
                                    };
                                }
                            }
                        });

                        $("#run-gdpr-group").val(data.allowedGroup);
                        AJS.$("#run-gdpr-group").auiSelect2({
                            placeholder: "Select group",
                            initSelection: function (element, callback) {
                                callback({id: data.allowedGroup, text: data.allowedGroup});
                            },
                            dropdownAutoWidth: true,
                            allowClear: true,
                            ajax: {
                                dataType: "json",
                                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/picker/gdpr-groups",
                                data: function (term) {
                                    return {
                                        q: term
                                    };
                                },
                                results: function (data) {
                                    var results = [];
                                    $.each(data, function (index, item) {
                                        results.push({id: item.id, text: item.text});
                                    });
                                    return {
                                        results: results
                                    };
                                }
                            }
                        });

                    } else {
                        flags.showFlag(AJS.I18n.getText("warning.main.error"), AJS.I18n.getText("js-permission-monitoring-page.warning.error-getting-plugin"), "error");
                    }
                },
                function (error) {
                    $("#progress-indicator-main-settings").hide();
                    flags.showFlag(AJS.I18n.getText("warning.main.error"), AJS.I18n.getText("js-permission-monitoring-page.warning.error-getting-settings") + " " + JSON.stringify(error), "error");
                });
        }

        function saveSettings() {
            var request = {
                rowsPerPage: $("#rowsPerPage").val(),
                trackIssueAccessStatistics: $("#track-issue-access-statistics").prop("checked"),
                trackAmplitudeStatistics: $("#track-amplitude-statistics").prop("checked"),
                purgeAccessStatisticsAfter: $("#purge-access-statistics-after").val(),
                runTasksFromUser: $("#runTasksFromUser").val(),
                allowedGroup: $("#run-gdpr-group").val(),
                executionCount: $("#history-count").val(),
                executionEntries: $("#execution-entries").val(),
                timeout: $("#task-timeout").val(),
            }

            Rest.saveSettings(request,
                function (data) {
                    flags.simpleSuccess("Saved");
                    setTimeout(function () {
                        location.reload();
                    }, 500);
                },
                function (error) {
                    flags.showFlag(AJS.I18n.getText("warning.main.error"), AJS.I18n.getText("js-permission-monitoring-page.warning.error-saving-plugin") + " " + JSON.stringify(error), "error");
                });
        }
    }

    return new Settings();
});