/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.newDC.rest.template;

import de.actonic.gdpr.shared.general.exception.GDPRException;
import de.actonic.gdpr.shared.general.exception.GDPRExceptionHandler;
import de.actonic.gdpr.shared.general.model.GDPRSearchResultModel;
import de.actonic.gdpr.shared.general.util.GDPRJsonUtils;
import de.actonic.gdpr.shared.general.util.GDPRLogHelper;
import de.actonic.gdpr.shared.newDC.model.template.ConditionDCModel;
import de.actonic.gdpr.shared.newDC.service.template.condition.ConditionDCService;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;

@Path(value="/templates/{templateId}/conditions")
@Produces(value={"application/json"})
public class ConditionDCRest {
    private static final Logger log = LoggerFactory.getLogger(ConditionDCRest.class);
    private final ConditionDCService conditionService;

    public ConditionDCRest(ConditionDCService conditionService) {
        this.conditionService = conditionService;
    }

    @GET
    @Path(value="/")
    public Response getTemplateActions(@PathParam(value="templateId") Integer templateId, @QueryParam(value="page") Integer page, @QueryParam(value="limit") Integer limit, @QueryParam(value="name") String name, @QueryParam(value="status") Boolean isEnable, @QueryParam(value="type") String type) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            GDPRSearchResultModel result = this.conditionService.getFilteredTemplateConditions(templateId, page, limit, name, isEnable, type);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)result)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/{conditionId}")
    public Response getTemplateActionById(@PathParam(value="templateId") Integer templateId, @PathParam(value="conditionId") String conditionId) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            ConditionDCModel condition = this.conditionService.getTemplateConditionById(templateId, conditionId);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)condition)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/")
    public Response createTemplateAction(@PathParam(value="templateId") Integer templateId, @RequestBody ConditionDCModel requestModel) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            List conditions = this.conditionService.addTemplateCondition(templateId, requestModel);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)conditions)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @PUT
    @Path(value="/{conditionId}")
    public Response updateTemplateActionById(@PathParam(value="templateId") Integer templateId, @PathParam(value="conditionId") String conditionId, @RequestBody ConditionDCModel requestModel) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            requestModel.setId(conditionId);
            List conditions = this.conditionService.updateTemplateConditionById(templateId, requestModel);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)conditions)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @DELETE
    @Path(value="/{conditionId}")
    public Response deleteTemplateActionById(@PathParam(value="templateId") Integer templateId, @PathParam(value="conditionId") String conditionId) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            this.conditionService.deleteConditionById(templateId, conditionId);
            log.debug(logHelper.stop());
            return Response.ok().build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }
}

