/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.announcement.manager;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.User;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import de.actonic.gdpr.announcement.manager.GDPRGroupManager;
import de.actonic.gdpr.general.manager.GDPRSettingsManager;
import de.actonic.gdpr.shared.general.exception.GDPRForbiddenException;
import de.actonic.gdpr.shared.general.manager.IGDPRUserManager;
import de.actonic.gdpr.shared.general.model.GDPRUserModel;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfluenceUserManager
implements IGDPRUserManager {
    public static final String DEFAULT_AVATAR_PATH = "/images/icons/profilepics/default.svg";
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final GDPRSettingsManager settingsManager;
    private final GDPRGroupManager groupManager;
    @ComponentImport
    private final I18nResolver i18n;

    @Autowired
    public ConfluenceUserManager(UserManager userManager, UserAccessor userAccessor, GDPRSettingsManager settingsManager, GDPRGroupManager groupManager, I18nResolver i18n) {
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.settingsManager = settingsManager;
        this.groupManager = groupManager;
        this.i18n = i18n;
    }

    public boolean isAdmin() {
        ConfluenceUser user = this.getUser();
        return user != null && (this.userManager.isAdmin(user.getKey()) || this.userManager.isSystemAdmin(user.getKey()));
    }

    public void ifNotAdminAndNotInAllowedGroupThrowException(String message) {
        if (!this.isAdmin()) {
            throw new GDPRForbiddenException(message);
        }
        String allowedGroup = this.settingsManager.getAllowedGroup();
        if (!Strings.isNullOrEmpty((String)allowedGroup) && !this.groupManager.isUserInGroup(this.getLoggedUser(), allowedGroup)) {
            throw new GDPRForbiddenException(this.i18n.getText("java-forbidden-exception-message"));
        }
    }

    public GDPRUserModel getUserByKey(String key) {
        ConfluenceUser user = this.userAccessor.getUserByKey(new UserKey(key));
        return this.convert(user);
    }

    public GDPRUserModel getUserByKeyOrReturnAnonymousUser(String key) {
        ConfluenceUser user = this.userAccessor.getUserByKey(new UserKey(key));
        if (user == null) {
            return GDPRUserModel.builder().userKey(key).userName("Anonymized User").emailAddress("").displayName("Anonymized User").isEnabled(Boolean.valueOf(false)).avatarUrls((Map)ImmutableMap.of((Object)"48x48", (Object)DEFAULT_AVATAR_PATH)).build();
        }
        return this.convert(user);
    }

    public GDPRUserModel getUserByKeyOrName(String keyOrName) {
        GDPRUserModel user = this.getUserByName(keyOrName);
        if (user == null) {
            user = this.getUserByKey(keyOrName);
        }
        return user;
    }

    public GDPRUserModel getLoggedUser() {
        ConfluenceUser user = this.getUser();
        return this.convert(user);
    }

    public GDPRUserModel getUserByName(String userName) {
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        return this.convert(user);
    }

    private ConfluenceUser getUser() {
        return AuthenticatedUserThreadLocal.get();
    }

    private GDPRUserModel convert(ConfluenceUser user) {
        if (user == null) {
            return null;
        }
        return GDPRUserModel.builder().userKey(user.getKey().getStringValue()).userName(user.getName()).emailAddress(user.getEmail()).displayName(user.getFullName()).isEnabled(Boolean.valueOf(true)).avatarUrls(this.getAvatarUrls(user)).build();
    }

    private Map<String, String> getAvatarUrls(ConfluenceUser confluenceUser) {
        HashMap<String, String> avatars = new HashMap<String, String>();
        avatars.put("48x48", this.userAccessor.getUserProfilePicture((User)this.userAccessor.getUserByKey(confluenceUser.getKey())).getUriReference());
        return avatars;
    }
}

