/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.manager;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.actonic.confluence.gdpr.model.AnnouncingModel;
import java.lang.reflect.Type;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnnouncingCacheManager {
    private static final Logger log = LoggerFactory.getLogger(AnnouncingCacheManager.class);
    public static final String CACHE_NAME = "get-announcement-for-user-cache";
    private final Cache<String, String> nextAnnouncementCache;

    @Autowired
    public AnnouncingCacheManager(@ComponentImport CacheManager cacheManager) {
        this.nextAnnouncementCache = cacheManager.getCache(CACHE_NAME);
    }

    public void clearCache() {
        this.nextAnnouncementCache.removeAll();
    }

    public AnnouncingModel getValue(String key) {
        return null;
    }

    public void putValue(String key, String value) {
        this.nextAnnouncementCache.put((Object)key, (Object)value);
    }

    public void removeValue(String key) {
        this.nextAnnouncementCache.remove((Object)key);
    }

    private List<AnnouncingModel> jsonToAnnouncingModels(String json) {
        try {
            Type type = new TypeToken<List<AnnouncingModel>>(){}.getType();
            return (List)new Gson().fromJson(json, type);
        }
        catch (Exception e) {
            return Lists.newArrayList();
        }
    }

    private String announcingModelsToJson(List<AnnouncingModel> announcingModels) {
        try {
            return new Gson().toJson(announcingModels);
        }
        catch (Exception e) {
            return "";
        }
    }
}

