define("actonic-gdpr/settings/execute", ["jquery", "actonic-gdpr/core/flags", "actonic-gdpr/core/picker"], function ($, flags, Picker) {

    function Execute() {
        var defaultUserValue = $("#runTasksFromUser").val();
        var defaultGdprValue = $("#run-gdpr-group").val();

        this.init = function () {
            Picker.initializeUserPicker("runTasksFromUser", false, defaultUserValue);
            initializeGdprGroupPicker($("#run-gdpr-group"));

            $("#clean-group-picker-btn").click(function () {
                $("#run-gdpr-group").val("").trigger("change");
            });

        };

        /*function initializeUserPicker(userPickerSelector) {
            userPickerSelector.auiSelect2({
                placeholder: AJS.I18n.getText("js-settings.user-picker.placeholder"),
                initSelection: function (element, callback) {
                    if (defaultUserValue) {
                        callback({id: defaultUserValue, text: defaultUserValue});
                    }
                },
                dropdownAutoWidth: true,
                allowClear: true,
                ajax: {
                    url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/picker/users",
                    dataType: "json",
                    data: function (term) {
                        return {
                            q: term
                        };
                    },
                    results: function (data) {
                        return {
                            results: $.map(data, function (el) {
                                return {
                                    id: el.id,
                                    text: el.text + ' (' + el.id + ')'
                                }
                            })
                        };
                    }
                }
            });
        }*/

        function initializeGdprGroupPicker(groupPickerSelector) {
            groupPickerSelector.auiSelect2({
                placeholder: AJS.I18n.getText("js-settings.group-picker.placeholder"),
                initSelection: function (element, callback) {
                    if (defaultGdprValue) {
                        callback({id: defaultGdprValue, text: defaultGdprValue});
                    }
                },
                dropdownAutoWidth: true,
                allowClear: true,
                ajax: {
                    url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/picker/gdpr-groups",
                    dataType: "json",
                    data: function (term) {
                        return {
                            q: term
                        };
                    },
                    results: function (data) {
                        return {
                            results: $.map(data, function (el) {
                                return {
                                    id: el.id,
                                    text: el.id
                                }
                            })
                        };
                    }
                }
            });
        }
    }

    return new Execute();
});
