define("gdpr/data-cleaner/user-anonymizer-template",
    ["jquery", "gdpr/data-cleaner/rest", "gdpr/data-cleaner/task", "gdpr/core/log", "gdpr/data-cleaner/rules/rest",
        "actonic-gdpr/core/flags", "actonic-gdpr/core/picker"],
    function ($, TemplatesRest, DataCleanerTasks, log, RulesRest, flags, Picker) {
        function UserAnonymizerTemplate() {
            var init = false;
            this.init = function () {
                if (!$("#confirm-create-user-anonymizer-dialog").length) $("body").append(ACTONIC.GDPR.DATACLEANER.MAIN.createUserAnonymizerDialog());

                $("#anonymize-user").click(showDialog);
                $("#create-user-anonymizer-template-btn").click(createTemplateForUserAnonymization);
                $("#cancel-create-user-anonymizer-template-btn").click(hideDialog);

                window.onbeforeunload = null; // prevent 'Changes you made may not be saved' message
            };

            function initializeUserPickers() {
                Picker.initializeUserPicker("anonymization-template-source-user", true);
                Picker.initializeUserPicker("anonymization-template-target-user", false);
            }

            function showDialog() {
                AJS.dialog2("#confirm-create-user-anonymizer-dialog").show();

                if (!init) {
                    init = true;
                    initializeUserPickers();
                }
            }

            function hideDialog() {
                AJS.dialog2("#confirm-create-user-anonymizer-dialog").hide();
            }

            /*function initUserPicker(selector) {
                $(selector).auiSelect2({
                    placeholder: AJS.I18n.getText("soy-data-clean.edit.text.user-placeholder"),
                    dropdownAutoWidth: true,
                    ajax: {
                        url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/picker/users",
                        dataType: "json",
                        data: function (term) {
                            return {
                                q: term
                            };
                        },
                        results: function (data) {
                            return {
                                results: $.map(data, function (el) {
                                    return {
                                        id: el.id,
                                        text: el.text + ' (' + el.id + ')'
                                    }
                                })
                            };
                        }
                    },
                });
              /!*  new AJS.SingleSelect({
                    element: $(selector),
                    itemAttrDisplayed: "label",
                    removeDuplicates: true,
                    submitInputVal: false,
                    removeOnUnSelect: false,
                    ajaxOptions: {
                        url: AJS.contextPath() + "/rest/api/2/user/picker",
                        query: true, // keep going back to the sever for each keystroke
                        formatResponse: UserPickerUtil.formatResponse
                    }
                });*!/
            }*/

            function createRuleForTemplate(templateId, ruleName, searchType, ruleType, searchString, replaceString) {
                var request = {
                    templateId: templateId,
                    enabled: true,
                    name: ruleName,
                    searchType: searchType,
                    searchString: searchString,
                    replaceType: ruleType,
                    replaceString: replaceString
                };
                return $.ajax({
                    url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/rules",
                    type: "PUT",
                    data: JSON.stringify(request),
                    cache: false,
                    async: false,
                    headers: {"Content-Type": "application/json"}
                    /*success: function (data) {
                        if (typeof successCallback === "function") successCallback(data);
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        if (typeof errorCallback === "function") errorCallback(jqXHR);
                    }*/
                })
            }

            function createTemplateForUserAnonymization() {
                var sourceUserName = $("#anonymization-template-source-user").val() ? $("#anonymization-template-source-user").val() : "";
                var targetUserName = $("#anonymization-template-target-user").val() ? $("#anonymization-template-target-user").val() : "";

                //log.debug("sourceUserName = " + JSON.stringify(sourceUserName));
                //log.debug("targetUserName = " + JSON.stringify(targetUserName));

                if (sourceUserName && targetUserName) {
                    TemplatesRest.getUserDetails(sourceUserName, targetUserName, function (sourceUserDetails, targetUserDetails) {
                        $("#create-user-anonymizer-template-btn").attr("disabled", true);
                        var request = {
                            type: "custom",
                            action: "create"
                        };
                        var subName = ' (' + sourceUserDetails[0].id + '->' + targetUserDetails[0].id + ')';
                        TemplatesRest.draft(request, function (templateId) {
                            //log.debug("Rest.draft data = " + JSON.stringify(templateId));
                            var templateDraftContent = {
                                name: AJS.I18n.getText("js-data-clean.template.uat.text.name") + subName,
                                cql: "type in (page, blogpost)",
                                objects: ["title", "body", "comment", "author", "comment-author", "attach-author"],
                                notificationType: "none"
                            };

                            TemplatesRest.update(templateId, templateDraftContent, function (templateContent) {
                                $.when(
                                    createRuleForTemplate(templateId, AJS.I18n.getText("js-data-clean.template.uat.name"), "user", "user", sourceUserDetails[0].id, targetUserDetails[0].id),
                                    createRuleForTemplate(templateId, AJS.I18n.getText("js-data-clean.template.uat.display"), "plain", "plain-text", sourceUserDetails[0].text, targetUserDetails[0].text),
                                    createRuleForTemplate(templateId, AJS.I18n.getText("js-data-clean.template.uat.email"), "plain", "plain-text", sourceUserDetails[0].link, targetUserDetails[0].link),
                                    createRuleForTemplate(templateId, AJS.I18n.getText("js-data-clean.template.uat.mention"), "plain", "plain-text", "[~" + sourceUserDetails[0].id + "]", "[~" + targetUserDetails[0].id + "]"),
                                    createRuleForTemplate(templateId, AJS.I18n.getText("js-data-clean.template.uat.userkey"), "plain", "plain-text", sourceUserDetails[0].key, targetUserDetails[0].key)
                                ).done(function (a1, a2, a3, a4) {
                                    // a1, a2, a3 and a4 are lists of length 3 containing the response text,
                                    // status, and jqXHR object for each of the four ajax calls respectively.
                                    //log.debug("Rules have been created");

                                    var postFunctionContent = {
                                        name: AJS.I18n.getText("js-data-clean.template.pii.text.three"),
                                        rules: "",
                                        notificationType: "comment",
                                        anyRuleEnabled: true,
                                        notificationParameters: {comment: AJS.I18n.getText("js-data-clean.template.uat.text.notificationParameters.comment")},
                                        templateId: templateId,
                                        isEnabled: false
                                    };
                                    //log.debug("postFunctionContent = " + JSON.stringify(postFunctionContent));
                                    RulesRest.createPostFunction(postFunctionContent,
                                        function () {
                                            window.location = AJS.contextPath() + "/admin/actonic-gdpr/edit-data-cleaner-template.action?id=" + templateId;
                                        }, function (error) {
                                            log.error("RulesRest.createPostFunction error = " + JSON.stringify(error));
                                        });
                                });
                            }, function (error) {
                                log.error("TemplatesRest.update error = " + JSON.stringify(error));
                            });
                        }, function (error) {
                            log.error("TemplatesRest.draft error = " + JSON.stringify(error));
                            $("#create-user-anonymizer-template-btn").attr("disabled", false);
                        });
                    });
                } else {
                    flags.simpleWarning(AJS.I18n.getText("js-data-clean.template.error.no-user-defined"));
                }
            }
        }

        return new UserAnonymizerTemplate();
    });
