require(["jquery", "gdpr/data-cleaner/issue-post-function", "gdpr/data-cleaner/rest", "gdpr/data-cleaner/task",
        "gdpr/core/log", "actonic-gdpr/core/flags", "actonic-gdpr/core/intro", "actonic-gdpr/domReady",
        "actonic-gdpr/core/tippy", "gdpr/core/element-highlighter", "gdpr/core/utils", "gdpr/data-cleaner/rules", "gdpr/data-cleaner/cql-picker"],
    function ($, issuePostFunction, Rest, DataCleanerTask, log, flags, CoreIntro, domReady, Tippy, coreHighlighter, coreUtils, DataCleanerRules, CqlPicker) {
        domReady(function () {
            new DataCleanerEdit().init();
        });

        function DataCleanerEdit() {
            var action, currentTemplateId, hasActiveTask;

            this.init = function () {
                // action = coreUtils.getCurrentUrlParameterByName("action");
                currentTemplateId = coreUtils.getCurrentUrlParameterByName("id");

                // if (action === "edit" && currentTemplateId >= 0) {
                loadTemplate(currentTemplateId);
                /*} else {
                    $("#objects").auiSelect2();
                    enableTemplateEditing();
                }*/

                issuePostFunction.init();
                DataCleanerTask.initEvents();
                DataCleanerRules.init();
                //initializeJQLAutocomplete();

                $(document).on("templateLoaded", function (templateData) {
                    $("#objects").auiSelect2();
                    // JQLAutocomplete.init("scope", "jql-error-message");

                    //$("#template-name, #scope, #objects, #rule-notification-type").off("change");
                    $("#template-name, #scope, #objects, #rule-notification-type").on("change", function () {
                        $(".save-btn").addClass("aui-button-primary");
                    });
                });

                $(".save-btn").click(function (event) {
                    saveTemplateClickHandler();
                    $(".save-btn").removeClass("aui-button-primary");
                });

                $("#rule-notification-type").change(function () {
                    onNotificationTypeChange($(this).val());
                });

                $(".nav-bar-item").click(function () {
                    $(".nav-bar-item").removeClass("nav-active");
                    $(".nav-bar-content").hide();
                    $(this).addClass("nav-active");
                });
                $("#general-configuration-link").click(function () {
                    $("#general-configuration-wrapper").show();
                });
                $("#data-rules-link").click(function () {
                    $("#data-rules-wrapper").show();
                });
                $("#postfunctions-link").click(function () {
                    $("#post-functions-wrapper").show();
                });
                $("#total-postfunction-link").click(function () {
                    $("#total-post-functions-wrapper").show();
                });
                $("#scheduling-link").click(function () {
                    $("#scheduling-wrapper").show();
                });

                $("#scope").tooltip();

                $("#scope").click(function (e) {
                    e.preventDefault();
                    var scope = $("#scope").val();
                    var cqlType = $("#cql-type").val();
                    var cqlParams = cqlType === "cql" ? scope : (scope && scope !== "" ? JSON.parse(scope) : {});
                    var params = {cqlType: cqlType, cql: cqlParams};
                    CqlPicker.init("#scope", params);
                })

                /*$(".custom-predefined-jql").on("click", function () {
                    var jqlType = $(this).attr("data-jql-type");
                    var currentScope = $("#scope").val();

                    if(jqlType === "all") {
                        currentScope = "project is not EMPTY";
                    } else if(jqlType === "lastDays") {
                        currentScope = "created >= -30d";
                    }

                    $("#scope").val(currentScope);
                });*/

                // License.check();

                window.onbeforeunload = null; // prevent 'Changes you made may not be saved' message
            };

            function enableTemplateEditing() {
                $("#save-template").show();
                $("#save-template-total-postfunction").show();
                $("#add-rule-new").show();
                $("#add-builtin-rule").show();
                $("#btn-post-function").show();
                $(".aui-dropdown2-trigger").show();
                $("#save-template-scheduling").show();
            }

            function disableEditing() {
                $("#save-template").hide();
                $("#save-template-total-postfunction").hide();
                $("#add-rule-new").hide();
                $("#add-builtin-rule").hide();
                $("#btn-post-function").hide();
                $(".aui-dropdown2-trigger").hide();
                $("#save-template-scheduling").hide();
            }

            function onNotificationTypeChange(currentType) {
                $("#rule-notification-parameter-emails").parent().hide();

                if (currentType == "email") {
                    $("#rule-notification-parameter-emails").parent().show();
                }
            }

            function saveTemplateClickHandler() {
                var request = getTemplateRequest();
                validateRequest(request, function () {
                    Rest.update(currentTemplateId, request, function (data) {
                        //window.location.href = "actonic-gdpr-data-cleaner.jspa";
                        flags.simpleSuccess(AJS.I18n.getText("js-data-clean.template.edit-page.saved"));

                        request.issueCount = data.issueCount;
                        updateNavMenuTitle(request);
                    }, function (xhr) {
                    })
                });
            }

            function loadTemplate(id) {
                Rest.getById(id,
                    function (templateData) {
                        //log.debug(templateData);

                        hasActiveTask = templateData.task && templateData.task.status < 2;
                        //log.debug("hasActiveTask = " + hasActiveTask);
                        if (templateData.task) {
                            $("#results").attr("href", "data-cleaner-results.action?templateId=" + currentTemplateId + "&taskId=" + templateData.task.id);
                            $("#results").show();
                        }

                        $("#template-name").val(templateData.name);

                        if (templateData.notificationType)
                            $("#rule-notification-type").val(templateData.notificationType).trigger("change");

                        $(".start-task").attr("data-template-id", id);
                        $(".stop-task").attr("data-template-id", id);
                        $(".stop-task").attr("data-task-id", id);

                        if (templateData.task) {
                            $(".start-task").hide();
                            $(".stop-task").show();
                        } else {
                            $(".start-task").show();
                            $(".stop-task").hide();
                        }

                        if (templateData.objects) {
                            $("#objects").val(templateData.objects).trigger("change");
                        }

                        if (templateData.notificationParameters) {
                            if (templateData.notificationType == "email") {
                                $("#rule-notification-parameter-emails").val(templateData.notificationParameters.emails);
                            }
                        }

                        var cqlType = templateData.cqlType ? templateData.cqlType : "cql";
                        var json = templateData.cql;
                        $("#cql-type").val(cqlType);

                        if (cqlType === "cql") {
                            $("#scope").val(json);
                            $("#scope").text(json);
                            $("#scope").attr("original-title", json);
                        } else {
                            var jsonWithoutBrackets = "No parameters defined.";
                            var trimmed = "No parameters defined.";
                            if (json && json.length > 2) {
                                jsonWithoutBrackets = json.substring(1, json.length - 1);
                                trimmed = json.length > 50 ? json.substring(1, 50) + "..." : json.substring(1, json.length - 1);
                            }

                            $("#scope").val(json);
                            $("#scope").text(trimmed);
                            $("#scope").attr("original-title", jsonWithoutBrackets);
                        }

                        updateNavMenuTitle(templateData);

                        $(document).trigger("templateLoaded", templateData);

                        if (!hasActiveTask) {
                            $("#has-task").val("false");
                            enableTemplateEditing();
                        } else {
                            flags.simpleWarning(AJS.I18n.getText("js-data-clean.template.edit-page.active-or-planned"));
                        }
                    }, function (xhr) {
                        log.error(xhr);
                    })
            }

            function updateNavMenuTitle(templateData) {
                var generalConfigurationSubtitle = "";
                var successIcon = "<span class='custom-success-icon custom-icon icon'></span>";
                var errorIcon = "<span class='custom-error-icon custom-icon icon'></span>";
                var warningIcon = "<span class='custom-warning-icon custom-icon icon'></span>";

                if (templateData.name) {
                    generalConfigurationSubtitle = successIcon + AJS.I18n.getText("js-data-clean.template.edit-page.set") + "<br>";
                } else {
                    generalConfigurationSubtitle = errorIcon + AJS.I18n.getText("js-data-clean.template.edit-page.empty") + "<br>";
                }
                if (templateData.cql) {
                    generalConfigurationSubtitle += successIcon + AJS.I18n.getText("js-data-clean.template.edit-page.scope") + "<br>";
                } else {
                    generalConfigurationSubtitle += errorIcon + AJS.I18n.getText("js-data-clean.template.edit-page.scope-not-defined") + "<br>";
                }
                if (templateData.issueCount) {
                    generalConfigurationSubtitle += successIcon + templateData.issueCount + " " + AJS.I18n.getText("js-data-clean.template.edit-page.issue-count") + "<br>";
                }
                if (templateData.objects && templateData.objects.length > 0) {
                    generalConfigurationSubtitle += successIcon + templateData.objects.length + " " + AJS.I18n.getText("js-data-clean.template.edit-page.object-selected");
                } else {
                    generalConfigurationSubtitle += errorIcon + AJS.I18n.getText("js-data-clean.template.edit-page.no-object-selected");
                }
                $("#general-configuration-link-subtitle").html(generalConfigurationSubtitle);

                if (templateData.notificationType == "none") {
                    $("#total-postfunction-link-subtitle").html(warningIcon + AJS.I18n.getText("vm-data-cleaner-edit-page-result-not-defined"));
                }
                if (templateData.notificationType == "email") {
                    $("#total-postfunction-link-subtitle").html(successIcon + AJS.I18n.getText("js-data-clean.template.edit-page.report-email") + " " + templateData.notificationParameters.emails);
                }
                if (templateData.notificationType == "logging") {
                    $("#total-postfunction-link-subtitle").html(successIcon + AJS.I18n.getText("js-data-clean.template.edit-page.all-results-stored"));
                }
            }

            function getTemplateRequest() {
                var request = {
                    name: $("#template-name").val(),
                    cql: $("#scope").val(),
                    cqlType: $("#cql-type").val(),
                    objects: $("#objects").val(),
                    notificationType: $("#rule-notification-type").val()
                };

                if (request.notificationType == "email") {
                    var notificationParameters = {
                        emails: $("#rule-notification-parameter-emails").val()
                    };
                    request.notificationParameters = notificationParameters;
                }

                return request;
            }

            function validateTemplateName(templateName, successCallback) {
                if (!templateName) {
                    coreHighlighter.redBorder($("#template-name"));
                    flags.showFlag(AJS.I18n.getText("warning.main.validation-error"), AJS.I18n.getText("js-data-clean.template.text.template-name"), "warning");
                } else if (templateName.length > 128) {
                    coreHighlighter.redBorder($("#template-name"));
                    flags.showFlag(AJS.I18n.getText("warning.main.validation-error"), AJS.I18n.getText("js-data-clean.template.text.template-max-char"), "warning");
                } else {
                    successCallback();
                }
            }

            function validateTemplateCQL(cql, cqlType, successCallback) {
                if (cql && cql !== "") {
                    if (cqlType === "cql") {
                        Rest.checkCql(cql,
                            function (data) {
                                log.debug("Rest.checkCql data = " + JSON.stringify(data));
                                log.debug(data);
                                if (data && data.value) {
                                    coreHighlighter.redBorder($("#scope"));
                                    flags.showFlag(AJS.I18n.getText("warning.main.validation-error"), "Scope (CQL) defined by CQL is not valid. " + data.value, "warning");
                                } else {
                                    successCallback();
                                }
                            },
                            function (xhr) {
                                log.error(xhr);
                            }
                        );
                    }
                    if (cqlType === "params") {
                        try {
                            var json = JSON.parse(cql);
                            successCallback();
                        } catch (e) {
                            coreHighlighter.redBorder($("#scope"));
                            flags.showFlag(AJS.I18n.getText("warning.main.validation-error"), "Scope (CQL) defined by parameters is not valid.", "warning");
                        }
                    }
                } else {
                    coreHighlighter.redBorder($("#scope"));
                    flags.showFlag(AJS.I18n.getText("warning.main.validation-error"), "Scope (CQL) is empty or some parameters is not valid.", "warning");
                }
            }

            function validateTemplateNotifications(notificationType, notificationParameters, successCallback) {
                if (notificationType == "email") {
                    if (!notificationParameters.emails) {
                        coreHighlighter.redBorder($("#rule-notification-parameter-emails"));
                        flags.showFlag(AJS.I18n.getText("warning.main.validation-error"), "Email field should not be empty", "warning");
                    } else {
                        var isEmailValid = true;
                        var emails = notificationParameters.emails.split(",");
                        emails.forEach(function (email) {
                            if (!coreUtils.isEmailValid(email.trim())) isEmailValid = false;
                        });
                        if (!isEmailValid) {
                            coreHighlighter.redBorder($("#rule-notification-parameter-emails"));
                            flags.showFlag(AJS.I18n.getText("warning.main.validation-error"), AJS.I18n.getText("js-data-clean.template.text.email-not-valid"), "warning");
                        } else {
                            successCallback();
                        }
                    }
                } else {
                    successCallback();
                }
            }

            function validateTemplateObjects(objects, successCallback) {
                   if (!objects) {
                       coreHighlighter.redBorder($("#s2id_objects"));
                       flags.showFlag(AJS.I18n.getText("warning.main.validation-error"), AJS.I18n.getText("js-data-clean.template.text.objects-not-valid"), "warning");
                   } else {
                       successCallback();
                   }
            }

            function validateRequest(templateRequest, successCallback) {
                log.debug("validation ruleRequest = " + JSON.stringify(templateRequest));

                validateTemplateName(templateRequest.name, function () {
                    validateTemplateCQL(templateRequest.cql, templateRequest.cqlType, function () {
                        validateTemplateNotifications(templateRequest.notificationType, templateRequest.notificationParameters, function () {
                            validateTemplateObjects(templateRequest.objects, function (){
                                successCallback();
                            });
                        });
                    });
                });



              /*  var validationSuccess = true;
                var validationErrorMessage = "";
                if (!templateRequest.name) {
                    validationErrorMessage += "<li>" + AJS.I18n.getText("js-data-clean.template.text.template-name") + "</li>";
                    coreHighlighter.redBorder($("#template-name"));
                    validationSuccess = false;
                } else if (templateRequest.name.length > 128) {
                    validationErrorMessage += "<li>" + AJS.I18n.getText("js-data-clean.template.text.template-max-char") + "</li>";
                    coreHighlighter.redBorder($("#template-name"));
                    validationSuccess = false;
                }

                if (templateRequest.cql) {
                    Rest.checkCql(templateRequest.cql,
                        function (data) {
                            log.debug("Rest.checkCql data = " + JSON.stringify(data));
                            if (data && data.value) {
                                validationErrorMessage += "<li>Scope (CQL) is not valid. " + data.value + "</li>";
                                coreHighlighter.redBorder($("#scope"));
                                validationSuccess = false;
                            }
                        },
                        function (xhr) {
                            log.error(xhr);
                        }
                    );
                } else {
                    validationErrorMessage += "<li>Scope (CQL) is empty</li>";
                    coreHighlighter.redBorder($("#scope"));
                    validationSuccess = false;
                }

                if (templateRequest.notificationType == "email") {
                    if (!templateRequest.notificationParameters.emails) {
                        validationErrorMessage += "<li>Email field should not be empty</li>";
                        coreHighlighter.redBorder($("#rule-notification-parameter-emails"));
                        validationSuccess = false;
                    } else {
                        var isEmailValid = true;
                        var emails = templateRequest.notificationParameters.emails.split(",");
                        emails.forEach(function (email) {
                            if (!coreUtils.isEmailValid(email.trim())) isEmailValid = false;
                        });
                        if (!isEmailValid) {
                            validationErrorMessage += "<li>" + AJS.I18n.getText("js-data-clean.template.text.email-not-valid") + "</li>";
                            coreHighlighter.redBorder($("#rule-notification-parameter-emails"));
                            validationSuccess = false;
                        }
                    }
                }

                if (validationSuccess) {
                    successCallback();
                } else {
                    flags.showFlag(AJS.I18n.getText("warning.main.validation-error"), "<ul>" + validationErrorMessage + "</ul>", "warning");
                }*/
            }
        }
    });
