define("gdpr/data-cleaner/builtin-rules", ["jquery", "gdpr/data-cleaner/rules/rest", "actonic-gdpr/core/flags", "gdpr/core/log", "gdpr/core/utils"], function ($, Rest, flag, log, coreUtils) {
    function DataCleanerBuiltinRules() {
        var onRequireRulesRefreshHandler;
        var buildInList = [];
        var buildInCatList = [];
        var selectedLabels = [];

        this.init = function (config) {
            onRequireRulesRefreshHandler = config.onRequireRulesRefreshHandler;

            getAllBuiltInRules();

            $("#add-builtin-rule").on("click", initBuiltinRulesDialog);
        };

        function initBuiltinRulesDialog() {
            $("#rule-dialog-placeholder").html(ACTONIC.GDPR.DATACLEANER.EDIT.newBuiltDialog());
            $("#build-inner-loop").html(ACTONIC.GDPR.DATACLEANER.EDIT.newBuiltInnerLoop({list: buildInList}));

            $("#select-all-built-it-rules-checkbox").change(function() {
                if(this.checked) {
                   $("#build-inner-loop .build-custom-checkbox:visible").prop('checked', true);
                } else {
                    $("#build-inner-loop .build-custom-checkbox:visible").prop('checked', false);
                }
            });


            initButtonEvents();

            AJS.dialog2("#build-rule-dialog").show();
            AJS.$("#select-filter").auiSelect2({
                placeholder: AJS.I18n.getText("js-data-clean.build-ins.picker.placeholder.by-filter"),
                multiple: true,
                data: function () {
                    var results = [];
                    $.each(buildInCatList, function (index, item) {
                        results.push({id: item, text: item});
                    });
                    return {
                        results: results
                    };
                }
            });
        }

        function initButtonEvents() {
            $("#build-rule-dialog .aui-dialog2-header-close").off("click");
            $("#build-rule-dialog .aui-dialog2-header-close").on("click", function () {
                closeBuiltinRulesDialog();
            });

            $("#build-save-rule").off("click");
            $("#build-save-rule").on("click", function () {
                setSelectedBuildIn();
            });

            $("#select-filter").off("change");
            $("#select-filter").on("change", function (e) {
                $("#build-inner-loop").html("");

                var list;
                selectedLabels = [];
                var arrInputs = $(this).val().split(",");

                if ($(this).val().length < 1) {
                    list = {list: buildInList};
                    $("#build-inner-loop").html(ACTONIC.GDPR.DATACLEANER.EDIT.newBuiltInnerLoop(list));
                    return;
                }

                $.each(buildInList, function (itemIndex, item) {
                    if(arrInputs.includes(item.name) && !selectedLabels.includes(item)) {
                        selectedLabels.push(item);
                    }
                    $.each(item.labels, function (lblindex, label) {
                        if (arrInputs.includes(label) && !selectedLabels.includes(item)) {
                            selectedLabels.push(item);
                        }
                    });
                });

                list = {list: selectedLabels};
                $("#build-inner-loop").html(ACTONIC.GDPR.DATACLEANER.EDIT.newBuiltInnerLoop(list));
            });

            $("#build-category-delete-btn").off("click");
            $("#build-category-delete-btn").on("click", function () {
                $("#select-filter").val(null).trigger('change');
            });
        }

        function closeBuiltinRulesDialog() {
            AJS.dialog2("#build-rule-dialog").hide();
            $("#rule-dialog-placeholder").html("");
        }

        function setSelectedBuildIn() {
            var result = [];
            var templateId = coreUtils.getCurrentUrlParameterByName("id");
            var checkedBuildIns$ = $('input[type="checkbox"]:checked');
            if (checkedBuildIns$.length < 1) {
                return;
            }
            $.each(checkedBuildIns$, function (index, checkedbuildIn) {
                result.push($(checkedbuildIn).val());
            });

            Rest.setSelectedBuildIn(templateId, result.join(),
                function (data) {
                    if (data == "success") {
                        flag.simpleSuccess(AJS.I18n.getText("js-data-clean.build-ins.rest.announcing.success.desc"));
                        closeBuiltinRulesDialog();
                        onRequireRulesRefreshHandler();
                    }
                },
                function (error) {
                    flag.showFlag(AJS.I18n.getText("js-data-clean.build-ins.rest.get-all-build-ins.error.title"),
                        AJS.I18n.getText("js-data-clean.build-ins.rest.announcing.error.desc"),
                        "error");
                }
            );
        }

        function getAllBuiltInRules() {
            Rest.getAllBuildIn(function (data) {
                if (data.length > 0) {
                    buildInList = getCustomData(data);
                    buildInCatList = getCategoryList(data);
                } else $("#rule-table-placeholder").html(ACTONIC.GDPR.DATACLEANER.EDIT.noResults);
            })
        }

        function getCustomData(data) {
            data.forEach(function(item) {
                item.customLabel =  "#" + item.labels.join(" #");
            });

            return data;
        }

        function getCategoryList(data) {
            var tempArray = new Array();
            data.forEach(function (item) {
                if (!tempArray.includes(item.name)) {
                    tempArray.push(item.name)
                }
                item.labels.forEach(function (label) {
                    if (!tempArray.includes(label)) {
                        tempArray.push(label)
                    }
                });
            });
            return tempArray;
        }
    }

    return new DataCleanerBuiltinRules();
});
