/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.util;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import de.actonic.confluence.gdpr.component.manager.AbstractEntityDao;
import de.actonic.confluence.gdpr.model.ListPaginationModel;
import de.actonic.gdpr.general.manager.GDPRSettingsManager;
import java.util.List;
import net.java.ao.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PaginationUtils
extends AbstractEntityDao {
    private final GDPRSettingsManager GDPRSettingsManager;

    @Autowired
    public PaginationUtils(@ComponentImport ActiveObjects ao, GDPRSettingsManager GDPRSettingsManager2) {
        super(ao);
        this.GDPRSettingsManager = GDPRSettingsManager2;
    }

    public static synchronized List getSublist(List items, int startFrom, int limit) {
        int end;
        int start = (startFrom - 1) * limit;
        if (start < 0) {
            start = 0;
        }
        if ((end = start + limit) > items.size()) {
            end = items.size();
        }
        return items.subList(start, end);
    }

    public ListPaginationModel getPaginationObject(Integer currentPageNum, int rowsPerPage, List objList) {
        int end;
        int start;
        if (currentPageNum == null) {
            currentPageNum = 0;
        }
        if ((start = (currentPageNum - 1) * rowsPerPage) < 0) {
            start = 0;
        }
        if ((end = start + rowsPerPage) > objList.size()) {
            end = objList.size();
        }
        int totalPages = (int)Math.ceil((double)objList.size() / (double)rowsPerPage);
        return new ListPaginationModel(currentPageNum, totalPages, objList.subList(start, end));
    }

    public int getEntitiesSize(Class clazz, Query query) {
        return query != null ? this.ao.count(clazz, query) : this.ao.count(clazz);
    }

    private Query withLimit(Query query, Integer offset, Integer limit) {
        if (offset != null && offset != 0) {
            query.offset(offset.intValue());
        }
        if (limit != null && limit != 0) {
            query.limit(limit.intValue());
        }
        return query;
    }

    public ListPaginationModel getPaginationObjectByQuery(Class clazz, Query filterQuery, Integer page, Integer maxPageResults, int entitiesSize) {
        int start;
        if (maxPageResults == null || maxPageResults == 0) {
            maxPageResults = this.GDPRSettingsManager.getRowsPerPage();
        }
        if (page == null) {
            page = 0;
        }
        if ((start = (page - 1) * maxPageResults) < 0) {
            start = 0;
        }
        filterQuery = this.withLimit(filterQuery, start, maxPageResults);
        Object[] objects = this.ao.find(clazz, filterQuery);
        int totalPages = (int)Math.ceil((double)entitiesSize / (double)maxPageResults.intValue());
        return new ListPaginationModel(page, totalPages, Lists.newArrayList((Object[])objects));
    }
}

