/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.rest;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.gson.Gson;
import de.actonic.confluence.gdpr.component.manager.SecurityCheckManager;
import de.actonic.confluence.gdpr.component.service.PermissionMonitoringService;
import de.actonic.confluence.gdpr.model.EventModel;
import de.actonic.gdpr.general.manager.GDPRSettingsManager;
import de.actonic.gdpr.shared.general.exception.GDPRException;
import de.actonic.gdpr.shared.general.exception.GDPRExceptionHandler;
import de.actonic.gdpr.shared.general.manager.IGDPRUserManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/permission-monitoring")
public class PermissionMonitoringRest {
    private final PermissionMonitoringService permissionMonitoringService;
    private final GDPRSettingsManager GDPRSettingsManager;
    private final SecurityCheckManager securityCheckManager;
    private final IGDPRUserManager userManager;
    @ComponentImport
    private final I18nResolver i18n;
    private int maxExportItems = 10000;

    @Autowired
    public PermissionMonitoringRest(PermissionMonitoringService permissionMonitoringService, GDPRSettingsManager GDPRSettingsManager2, SecurityCheckManager securityCheckManager, IGDPRUserManager userManager, I18nResolver i18n) {
        this.permissionMonitoringService = permissionMonitoringService;
        this.GDPRSettingsManager = GDPRSettingsManager2;
        this.securityCheckManager = securityCheckManager;
        this.userManager = userManager;
        this.i18n = i18n;
    }

    private static String generateExportFileName() {
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy-HH.mm.ss");
        Date today = Calendar.getInstance().getTime();
        String reportDate = df.format(today);
        return "export-" + reportDate;
    }

    @POST
    @Path(value="/historical")
    public Response filterHistoricalEvents(@FormParam(value="page") Integer page, @FormParam(value="eventType") String eventType, @FormParam(value="userName") String userName, @FormParam(value="groupName") String groupName, @FormParam(value="spaceKey") String spaceKey, @FormParam(value="fromDate") Long fromDate, @FormParam(value="toDate") Long toDate, @FormParam(value="orderBy") String orderBy) {
        try {
            int end;
            this.userManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
            Map eventResultMap = this.permissionMonitoringService.filterHistoricalEventsV2("html", eventType, userName, groupName, spaceKey, fromDate, toDate, orderBy);
            List eventResultList = (List)eventResultMap.get("results");
            this.permissionMonitoringService.sortEvents(eventResultList, orderBy);
            if (page == null) {
                page = 0;
            }
            int offset = this.GDPRSettingsManager.getRowsPerPage();
            int start = (page - 1) * offset;
            if (start < 0) {
                start = 0;
            }
            if ((end = start + offset) > eventResultList.size()) {
                end = eventResultList.size();
            }
            int totalPages = (int)Math.ceil((double)eventResultList.size() / (double)offset);
            eventResultList = eventResultList.subList(start, end);
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("items", eventResultList);
            resultMap.put("statusCode", eventResultMap.get("statusCode"));
            resultMap.put("message", eventResultMap.get("message"));
            resultMap.put("totalPages", totalPages);
            resultMap.put("page", page);
            return Response.ok().entity((Object)new Gson().toJson(resultMap)).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/current")
    public Response filterCurrentEvents(@FormParam(value="page") Integer page, @FormParam(value="userName") String userName, @FormParam(value="groupName") String groupName, @FormParam(value="spaceKey") String spaceKey) {
        try {
            int end;
            this.userManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
            List<EventModel> eventResultList = this.permissionMonitoringService.filterCurrentEvents(userName, groupName, spaceKey, "html");
            if (page == null) {
                page = 0;
            }
            int offset = this.GDPRSettingsManager.getRowsPerPage();
            int start = (page - 1) * offset;
            if (start < 0) {
                start = 0;
            }
            if ((end = start + offset) > eventResultList.size()) {
                end = eventResultList.size();
            }
            int totalPages = (int)Math.ceil((double)eventResultList.size() / (double)offset);
            eventResultList = eventResultList.subList(start, end);
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("items", eventResultList);
            resultMap.put("totalPages", totalPages);
            resultMap.put("page", page);
            return Response.ok().entity((Object)new Gson().toJson(resultMap)).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/txt/historical")
    @Produces(value={"text/plain"})
    public Response getFileHistorical(@QueryParam(value="eventType") String eventType, @QueryParam(value="userName") String userName, @QueryParam(value="groupName") String groupName, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="fromDate") Long fromDate, @QueryParam(value="toDate") Long toDate, @QueryParam(value="orderBy") String orderBy) {
        if (!this.securityCheckManager.isUserHasPermissions().booleanValue()) {
            return Response.status((int)403).entity((Object)"Access denied").build();
        }
        Map eventResultMap = this.permissionMonitoringService.filterHistoricalEventsV2("csv", eventType, userName, groupName, spaceKey, fromDate, toDate, orderBy);
        List eventResultList = (List)eventResultMap.get("results");
        if (eventResultList.size() > this.maxExportItems) {
            return Response.status((int)406).build();
        }
        this.permissionMonitoringService.sortEvents(eventResultList, orderBy);
        String fileName = PermissionMonitoringRest.generateExportFileName();
        try {
            File file = File.createTempFile(fileName, "csv");
            CSVFormat csvFileFormat = CSVFormat.EXCEL.withHeader(new String[]{"Date", "Author", "User or Group", "Event type", "Details"});
            FileWriter fileWriter = new FileWriter(file);
            CSVPrinter csvFilePrinter = new CSVPrinter((Appendable)fileWriter, csvFileFormat);
            eventResultList.forEach(eventModel -> {
                try {
                    csvFilePrinter.printRecord(new Object[]{eventModel.getDate(), eventModel.getAuthor(), eventModel.getUserName(), eventModel.getSummary(), eventModel.getDetails()});
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            fileWriter.flush();
            fileWriter.close();
            csvFilePrinter.close();
            Response.ResponseBuilder response = Response.ok((Object)file);
            response.header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + ".csv\""));
            return response.build();
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.ok().entity((Object)new Gson().toJson((Object)e.getMessage())).build();
        }
    }

    @GET
    @Path(value="/txt/current")
    @Produces(value={"text/plain"})
    public Response getFileCurrent(@QueryParam(value="userName") String userName, @QueryParam(value="groupName") String groupName, @QueryParam(value="spaceKey") String spaceKey) {
        if (!this.securityCheckManager.isUserHasPermissions().booleanValue()) {
            return Response.status((int)403).entity((Object)"Access denied").build();
        }
        List<EventModel> eventResultList = this.permissionMonitoringService.filterCurrentEvents(userName, groupName, spaceKey, "csv");
        if (eventResultList.size() > this.maxExportItems) {
            return Response.status((int)406).build();
        }
        String fileName = PermissionMonitoringRest.generateExportFileName();
        try {
            File file = File.createTempFile(fileName, "csv");
            CSVFormat csvFileFormat = CSVFormat.EXCEL.withHeader(new String[]{"Space", "User", "Permission Type", "Permissions"});
            FileWriter fileWriter = new FileWriter(file);
            CSVPrinter csvFilePrinter = new CSVPrinter((Appendable)fileWriter, csvFileFormat);
            eventResultList.forEach(eventModel -> {
                try {
                    csvFilePrinter.printRecord(new Object[]{eventModel.getDetails(), eventModel.getAuthor(), eventModel.getUserName(), eventModel.getSummary()});
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            fileWriter.flush();
            fileWriter.close();
            csvFilePrinter.close();
            Response.ResponseBuilder response = Response.ok((Object)file);
            response.header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + ".csv\""));
            return response.build();
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.ok().entity((Object)new Gson().toJson((Object)e.getMessage())).build();
        }
    }
}

