/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service.anonymizer.content;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.core.persistence.ContentEntityObjectDao;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.confluence.search.ChangeIndexer;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Strings;
import de.actonic.confluence.gdpr.component.service.anonymizer.content.ContentEntityChanger;
import de.actonic.confluence.gdpr.model.ContentChangerResult;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserMentionChanger
extends ContentEntityChanger {
    private static final Logger log = LoggerFactory.getLogger(UserMentionChanger.class);
    public static final String NAME = "changeMentionUser";
    public static final String GROUP = "page";
    @ComponentImport
    private CommentManager commentManager;

    @Autowired
    protected UserMentionChanger(@ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport PageManager pageManager, CommentManager commentManager, @ComponentImport TransactionTemplate transactionTemplate, @ComponentImport ContentEntityObjectDao entityObjectDao, @ComponentImport ChangeIndexer changeIndexer, @ComponentImport EntityManagerProvider entityManagerProvider) {
        super(pluginSettingsFactory, pageManager, transactionTemplate, entityObjectDao, changeIndexer, entityManagerProvider);
        this.commentManager = commentManager;
    }

    @Override
    public boolean isAffected(EntityObject pissue, ConfluenceUser user) {
        return (Boolean)this.transactionTemplate.execute(() -> {
            ContentEntityObject issue = this.pageManager.getById(pissue.getId());
            ArrayList<ContentEntityObject> entityObjects = new ArrayList<ContentEntityObject>();
            if (issue != null) {
                entityObjects.add(issue);
                if (issue.getComments() != null && issue.getComments().size() > 0) {
                    entityObjects.addAll(issue.getComments());
                }
                for (ContentEntityObject object : entityObjects) {
                    if (!this.isAffectedIssue((EntityObject)object, user)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    public boolean isAffectedIssue(EntityObject issue, ConfluenceUser user) {
        try {
            return (Boolean)this.transactionTemplate.execute(() -> {
                ContentEntityObject entityObject = issue instanceof Comment ? this.commentManager.getById(issue.getId()) : this.pageManager.getById(issue.getId());
                if (entityObject != null && !Strings.isNullOrEmpty((String)entityObject.getBodyAsString())) {
                    return entityObject.getBodyAsString().contains(user.getKey().getStringValue());
                }
                return false;
            });
        }
        catch (Exception e) {
            log.error(e.getMessage());
            log.error(e.getStackTrace().toString());
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public ContentChangerResult changeIssues(String currentJobId, EntityObject issue, ConfluenceUser sourceUser, ConfluenceUser targetUser) {
        this.setJobMessage(currentJobId, "Updating user mention on page...");
        String changesTotal = "";
        String changesSuccess = "";
        String changesFail = "";
        log.debug(">> userMentionChanger (change) > executing for page=" + issue.getId());
        List pageComments = ((ContentEntityObject)issue).getComments();
        log.debug(">> userMentionChanger (change) > isCommentsNotNull=" + (pageComments != null) + ", hasSize=" + (pageComments != null && pageComments.size() > 0));
        if (pageComments != null) {
            int commentIssuesSize = pageComments.size();
            log.debug(">> userMentionChanger (change) > commentsSize=" + commentIssuesSize);
            for (Comment comment : pageComments) {
                log.debug(">> userMentionChanger (change) > isAffectedForComment? [commentId=" + comment.getId() + "]");
                if (!this.isAffectedIssue((EntityObject)comment, sourceUser)) continue;
                log.debug(">> userMentionChanger (change) > foundAffectedComment with commentId=" + comment.getId());
                changesTotal = changesTotal + issue.getId() + ",";
                log.debug(">> userMentionChanger (change) > trying to change userMentions for this comment");
                if (this.changeUserMention((ContentEntityObject)comment, (ContentEntityObject)issue, sourceUser, targetUser)) {
                    this.setJobMessage(currentJobId, "Updating user mention for comment " + comment.getId() + "(" + pageComments.indexOf(comment) + " of " + commentIssuesSize + ")");
                    changesSuccess = changesSuccess + issue.getId() + ", ";
                    log.debug(">> userMentionChanger (change) > success");
                    continue;
                }
                changesFail = changesFail + issue.getId() + ", ";
                log.debug(">> userMentionChanger (change) > failed");
            }
        }
        List<ContentEntityObject> versionIssues = this.getVersionList((ContentEntityObject)issue);
        int versionIssuesSize = versionIssues.size();
        for (ContentEntityObject version : versionIssues) {
            log.debug(">> userMentionChanger (change) > isAffectedForVersionedPage? [versionPageId=" + version.getId() + "]");
            if (!this.isAffectedIssue((EntityObject)version, sourceUser)) continue;
            log.debug(">> userMentionChanger (change) > foundAffectedPage with pageId=" + version.getId());
            changesTotal = changesTotal + version.getId() + ", ";
            this.setJobMessage(currentJobId, "Updating user mention for version page " + version.getId() + "(" + versionIssues.indexOf(version) + " of " + versionIssuesSize + ")");
            log.debug(">> userMentionChanger (change) > trying to change userMentions for this page");
            if (this.changeUserMention(version, (ContentEntityObject)issue, sourceUser, targetUser)) {
                changesSuccess = changesSuccess + version.getId() + ", ";
                log.debug(">> userMentionChanger (change) > success");
                continue;
            }
            changesFail = changesFail + version.getId() + ", ";
            log.debug(">> userMentionChanger (change) > failed");
        }
        return new ContentChangerResult(this.getChangerName(), changesTotal, changesSuccess, changesFail);
    }

    @Override
    public String getChangerName() {
        return NAME;
    }

    @Override
    public String getChangerGroup() {
        return GROUP;
    }

    private boolean changeUserMention(ContentEntityObject currentVersion, ContentEntityObject lastVersion, ConfluenceUser sourceUser, ConfluenceUser targetUser) {
        try {
            return (Boolean)this.transactionTemplate.execute(() -> {
                log.debug(">> userMentionChanger (change=>changeUserMention) > trying to get page/comment with id=" + currentVersion.getVersion());
                ContentEntityObject entityObject = currentVersion instanceof Comment ? this.commentManager.getById(currentVersion.getId()) : this.pageManager.getById(currentVersion.getId());
                log.debug(">> userMentionChanger (change=>changeUserMention) > found " + (currentVersion instanceof Comment ? "comment" : GROUP));
                try {
                    String bodyContent = entityObject.getBodyAsString();
                    bodyContent = bodyContent.replaceAll(sourceUser.getKey().getStringValue(), targetUser.getKey().getStringValue());
                    entityObject.setBodyAsString(bodyContent);
                    log.debug(">> userMentionChanger (change=>changeUserMention) > trying to update page/comment");
                    if (currentVersion instanceof Comment) {
                        this.commentManager.saveContentEntity(entityObject, (SaveContext)((DefaultSaveContext.Builder)DefaultSaveContext.builder().updateLastModifier(false).suppressAutowatch(true).suppressNotifications(true)).build());
                    } else {
                        this.saveNewEntity(entityObject, lastVersion);
                    }
                    log.debug(">> userMentionChanger (change=>changeUserMention) > success");
                    return true;
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    log.error(e.getStackTrace().toString());
                    e.printStackTrace();
                    return false;
                }
            });
        }
        catch (Exception e) {
            log.error(e.getMessage());
            log.error(e.getStackTrace().toString());
            e.printStackTrace();
            return false;
        }
    }
}

