define("actonic-gdpr/profile-visibility/rest", ["jquery"], function ($) {

    function Rest() {
        this.addRule = function (request, successCallback, errorCallback) {
            $.ajax({
                type: "PUT",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/profile-visibility",
                data: request,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.deleteRule = function (targetGroupName, successCallback, errorCallback) {
            $.ajax({
                type: "DELETE",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/profile-visibility",
                data: {targetGroupName: targetGroupName},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.getAllRules = function (successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/profile-visibility",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.getState = function (successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/profile-visibility/state",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.setState = function (state, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/profile-visibility/state",
                data: {state: state},
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.getMyProfileVisibilitySettings = function (successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/profile-visibility/my",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.showMyProfileForAll = function (successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/profile-visibility/my/show",
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.hideMyProfileForAll = function (successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/profile-visibility/my/hide",
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.getAnnouncingByUser = function (successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                dataType: 'json',
                url: AJS.contextPath() + "/rest/actonic-gdpr/2/announcements-statistics/user",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.updateAnswer = function (id, answer, request, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                data: request,
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/profile-visibility/update-answer/" + id + "/" + answer,
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
    }

    return new Rest();
});