define("actonic-gdpr/plugin-setting/rest", ["jquery"], function ($) {
    function Rest() {
        this.saveSettings = function (request, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/plugin-settings",
                data: JSON.stringify(request),
                dataType: "json",
                contentType: "application/json",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.loadSettings = function (successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/plugin-settings",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.getExports = function (successCallback, errorCallback) {
            var requestLink = AJS.contextPath() + "/rest/actonic-gdpr/1.0/plugin-settings/export";
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/plugin-settings/export",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data, requestLink);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
    }
    return new Rest();
});