/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.settings.rest;

import com.google.gson.Gson;
import de.actonic.gdpr.general.manager.GDPRSettingsManager;
import de.actonic.gdpr.shared.general.exception.GDPRException;
import de.actonic.gdpr.shared.general.exception.GDPRExceptionHandler;
import de.actonic.gdpr.shared.general.manager.IGDPRUserManager;
import de.actonic.gdpr.shared.general.model.GDPRSettingsModel;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/plugin-settings")
@Produces(value={"application/json"})
public class PluginSettingsRest {
    private final GDPRSettingsManager gdprSettingsManager;
    private final IGDPRUserManager userManager;

    public PluginSettingsRest(GDPRSettingsManager gdprSettingsManager, IGDPRUserManager userManager) {
        this.gdprSettingsManager = gdprSettingsManager;
        this.userManager = userManager;
    }

    @GET
    @Path(value="/")
    public Response getPluginSettings() {
        try {
            this.userManager.ifNotAdminAndNotInAllowedGroupThrowException("Only administrators can get plugin settings");
            return Response.ok().entity((Object)new Gson().toJson((Object)this.gdprSettingsManager.getPluginSettings())).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    public Response savePluginSettings(GDPRSettingsModel psm) {
        this.gdprSettingsManager.setRowsPerPage(psm.getRowsPerPage());
        this.gdprSettingsManager.setPurgeAccessStatisticsAfter(psm.getPurgeAccessStatisticsAfter());
        this.gdprSettingsManager.setRunTasksFromUser(psm.getRunTasksFromUser());
        this.gdprSettingsManager.setAllowedGroup(psm.getAllowedGroup());
        this.gdprSettingsManager.setTrackIssueAccessStatistics(psm.isTrackIssueAccessStatistics());
        this.gdprSettingsManager.setTrackAmplitudeStatistics(psm.isTrackAmplitudeStatistics());
        this.gdprSettingsManager.setExecutionHistoryCount(psm.getExecutionCount());
        this.gdprSettingsManager.setExecutionEntriesCount(psm.getExecutionEntries());
        this.gdprSettingsManager.setTaskTimeout(psm.getTimeout());
        return Response.ok().build();
    }
}

