/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.manager;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import de.actonic.confluence.gdpr.component.manager.AbstractEntityDao;
import de.actonic.confluence.gdpr.current.datacleaner.ao.DataCleanerPostFunctionEntity;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCleanerPostFunctionDao
extends AbstractEntityDao {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerPostFunctionDao.class);

    @Autowired
    public DataCleanerPostFunctionDao(@ComponentImport ActiveObjects ao) {
        super(ao);
    }

    public DataCleanerPostFunctionEntity getById(int id) {
        return this.getFirstByField(DataCleanerPostFunctionEntity.class, "ID", id);
    }

    public DataCleanerPostFunctionEntity createEntity(int templateId, String name, String rules, String notificationType, boolean isAnyRuleEnabled, String notificationParameters) {
        DataCleanerPostFunctionEntity entity = (DataCleanerPostFunctionEntity)this.ao.create(DataCleanerPostFunctionEntity.class, new DBParam[0]);
        entity.setTemplateId(templateId);
        entity.setName(name);
        entity.setIsEnabled(true);
        entity.setRules(rules);
        entity.setNotificationType(notificationType);
        entity.setIsAnyRuleEnabled(isAnyRuleEnabled);
        entity.setNotificationParameters(notificationParameters);
        entity.save();
        return entity;
    }

    public DataCleanerPostFunctionEntity createEntity(int templateId, String name, String rules, String notificationType, boolean isAnyRuleEnabled, String notificationParameters, Boolean isEnabled) {
        DataCleanerPostFunctionEntity entity = (DataCleanerPostFunctionEntity)this.ao.create(DataCleanerPostFunctionEntity.class, new DBParam[0]);
        entity.setTemplateId(templateId);
        entity.setName(name);
        entity.setIsEnabled(isEnabled);
        entity.setRules(rules);
        entity.setNotificationType(notificationType);
        entity.setIsAnyRuleEnabled(isAnyRuleEnabled);
        entity.setNotificationParameters(notificationParameters);
        entity.save();
        return entity;
    }

    public DataCleanerPostFunctionEntity updateEntity(int id, String name, String rules, String notificationType, boolean isAnyRuleEnabled, String notificationParameters) {
        DataCleanerPostFunctionEntity entity = this.getById(id);
        entity.setName(name);
        entity.setIsEnabled(true);
        entity.setRules(rules);
        entity.setNotificationType(notificationType);
        entity.setIsAnyRuleEnabled(isAnyRuleEnabled);
        entity.setNotificationParameters(notificationParameters);
        entity.save();
        return entity;
    }

    public List<DataCleanerPostFunctionEntity> getAllEntitiesByTemplateId(int templateId) {
        Object[] entities = (DataCleanerPostFunctionEntity[])this.ao.executeInTransaction(() -> {
            Query.select();
            return (DataCleanerPostFunctionEntity[])this.ao.find(DataCleanerPostFunctionEntity.class, Query.select().where("TEMPLATE_ID = ?", new Object[]{templateId}).order("ID ASC"));
        });
        return Lists.newArrayList((Object[])entities);
    }

    public List<DataCleanerPostFunctionEntity> getPostFunctionsByTemplateAndRule(int templateId, int ruleId) {
        Query.select();
        Object[] entities = (DataCleanerPostFunctionEntity[])this.ao.find(DataCleanerPostFunctionEntity.class, Query.select().where("IS_ANY_RULE_ENABLED = ? OR TEMPLATE_ID = ? AND RULES LIKE '%?%'", new Object[]{Boolean.TRUE, templateId, String.valueOf(ruleId)}).order("ID ASC"));
        return Lists.newArrayList((Object[])entities);
    }

    public void deleteEntityById(int id) {
        DataCleanerPostFunctionEntity entity = this.getById(id);
        this.ao.delete(new RawEntity[]{entity});
    }

    public void deleteEntitiesByTemplateId(int templateId) {
        List<DataCleanerPostFunctionEntity> entities = this.getAllEntitiesByTemplateId(templateId);
        entities.forEach(e -> this.ao.delete(new RawEntity[]{e}));
    }

    public void changeEntityStatus(int id, boolean status) {
        DataCleanerPostFunctionEntity entity = this.getById(id);
        entity.setIsEnabled(status);
        entity.save();
    }
}

