/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service.anonymizer.content;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.UserResourceIdentifier;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.core.persistence.ContentEntityObjectDao;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.ChangeIndexer;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionUpdater;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.collect.Lists;
import de.actonic.confluence.gdpr.component.service.anonymizer.content.BasicContentChanger;
import de.actonic.confluence.gdpr.model.ContentChangerResult;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class DigitalSignatureChanger
extends BasicContentChanger {
    private static final Logger log = LoggerFactory.getLogger(DigitalSignatureChanger.class);
    private static final String NAME = "digitalSignature";
    public static final String GROUP = "page";
    private static final String DIGITAL_SIGNATURE_MACRO_NAME = "signature";
    private final TransactionTemplate transactionTemplate;
    private final PageManager pageManager;
    private ContentEntityObjectDao entityObjectDao;
    private final BandanaManager bandanaManager;
    private final XhtmlContent xhtmlContent;
    private ChangeIndexer changeIndexer;

    @Autowired
    protected DigitalSignatureChanger(PluginSettingsFactory pluginSettingsFactory, @ComponentImport TransactionTemplate transactionTemplate, @ComponentImport PageManager pageManager, @ComponentImport ContentEntityObjectDao entityObjectDao, @ComponentImport BandanaManager bandanaManager, @ComponentImport XhtmlContent xhtmlContent, @ComponentImport ChangeIndexer changeIndexer) {
        super(pluginSettingsFactory, transactionTemplate);
        this.transactionTemplate = transactionTemplate;
        this.pageManager = pageManager;
        this.entityObjectDao = entityObjectDao;
        this.bandanaManager = bandanaManager;
        this.xhtmlContent = xhtmlContent;
        this.changeIndexer = changeIndexer;
    }

    @Override
    public boolean isAffected(EntityObject issue, ConfluenceUser user) {
        List<ContentEntityObject> versionIssues = this.getVersionList((ContentEntityObject)issue);
        int versionIssuesSize = versionIssues.size();
        for (ContentEntityObject version : versionIssues) {
            boolean isAffected = this.isAffectedInVersion((EntityObject)version, user);
            if (!isAffected) continue;
            return true;
        }
        return false;
    }

    private boolean isAffectedInVersion(EntityObject version, ConfluenceUser user) {
        return (Boolean)this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.pageManager.getById(version.getId());
            Long pageId = ceo.getId();
            Boolean[] isFound = new Boolean[]{false};
            try {
                this.xhtmlContent.handleMacroDefinitions(ceo.getBodyAsString(), (ConversionContext)new DefaultConversionContext((RenderContext)ceo.toPageContext()), macroDefinition -> {
                    if (StringUtils.equalsIgnoreCase((String)macroDefinition.getName(), (String)DIGITAL_SIGNATURE_MACRO_NAME)) {
                        String signers = macroDefinition.getParameter("signers");
                        String notified = macroDefinition.getParameter("notified");
                        String title = macroDefinition.getParameter("title");
                        String body = macroDefinition.getBodyText();
                        String signatureKey = "signature." + DigestUtils.sha256Hex((String)(pageId + ":" + title + ":" + body));
                        Object signatureData = this.bandanaManager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, signatureKey);
                        if (signatureData != null) {
                            try {
                                Field signaturesField = ReflectionUtils.findField(signatureData.getClass(), (String)"signatures");
                                ReflectionUtils.makeAccessible((Field)signaturesField);
                                Map signaturesSign = (Map)signaturesField.get(signatureData);
                                Field missingSignaturesField = ReflectionUtils.findField(signatureData.getClass(), (String)"missingSignatures");
                                ReflectionUtils.makeAccessible((Field)missingSignaturesField);
                                Set missingSignaturesSign = (Set)missingSignaturesField.get(signatureData);
                                Field notifiedField = ReflectionUtils.findField(signatureData.getClass(), (String)"notified");
                                ReflectionUtils.makeAccessible((Field)notifiedField);
                                Set notifiedSign = (Set)notifiedField.get(signatureData);
                                if (signaturesSign.containsKey(user.getName()) || missingSignaturesSign.contains(user.getName()) || notifiedSign.contains(user.getName())) {
                                    isFound[0] = true;
                                }
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                        }
                        if (StringUtils.containsIgnoreCase((String)signers, (String)user.getName()) || StringUtils.containsIgnoreCase((String)notified, (String)user.getName())) {
                            isFound[0] = true;
                            return;
                        }
                    }
                });
            }
            catch (XhtmlException e) {
                e.printStackTrace();
            }
            return isFound[0];
        });
    }

    private UserResourceIdentifier updateUserIdentifier(UserResourceIdentifier identifier, ConfluenceUser sourceUser, ConfluenceUser targetUser) {
        UserKey userKey = identifier.getUserKey();
        if (StringUtils.equalsIgnoreCase((String)userKey.getStringValue(), (String)sourceUser.getKey().getStringValue())) {
            userKey = targetUser.getKey();
        }
        UserResourceIdentifier newSigners = UserResourceIdentifier.create((UserKey)userKey);
        return newSigners;
    }

    @Override
    public ContentChangerResult changeIssues(String currentJobId, EntityObject issue, final ConfluenceUser sourceUser, final ConfluenceUser targetUser) {
        this.setJobMessage(currentJobId, "Updating page creator...");
        String changesTotal = "";
        String changesSuccess = "";
        String changesFail = "";
        if (this.isAffected(issue, sourceUser)) {
            changesTotal = changesTotal + issue.getId() + ", ";
            List<ContentEntityObject> versionIssues = this.getVersionList((ContentEntityObject)issue);
            for (ContentEntityObject version : versionIssues) {
                boolean isAffected = this.isAffectedInVersion((EntityObject)version, sourceUser);
                if (!isAffected) continue;
                boolean isSuccess = (Boolean)this.transactionTemplate.execute(() -> {
                    final ContentEntityObject ceo = this.pageManager.getById(version.getId());
                    try {
                        DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)ceo.toPageContext());
                        String newBodyAsString = this.xhtmlContent.updateMacroDefinitions(ceo.getBodyAsString(), (ConversionContext)conversionContext, new MacroDefinitionUpdater(){

                            public MacroDefinition update(MacroDefinition macroDefinition) {
                                if (StringUtils.equalsIgnoreCase((String)macroDefinition.getName(), (String)DigitalSignatureChanger.DIGITAL_SIGNATURE_MACRO_NAME)) {
                                    String notified;
                                    String signers;
                                    Boolean hasChanges = false;
                                    Map parameters = macroDefinition.getParameters();
                                    Map typedParameters = macroDefinition.getTypedParameters();
                                    if (parameters.containsKey("signers")) {
                                        signers = (String)parameters.get("signers");
                                        signers = signers.replaceAll(sourceUser.getName(), targetUser.getName());
                                        parameters.replace("signers", signers);
                                        hasChanges = true;
                                    }
                                    if (typedParameters.containsKey("signers")) {
                                        ArrayList newSigners;
                                        signers = typedParameters.get("signers");
                                        if (signers instanceof UserResourceIdentifier) {
                                            newSigners = DigitalSignatureChanger.this.updateUserIdentifier((UserResourceIdentifier)signers, sourceUser, targetUser);
                                            typedParameters.replace("signers", newSigners);
                                        }
                                        if (signers instanceof List) {
                                            newSigners = Lists.newArrayList();
                                            ((List)((Object)signers)).forEach(s -> newSigners.add(DigitalSignatureChanger.this.updateUserIdentifier((UserResourceIdentifier)s, sourceUser, targetUser)));
                                            typedParameters.replace("signers", newSigners);
                                        }
                                        hasChanges = true;
                                    }
                                    if (parameters.containsKey("notified")) {
                                        notified = (String)parameters.get("notified");
                                        notified = notified.replaceAll(sourceUser.getName(), targetUser.getName());
                                        parameters.replace("notified", notified);
                                        hasChanges = true;
                                    }
                                    if (typedParameters.containsKey("notified")) {
                                        ArrayList newNotified;
                                        notified = typedParameters.get("notified");
                                        if (notified instanceof UserResourceIdentifier) {
                                            newNotified = DigitalSignatureChanger.this.updateUserIdentifier((UserResourceIdentifier)notified, sourceUser, targetUser);
                                            typedParameters.replace("notified", newNotified);
                                        }
                                        if (notified instanceof List) {
                                            newNotified = Lists.newArrayList();
                                            ((List)((Object)notified)).forEach(n -> newNotified.add(DigitalSignatureChanger.this.updateUserIdentifier((UserResourceIdentifier)n, sourceUser, targetUser)));
                                            typedParameters.replace("notified", newNotified);
                                        }
                                        hasChanges = true;
                                    }
                                    if (hasChanges.booleanValue()) {
                                        macroDefinition.setParameters(parameters);
                                        macroDefinition.setTypedParameters(typedParameters);
                                    }
                                    hasChanges = false;
                                    String title = macroDefinition.getParameter("title");
                                    String body = macroDefinition.getBodyText();
                                    String signatureKey = "signature." + DigestUtils.sha256Hex((String)(ceo.getId() + ":" + title + ":" + body));
                                    Object signatureData = DigitalSignatureChanger.this.bandanaManager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, signatureKey);
                                    if (signatureData != null) {
                                        try {
                                            Field signaturesField = ReflectionUtils.findField(signatureData.getClass(), (String)"signatures");
                                            ReflectionUtils.makeAccessible((Field)signaturesField);
                                            Map signaturesSign = (Map)signaturesField.get(signatureData);
                                            if (signaturesSign.containsKey(sourceUser.getName())) {
                                                Date tmp = (Date)signaturesSign.get(sourceUser.getName());
                                                signaturesSign.remove(sourceUser.getName());
                                                if (!signaturesSign.containsKey(targetUser.getName())) {
                                                    signaturesSign.put(targetUser.getName(), tmp);
                                                }
                                                signaturesField.set(signatureData, signaturesSign);
                                                hasChanges = true;
                                            }
                                            Field missingSignaturesField = ReflectionUtils.findField(signatureData.getClass(), (String)"missingSignatures");
                                            ReflectionUtils.makeAccessible((Field)missingSignaturesField);
                                            Set missingSignaturesSign = (Set)missingSignaturesField.get(signatureData);
                                            if (missingSignaturesSign.contains(sourceUser.getName())) {
                                                missingSignaturesSign.remove(sourceUser.getName());
                                                if (!missingSignaturesSign.contains(targetUser.getName())) {
                                                    missingSignaturesSign.add(targetUser.getName());
                                                }
                                                missingSignaturesField.set(signatureData, missingSignaturesSign);
                                                hasChanges = true;
                                            }
                                            Field notifiedField = ReflectionUtils.findField(signatureData.getClass(), (String)"notified");
                                            ReflectionUtils.makeAccessible((Field)notifiedField);
                                            Set notifiedSign = (Set)notifiedField.get(signatureData);
                                            if (notifiedSign.contains(sourceUser.getName())) {
                                                notifiedSign.remove(sourceUser.getName());
                                                if (!notifiedSign.contains(targetUser.getName())) {
                                                    notifiedSign.add(targetUser.getName());
                                                }
                                                notifiedField.set(signatureData, notifiedSign);
                                                hasChanges = true;
                                            }
                                            if (hasChanges.booleanValue()) {
                                                DigitalSignatureChanger.this.bandanaManager.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, signatureKey, signatureData);
                                            }
                                        }
                                        catch (IllegalAccessException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }
                                return macroDefinition;
                            }
                        });
                        ceo.setBodyAsString(newBodyAsString);
                        this.saveNewEntity(ceo, ceo);
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                });
                if (version.getId() != version.getLatestVersionId()) continue;
                if (isSuccess) {
                    changesSuccess = changesSuccess + issue.getId() + ", ";
                    continue;
                }
                changesFail = changesFail + issue.getId() + ", ";
            }
        }
        return new ContentChangerResult(this.getChangerName(), changesTotal, changesSuccess, changesFail);
    }

    @Override
    public String getChangerName() {
        return NAME;
    }

    @Override
    public String getChangerGroup() {
        return GROUP;
    }

    private void saveNewEntity(ContentEntityObject currentEntity, ContentEntityObject lastVersionEntity) {
        if (currentEntity.getVersion() != 1) {
            this.pageManager.saveContentEntity(currentEntity, (SaveContext)((DefaultSaveContext.Builder)DefaultSaveContext.builder().updateLastModifier(false).suppressAutowatch(true).suppressNotifications(true)).build());
        } else {
            this.entityObjectDao.saveRaw((EntityObject)currentEntity);
        }
        this.changeIndexer.reIndexAllVersions((Searchable)lastVersionEntity);
    }

    private List<ContentEntityObject> getVersionList(ContentEntityObject versionPage) {
        ArrayList versions = Lists.newArrayList();
        versions.add(versionPage);
        while ((versionPage = this.pageManager.getPreviousVersion(versionPage)) != null) {
            versions.add(versionPage);
        }
        return versions;
    }
}

