define("gdpr/data-cleaner/scheduler/rest", ["jquery"], function ($) {
    function Rest() {
        this.createCron = function (data, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/scheduler",
                data: JSON.stringify(data),
                contentType: "application/json",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR.responseText);
                }
            })
        }
        this.updateCron = function (id, data, successCallback, errorCallback) {
            $.ajax({
                type: "PUT",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/scheduler/" + id,
                data: JSON.stringify(data),
                contentType: "application/json",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR.responseText);
                }
            })
        }
        this.getCronsForTemplate = function (templateId, successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/scheduler/cronsForTemplate/" + templateId,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR.responseText);
                }
            })
        }
        this.isValidCron = function (cronString, successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/scheduler/cron?cron=" + cronString,
                async: false,
                cache: false,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR.responseText);
                }
            })
        }
    }

    return new Rest();
})
