/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.rest;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.security.password.Credential;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerBuiltInRuleManager;
import de.actonic.gdpr.shared.general.exception.GDPRException;
import de.actonic.gdpr.shared.general.exception.GDPRExceptionHandler;
import de.actonic.gdpr.shared.general.manager.IGDPRUserManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Path(value="/test-data")
@Produces(value={"application/json"})
public class TestDataRest {
    private final PageManager pageManager;
    private final CommentManager commentManager;
    private final SpaceManager spaceManager;
    private final UserAccessor userAccessor;
    private final GroupManager groupManager;
    private final UserManager userManager;
    private final DataCleanerBuiltInRuleManager dataCleanerBuiltInRuleManager;
    private final IGDPRUserManager gdprUserManager;
    @ComponentImport
    private final I18nResolver i18n;

    @Autowired
    public TestDataRest(@ComponentImport PageManager pageManager, @ComponentImport CommentManager commentManager, @ComponentImport SpaceManager spaceManager, @ComponentImport UserAccessor userAccessor, @ComponentImport GroupManager groupManager, @ComponentImport @Qualifier(value="userManager") UserManager userManager, DataCleanerBuiltInRuleManager dataCleanerBuiltInRuleManager, IGDPRUserManager gdprUserManager, I18nResolver i18n) {
        this.pageManager = pageManager;
        this.commentManager = commentManager;
        this.spaceManager = spaceManager;
        this.userAccessor = userAccessor;
        this.groupManager = groupManager;
        this.userManager = userManager;
        this.dataCleanerBuiltInRuleManager = dataCleanerBuiltInRuleManager;
        this.gdprUserManager = gdprUserManager;
        this.i18n = i18n;
    }

    @GET
    @Path(value="/")
    public Response generateTestData(@QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="users") String users, @QueryParam(value="pageCount") Integer pageCount, @QueryParam(value="blogCount") Integer blogCount, @QueryParam(value="withBuiltInRules") boolean withBuiltInRules) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.userManager.isAdmin(user.getKey()) && !this.userManager.isSystemAdmin(user.getKey())) {
            return Response.status((int)403).entity((Object)new Gson().toJson((Object)"You do not have permissions to create test data")).build();
        }
        List<String> userNames = this.generateUsers(users);
        try {
            if (pageCount == null || pageCount == 0) {
                pageCount = 100;
            }
            if (blogCount == null || blogCount == 0) {
                blogCount = 100;
            }
            ArrayList issueCollection = Lists.newArrayList();
            issueCollection.addAll(this.createEntities(spaceKey, userNames, pageCount, "page", withBuiltInRules));
            issueCollection.addAll(this.createEntities(spaceKey, userNames, blogCount, "blogpost", withBuiltInRules));
            return Response.ok((Object)new Gson().toJson((Object)issueCollection)).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((int)500).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/create-users")
    public Response createUsers(@QueryParam(value="users") String users) {
        try {
            this.gdprUserManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
            return Response.ok((Object)new Gson().toJson(this.generateUsers(users))).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    private List<String> generateUsers(String users) {
        String[] userNames;
        ArrayList result = Lists.newArrayList();
        for (String userName : userNames = users.split(",")) {
            ConfluenceUser applicationUser = this.userAccessor.getUserByName(userName);
            if (applicationUser == null) {
                ConfluenceUserImpl user = new ConfluenceUserImpl(userName, userName, userName + "@autogenerate");
                Credential creds = Credential.unencrypted((String)"password");
                this.userAccessor.createUser((User)user, creds);
                applicationUser = this.userAccessor.getUserByName(userName);
            }
            try {
                Group group = this.groupManager.getGroup("confluence-users");
                if (group != null && applicationUser != null) {
                    this.groupManager.addMembership(group, (User)applicationUser);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            result.add(userName);
        }
        return result;
    }

    private ConfluenceUser getRandomUser(List<String> userNames) {
        Random rand = new Random();
        return this.userAccessor.getUserByName(userNames.get(rand.nextInt(userNames.size())));
    }

    private String getRandomSummary(List<String> userNames) {
        ArrayList textPlaceholders = Lists.newArrayList((Object[])new String[]{"Get", "Set", "user", "task", "details", "after", "before", "new", "empty", "test@test.com"});
        ArrayList affectedTextSamples = Lists.newArrayList((Object[])new String[]{"[~admin]", "[~user]", "test@test.com", "+1-541-754-3010 International", "Visa 4111 1111 1111 1111", "457-55-5462 testing SSN"});
        for (String userName : userNames) {
            affectedTextSamples.add("[~" + userName + "]");
        }
        Random rand = new Random();
        int count = rand.nextInt(10) + 10;
        String result = "";
        for (int i = 0; i < count; ++i) {
            result = rand.nextInt(10) == 0 ? result + (String)affectedTextSamples.get(rand.nextInt(affectedTextSamples.size())) + " " : result + (String)textPlaceholders.get(rand.nextInt(textPlaceholders.size())) + " ";
        }
        return result;
    }

    private String getRandomDescription(List<String> userNames, boolean withBuiltInRules) {
        ArrayList textPlaceholders = Lists.newArrayList((Object[])new String[]{"Lorem ipsum dolor sit amet, pro suas voluptaria ne, autem altera mei ei. Quem hinc probo sed ei, vis in vidit soleat voluptatum, eu dicat efficiendi quo. Eam tibique vivendum ei, vim facilis detraxit ea. Sit cu tale possit. Utroque molestie ex vel, mea et errem elaboraret complectitur. Ex delenit intellegebat mea. ", "The text has been generated. ", "text", "blank", "space", "demo", "some", "description"});
        ArrayList builtInRulesPlaceholders = new ArrayList();
        this.dataCleanerBuiltInRuleManager.getAllBuiltInRulesAsText().forEach(rule -> builtInRulesPlaceholders.add(rule.getDescription()));
        ArrayList affectedTextSamples = Lists.newArrayList((Object[])new String[]{"[~admin]", "[~user]", "test@test.com", "+1-541-754-3010 International", "Visa 4111 1111 1111 1111", "457-55-5462 testing SSN"});
        for (String userName : userNames) {
            affectedTextSamples.add("[~" + userName + "]");
        }
        Random rand = new Random();
        int cycles = rand.nextInt(10) + 1;
        String result = "";
        for (int i = 0; i < cycles; ++i) {
            int randNum = rand.nextInt(10);
            result = randNum == 0 ? result + (String)affectedTextSamples.get(rand.nextInt(affectedTextSamples.size())) + " " : (withBuiltInRules && randNum == 1 ? result + (String)builtInRulesPlaceholders.get(rand.nextInt(builtInRulesPlaceholders.size())) + " " : result + (String)textPlaceholders.get(rand.nextInt(textPlaceholders.size())) + " ");
        }
        return result;
    }

    private String getRandomTitle() {
        ArrayList titleWords = Lists.newArrayList((Object[])new String[]{"Get", "Set", "user", "task", "details", "after", "before", "new", "empty", "text", "blank", "space", "demo", "some", "description"});
        Random rand = new Random();
        int cycles = rand.nextInt(5) + 1;
        String result = "";
        for (int i = 0; i < cycles; ++i) {
            result = result + (String)titleWords.get(rand.nextInt(titleWords.size())) + " ";
        }
        return result;
    }

    private List<String> createEntities(String spaceKey, List<String> userNames, int issueCount, String clazz, boolean withBuiltInRules) {
        ArrayList issueCollection = Lists.newArrayList();
        Space testSpace = this.spaceManager.getSpace(spaceKey);
        for (int i = 0; i < issueCount; ++i) {
            String title = this.getRandomTitle();
            Object page = "page".equalsIgnoreCase(clazz) ? this.pageManager.getPage(spaceKey, title) : this.pageManager.getBlogPost(spaceKey, title, Calendar.getInstance());
            if (page != null) continue;
            page = "page".equalsIgnoreCase(clazz) ? new Page() : new BlogPost();
            page.setSpace(testSpace);
            if ("page".equalsIgnoreCase(clazz)) {
                page.setParentPage(testSpace.getHomePage());
            }
            page.setCreator(this.getRandomUser(userNames));
            page.setTitle(title);
            page.setBodyAsString(this.getRandomSummary(userNames) + "\n" + this.getRandomDescription(userNames, withBuiltInRules));
            try {
                this.pageManager.saveContentEntity((ContentEntityObject)page, (SaveContext)((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)DefaultSaveContext.builder().suppressNotifications(true)).updateLastModifier(true).suppressEvents(true)).build());
                if ("page".equalsIgnoreCase(clazz)) {
                    testSpace.getHomePage().addChild(page);
                }
                issueCollection.add(page.getIdAsString());
                Random rand = new Random();
                for (int j = 0; j < rand.nextInt(10); ++j) {
                    Comment comment = new Comment();
                    comment.setCreator(this.getRandomUser(userNames));
                    comment.setBodyAsString(this.getRandomSummary(userNames) + "\n" + this.getRandomDescription(userNames, withBuiltInRules));
                    comment.setContainer((ContentEntityObject)page);
                    this.commentManager.saveContentEntity((ContentEntityObject)comment, (SaveContext)((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)DefaultSaveContext.builder().suppressNotifications(true)).updateLastModifier(true).suppressEvents(true)).build());
                    page.addComment(comment);
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return issueCollection;
    }
}

