/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.manager;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.google.common.collect.Lists;
import de.actonic.confluence.gdpr.component.manager.AbstractEntityDao;
import de.actonic.confluence.gdpr.current.datacleaner.ao.DataCleanerRuleEntity;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCleanerRuleDao
extends AbstractEntityDao {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerRuleDao.class);

    @Autowired
    public DataCleanerRuleDao(ActiveObjects ao) {
        super(ao);
    }

    public DataCleanerRuleEntity getById(int id) {
        return this.getFirstByField(DataCleanerRuleEntity.class, "ID", id);
    }

    public DataCleanerRuleEntity createEntity(int templateId, boolean enabled, String name, String searchType, String searchString, String replaceType, String replaceString) {
        DataCleanerRuleEntity entity = (DataCleanerRuleEntity)this.ao.create(DataCleanerRuleEntity.class, new DBParam[0]);
        entity.setTemplateId(templateId);
        entity.setEnabled(enabled);
        entity.setName(name);
        entity.setSearchType(searchType);
        entity.setSearchString(searchString);
        entity.setReplaceType(replaceType);
        entity.setReplaceString(replaceString);
        entity.save();
        return entity;
    }

    public DataCleanerRuleEntity updateEntity(int id, boolean enabled, String name, String searchType, String searchString, String replaceType, String replaceString) {
        DataCleanerRuleEntity entity = this.getById(id);
        entity.setEnabled(enabled);
        entity.setName(name);
        entity.setSearchType(searchType);
        entity.setSearchString(searchString);
        entity.setReplaceType(replaceType);
        entity.setReplaceString(replaceString);
        entity.save();
        return entity;
    }

    public void deleteEntity(int id) {
        DataCleanerRuleEntity entity = this.getById(id);
        this.ao.delete(new RawEntity[]{entity});
    }

    public List<DataCleanerRuleEntity> getAllEntities() {
        return Lists.newArrayList((Object[])((DataCleanerRuleEntity[])this.ao.executeInTransaction(() -> (DataCleanerRuleEntity[])this.ao.find(DataCleanerRuleEntity.class))));
    }

    public List<DataCleanerRuleEntity> getRules(int templateId) {
        Object[] entities = (DataCleanerRuleEntity[])this.ao.executeInTransaction(() -> (DataCleanerRuleEntity[])this.ao.find(DataCleanerRuleEntity.class, Query.select().where("TEMPLATE_ID = ?", new Object[]{templateId}).order("ID ASC")));
        return Lists.newArrayList((Object[])entities);
    }

    public List<DataCleanerRuleEntity> getEnabledRules(int templateId) {
        Object[] entities = (DataCleanerRuleEntity[])this.ao.executeInTransaction(() -> (DataCleanerRuleEntity[])this.ao.find(DataCleanerRuleEntity.class, Query.select().where("TEMPLATE_ID = ? AND ENABLED = ?", new Object[]{templateId, Boolean.TRUE}).order("ID ASC")));
        return Lists.newArrayList((Object[])entities);
    }

    public DataCleanerRuleEntity disable(int id) {
        return this.changeState(id, Boolean.FALSE);
    }

    public DataCleanerRuleEntity enable(int id) {
        return this.changeState(id, Boolean.TRUE);
    }

    private DataCleanerRuleEntity changeState(int id, boolean state) {
        return (DataCleanerRuleEntity)this.ao.executeInTransaction(() -> {
            DataCleanerRuleEntity entity = this.getById(id);
            entity.setEnabled(state);
            entity.save();
            return entity;
        });
    }

    public List<DataCleanerRuleEntity> getAllEntitiesByTemplateId(int templateId) {
        Object[] entities = (DataCleanerRuleEntity[])this.ao.find(DataCleanerRuleEntity.class, Query.select().where("TEMPLATE_ID = ?", new Object[]{templateId}).order("ID ASC"));
        return Lists.newArrayList((Object[])entities);
    }

    public void deleteEntityByTemplateId(int templateId) {
        List<DataCleanerRuleEntity> entities = this.getAllEntitiesByTemplateId(templateId);
        for (DataCleanerRuleEntity entity : entities) {
            this.ao.delete(new RawEntity[]{entity});
        }
    }
}

