define("actonic-gdpr/core/picker", ["jquery", "actonic-gdpr/core/flags"], function ($, flags) {

    function Picker() {
        this.initializeUserPicker = function (selectorId, multiple, currentUserName, isAppend) {
            var classes = $("#" + selectorId).attr('class');

            var parent = $("#" + selectorId).parent();
            $("#" + selectorId).remove();
            $("#s2id_" + selectorId).remove();
            if (isAppend) {
                $(parent).append("<input type=\"text\" class=\"" + classes + "\" id=\"" + selectorId + "\" name=\"" + selectorId + "\">");
            } else {
                $(parent).prepend("<input type=\"text\" class=\"" + classes + "\" id=\"" + selectorId + "\" name=\"" + selectorId + "\">");
            }

            var placeholder = multiple ?
                AJS.I18n.getText("js-core-users-picker.placeholder") :
                AJS.I18n.getText("js-core-user-picker.placeholder");

            var initialValues = [];
            var initialNames = [];
            if (currentUserName) {
                if (Array.isArray(currentUserName)) {
                    currentUserName.forEach(function (userName) {
                        initialValues.push({ id: userName, text: userName });
                        initialNames.push(userName);
                    });
                } else {
                    initialValues.push({ id: currentUserName, text: currentUserName });
                    initialNames.push(currentUserName);
                }
            }

            //log.debug("initUserSelector initialValues = " + JSON.stringify(initialValues));
            //log.debug("initUserSelector initialNames = " + JSON.stringify(initialNames));
            AJS.$("#" + selectorId).auiSelect2({
                placeholder: placeholder,
                allowClear: true,
                multiple: multiple,
                ajax: {
                    type: "GET",
                    cache: true,
                    dataType: 'json',
                    url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/picker/user",
                    data: function (term) {
                        return {
                            query: term
                        };
                    },
                    results: function (data) {
                        var results = [];
                        $.each(data, function (index, item) {
                            results.push({ id: item.id, text: item.text });
                        });
                        return {
                            results: results
                        };
                    }
                },
                initSelection: function (element, callback) {
                    //log.debug("initSelection currentUserName = " + JSON.stringify(currentUserName));
                    //log.debug("initSelection initialValues = " + JSON.stringify(initialValues));

                    if (currentUserName) {
                        if (multiple) callback(initialValues);
                        else callback({ id: currentUserName, text: currentUserName });
                    }
                }
            });

            if (currentUserName) {
                //log.debug("set initialNames = " + JSON.stringify(initialNames));
                $("#" + selectorId).val(initialNames).trigger("change");
            }

            AJS.$("#" + selectorId).on("select2-open", function () {
                $(".select2-input").attr("placeholder", AJS.I18n.getText("js-core-users-picker.start.typing.user.name.placeholder"));
            });
        }

        this.initGroupSelector = function (selectorId, currentGroupNames, multiple) {
            var parent = $("#" + selectorId).parent();
            $("#" + selectorId).remove();
            $("#s2id_" + selectorId).remove();
            $(parent).prepend("<input type=\"text\" class=\"text\" id=\"" + selectorId + "\">");

            if (!multiple) multiple = false;

            var placeholder = multiple ?
                AJS.I18n.getText("js-core-groups-picker.placeholder") :
                AJS.I18n.getText("js-core-group-picker.placeholder");

            var initialValues = [];
            if (currentGroupNames) {
                if (Array.isArray(currentGroupNames)) {
                    currentGroupNames.forEach(function (currentGroupName) {
                        initialValues.push({ id: currentGroupName, text: currentGroupName });
                    });
                } else {
                    if (multiple) {
                        initialValues.push({ id: currentGroupNames, text: currentGroupNames });
                    } else {
                        initialValues = { id: currentGroupNames, text: currentGroupNames };
                    }
                }
            }

            //log.debug("initGroupSelector currentGroupNames = " + JSON.stringify(currentGroupNames));
            //log.debug("initGroupSelector initialValues = " + JSON.stringify(initialValues));

            AJS.$("#" + selectorId).auiSelect2({
                placeholder: placeholder,
                allowClear: true,
                multiple: multiple,
                ajax: {
                    type: "GET",
                    cache: true,
                    dataType: "json",
                    url: AJS.contextPath() + "/rest/api/2/groups/picker",
                    data: function (term) {
                        return {
                            query: term,
                            maxResults: 100
                        };
                    },
                    results: function (data) {
                        var groups = data.groups;
                        var results = [];
                        $.each(groups, function (index, item) {
                            results.push({ id: item.name, text: item.name });
                        });
                        return {
                            results: results
                        };
                    }
                },
                initSelection: function (element, callback) {
                    if (currentGroupNames) {
                        callback(initialValues);
                    }
                }
            });

            if (currentGroupNames) {
                $("#" + selectorId).val(initialValues).trigger("change");
            }

            AJS.$("#" + selectorId).on("select2-open", function () {
                $(".select2-input").attr("placeholder", AJS.I18n.getText("js-core-users-picker.start.typing.group.placeholder"));
            });
        }
        // this.initializeUserPicker = function (selectorId, multiple, selectedValue) {
        //     console.log('initializeUserPicker selector', selectorId);
        //     console.log('initializeUserPicker multiple', multiple);

        //     var parent = $("#" + selectorId).parent();
        //     $("#" + selectorId).remove();
        //     $("#s2id_" + selectorId).remove();
        //     $(parent).append("<input class=\"select\" type=\"text\" id=\"" + selectorId + "\">");

        //     var initialValues = [];
        //     var initialNames = [];
        //     if (selectedValue) {
        //         if (Array.isArray(selectedValue)) {
        //             selectedValue.forEach(function (userName) {
        //                 initialValues.push({ id: userName, text: userName });
        //                 initialNames.push(userName);
        //             });
        //         } else {
        //             initialValues.push({ id: selectedValue, text: selectedValue });
        //             initialNames.push(selectedValue);
        //         }
        //     }

        //     AJS.$("#" + selectorId).auiSelect2({
        //         placeholder: AJS.I18n.getText("js-settings.user-picker.placeholder"),
        //         initSelection: function (element, callback) {
        //             if (selectedValue) {
        //                 callback({ id: selectedValue, text: selectedValue });
        //             }
        //         },
        //         dropdownAutoWidth: true,
        //         allowClear: true,
        //         minimumInputLength: 1,
        //         multiple: multiple,
        //         ajax: {
        //             type: "GET",
        //             url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/picker/user",
        //             //dataType: "json",
        //             data: function (term) {
        //                 return {
        //                     query: term
        //                 };
        //             },
        //             results: function (data) {
        //                 var results = [];
        //                 $.each(data, function (index, item) {
        //                     results.push({ id: item.id, text: item.text });
        //                 });
        //                 return {
        //                     results: results
        //                 };
        //             }
        //         }
        //     });

        //     if (selectedValue) {
        //         $("#" + selectorId).val(initialNames).trigger("change");
        //     }
        // }
        // this.initializeGroupPicker = function (userPickerSelector) {
        //     userPickerSelector.auiSelect2({
        //         placeholder: AJS.I18n.getText("js-settings.user-picker.placeholder"),
        //         initSelection: function (element, callback) {
        //             if (userPickerSelector.val()) {
        //                 callback({ id: userPickerSelector.val(), text: userPickerSelector.val() });
        //             }
        //         },
        //         dropdownAutoWidth: true,
        //         allowClear: true,
        //         minimumInputLength: 1,
        //         ajax: {
        //             type: "GET",
        //             url: AJS.contextPath() + "/rest/prototype/1/search/group",
        //             dataType: "json",
        //             data: function (term) {
        //                 return {
        //                     query: term,
        //                     maxResults: 10
        //                 };
        //             },
        //             results: function (data) {
        //                 var users = data.result;
        //                 var results = [];
        //                 $.each(users, function (index, item) {
        //                     results.push({ id: item.username, text: item.title });
        //                 });
        //                 return {
        //                     results: results
        //                 };
        //             }
        //         }
        //     });
        // }
    }

    return new Picker();
});
