require(["jquery", "gdpr/data-cleaner/scheduler/rest", "gdpr/core/utils", "actonic-gdpr/domReady", "actonic-gdpr/core/tippy", "actonic-gdpr/core/flags"],
    function ($, Rest, coreUtils, domReady, Tippy, flags) {

        domReady(function () {
            new DataCleanerScheduler().init();
        });

        function DataCleanerScheduler() {
            var _this = this;
            var templateId = coreUtils.getCurrentUrlParameterByName("id");

            this.init = function () {
                // Tippy.triggeredByClick("#cron-usage-help-btn", "#cron-usage-help");
                Rest.getCronsForTemplate(templateId, function (data) {
                    if (data && data.length > 0) {
                        var currentCron = data[0];

                        //console.log(currentCron);
                        $("#dc-cron-id").val(currentCron.id);
                        $("#dc-scheduling-enable").prop("checked", currentCron.enabled);
                        $("#dc-cron").val(currentCron.cron ? currentCron.cron : "0 0 1 * * ?");
                        $("#dc-task-type").val(currentCron.taskType).trigger("change");
                        $("#dc-cron-description").html(currentCron.humanReadable);

                        printScheduledDetails(currentCron);
                    } else {
                        $("#dc-cron").val("0 0 1 * * ?");
                        onCronFieldChange($("#dc-cron").val());
                    }
                    _this.initEvents();
                }, function () {
                    $("#dc-cron-error").html('<p>Something happens, can not load correct cron data</p>')
                })

                $("#dc-cron").on("keyup keypress blur change", function () {
                    onCronFieldChange($(this).val());
                });
            }
            this.initEvents = function () {
                $("#save-template-scheduling").on("click", function (event) {
                    var valid = _this.validate();
                    //console.log(valid);
                    if (valid.isValid) {
                        if (valid.data.id != null && valid.data.id !== "")
                            Rest.updateCron(valid.data.id, valid.data, function (data) {
                                printScheduledDetails(data);
                                $("#dc-cron-description").html(data.humanReadable);
                            }, function () {
                            })
                        else
                            Rest.createCron(valid.data, function (data) {
                                printScheduledDetails(data);
                                $("#dc-cron-id").val(data.id);
                            }, function () {
                            })

                    } else {
                        flags.simpleWarning(valid.errors)
                        event.preventDefault();
                    }
                })
            }
            this.validate = function () {
                var data = {};
                data.id = $("#dc-cron-id").val();
                data.enabled = $("#dc-scheduling-enable").prop("checked");
                data.cron = $("#dc-cron").val();
                data.templateId = templateId;
                data.taskType = $("#dc-task-type").val();

                var result = {
                    isValid: false,
                    errors: "",
                    data: data
                }

                if (data.enabled)
                    if (data.cron !== "") {
                        Rest.isValidCron(data.cron, function (data) {
                            if (data.isValid)
                                result.isValid = true;
                            else {
                                result.isValid = false;
                                result.errors = "Cron is not valid. Make sure it is not starts often than one per hour.";
                            }
                        }, function () {
                            result.isValid = false;
                            result.errors = "Could not check is cron valid"
                        })
                    } else {
                        result.isValid = false;
                        result.errors = "Cron should not be empty"
                    }
                else
                    result.isValid = true;
                return result;
            }
        }

        var taskTypes = {
            "0": "Search",
            "1": "Anonymization",
            "-1": "Undefined"
        }

        function printScheduledDetails(details) {
            if (details.enabled)
                $("#scheduling-link-subtitle").html("<p>Scheduled with - '" + details.humanReadable + "'<br>Task type - " + taskTypes[details.taskType] + "</p>");
            else
                $("#scheduling-link-subtitle").html("<p>Scheduling disabled</p>");
        }

        function onCronFieldChange(cronExp) {
            delayedFunctionsMachine.addDelayedFunction(500, "onCronFieldChange", function () {
                Rest.isValidCron(cronExp, function (data) {
                    if (data.isValid)
                        $("#dc-cron-description").text(data.humanReadable);
                    else
                        $("#dc-cron-description").text("Wrong cron expression");
                })
            });
        }

        return new DataCleanerScheduler()
    })
