/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.listener;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.gson.Gson;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerHistoryModel;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerHistoryDao;
import de.actonic.confluence.gdpr.current.datacleaner.event.DataCleanerSaveResultDataEvent;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCleanerSaveResultDataListener
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerSaveResultDataListener.class);
    @ComponentImport
    private final EventPublisher eventPublisher;
    private DataCleanerHistoryDao dataCleanerHistoryDao;
    private Gson gson = new Gson();

    @Autowired
    public DataCleanerSaveResultDataListener(EventPublisher eventPublisher, DataCleanerHistoryDao dataCleanerHistoryDao) {
        this.eventPublisher = eventPublisher;
        this.dataCleanerHistoryDao = dataCleanerHistoryDao;
        eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onSaveDataEvent(DataCleanerSaveResultDataEvent event) {
        List data = (List)event.getSource();
        for (DataCleanerHistoryModel el : data) {
            this.dataCleanerHistoryDao.create(el.getJobId(), this.gson.toJson(el.getCeo()), this.gson.toJson(el.getSpace()), el.getObject(), el.getRuleId(), el.getData(), el.getStatus(), el.getCeoCreationDate());
        }
    }
}

