/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service.anonymizer.global;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import de.actonic.confluence.gdpr.component.service.anonymizer.global.GlobalContentChanger;
import de.actonic.confluence.gdpr.model.ContentChangerResult;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeleteFromGroups
extends GlobalContentChanger {
    private static final String NAME = "deleteFromGroups";
    private static final String GROUP = "global";
    @ComponentImport
    private GroupManager groupManager;

    @Autowired
    protected DeleteFromGroups(@ComponentImport PluginSettingsFactory pluginSettingsFactory, GroupManager groupManager) {
        super(pluginSettingsFactory);
        this.groupManager = groupManager;
    }

    @Override
    public ContentChangerResult changeIssues(String currentJobId, ConfluenceUser sourceUser) {
        this.setJobMessage(currentJobId, "Remove user from all internal groups...");
        StringBuilder changesTotal = new StringBuilder();
        StringBuilder changesSuccess = new StringBuilder();
        StringBuilder changesFail = new StringBuilder();
        Pager<Group> groups = this.getGroups(sourceUser);
        if (groups != null) {
            for (Group group : groups) {
                try {
                    changesTotal.append(group.getName()).append(", ");
                    this.setJobMessage(currentJobId, "Updating group \"" + group.getName() + " \"");
                    this.groupManager.removeMembership(group, (User)sourceUser);
                    changesSuccess.append(group.getName()).append(", ");
                }
                catch (Exception e) {
                    changesFail.append(group.getName()).append(", ");
                    e.printStackTrace();
                }
            }
        } else {
            changesTotal.append("Failed to get groups");
        }
        return new ContentChangerResult(this.getChangerName(), changesTotal.toString(), changesSuccess.length() > 0 ? this.buildMessage(Arrays.asList("Successfully removed from groups ", changesSuccess.toString(), "\n")) : changesSuccess.toString(), changesFail.length() > 0 ? this.buildMessage(Arrays.asList("Failed to remove from groups ", changesFail.toString(), "\n")) : changesFail.toString());
    }

    @Override
    public String getChangerName() {
        return NAME;
    }

    @Override
    public String getChangerGroup() {
        return GROUP;
    }

    private Pager<Group> getGroups(ConfluenceUser user) {
        try {
            Pager groups = this.groupManager.getGroups((User)user);
            return groups;
        }
        catch (EntityException e) {
            e.printStackTrace();
            return null;
        }
    }
}

